# Plugin Components[¶](https://doc.dataiku.com/dss/latest/plugins/reference/plugins-components.html#plugin-components "Permalink to this headline")

A plugin is made of a number of **components**. Each component is a single kind of object in Dataiku DSS, such as a dataset, recipe, or webapp. Each component adds an additional functionality to a plugin. A plugin bundles components together as a single consistent whole.

The (non-exhaustive) list of plugin components includes:

* Dataset

* Recipe

* Format extractors

* Format exporters

* Filesystem providers

* Macros

* Metric probes and checks

* Scenario triggers and steps

* Preparation script processors

* Shared code to import in recipes or notebooks

* Webapps

* Prediction algorithm

* Custom Fields

* Parameter set

* Custom Policy Hooks

The most up-to-date list of possible components can be found in the product. In the plugin editor, click **+ Add > Create component**. The resulting dialog shows the list of possible components. When you add a component, Dataiku DSS automatically makes the appropriate additions to the plugin directory structure, and adds some starter code to help you get started.

## Structure of the plugin[¶](https://doc.dataiku.com/dss/latest/plugins/reference/plugins-components.html#structure-of-the-plugin "Permalink to this headline")

The elements of a plugin are contained within a top-level directory that identifies the plugin. When you create a plugin from scratch (called, for example, `myplugin`), that top-level directory contains:

* A `python-lib` subdirectory with a `myplugin` subdirectory that has an `\_\_init\_\_.py` file that is empty of code. The `python-lib` directory is a good place to put functions that will be reused throughout the plugin.

* A `plugin.json` file that describes the plugin as a whole. As a best practice, the `id` element of this JSON file should be the same as the name of the top-level directory.

As you add components to the plugin, this adds to the plugin folder structure. Each type of component has a subdirectory under the top-level directory. Each individual component has a directory that contains a JSON file that describes the component as a whole, and code files that define what the component does.

Each component generally has some configuration parameters.
