# Format date with custom format[¶](https://doc.dataiku.com/dss/latest/preparation/processors/date-formatter.html#format-date-with-custom-format "Permalink to this headline")

Format data in standard ISO-8601 format (`yyyy-MM-ddTHH:mm:ss.SSSZ`) to another custom date format. Use this processor to convert an ISO-8601 date into a string that may be easier to read.

## Options[¶](https://doc.dataiku.com/dss/latest/preparation/processors/date-formatter.html#options "Permalink to this headline")

**Input column**

Column containing data in ISO-8601 format. Use a Prepare step to parse your data into this format if it isn’t already.

**Date format**

Specify the custom date format of the output column using the Java syntax for date specifier.

Note

Common patterns include y (year), M (month in year), w (week in year), d (day in month), E (day name in week), a (am/pm marker), H (hour in day 0-24), h (hour in am/pm 1-12), m (minute in hour), s (second in minute), S (millisecond), Z (time zone).

**Locale**

Translate date information in locale format (like ‘mercredi’ or ‘janvier’ in French).

**Timezone**

Change the timezone from the UTC default. Options include using a TZ column, an IP column, or specifying a timezone from the dropdown.

**Output column**

Leave blank to format data in place, or create a separate output column.

Warning

If the output format is not ISO-8601, DSS will treat it as an unparsed date.

## Related resources[¶](https://doc.dataiku.com/dss/latest/preparation/processors/date-formatter.html#related-resources "Permalink to this headline")

For more information on managing dates with Dataiku DSS, please see the reference documentation.
