# Pivot[¶](https://doc.dataiku.com/dss/latest/preparation/processors/pivot.html#pivot "Permalink to this headline")

The Pivot processor transforms multiple rows into columns.

Note

This processor assumes that the values of the *index* column are sorted. See the examples in the Details section below.

## Example[¶](https://doc.dataiku.com/dss/latest/preparation/processors/pivot.html#example "Permalink to this headline")

Let’s imagine we are processing financial data, which is in ‘multiple lines’ format

### Input[¶](https://doc.dataiku.com/dss/latest/preparation/processors/pivot.html#input "Permalink to this headline")

| Company | Type | Value |

| --- | --- | --- |

| Comp.A | Revenue | 42M |

| Comp.A | Raw Margin | 9M |

| Comp.B | Revenue | 137M |

| Comp.B | Raw Margin | 3M |

| Comp.B | Net income | -11M |

### Process[¶](https://doc.dataiku.com/dss/latest/preparation/processors/pivot.html#process "Permalink to this headline")

If we pivot with:

* Index column: Company

* Labels column: Type

* Values column: Value

We obtain:

| Company | Revenue | Raw Margin | Net income |

| --- | --- | --- | --- |

| Comp.A | 42M | 9M |  |

| Comp.B | 137M | 3M | -11M |

### Details[¶](https://doc.dataiku.com/dss/latest/preparation/processors/pivot.html#details "Permalink to this headline")

Pivot generates a new row for each change of value of the *index* column. The generated rows will contain one column for each value of the *labels* column. The output values will be the values of the *values* column.

* OK

| idx1 | label1 | v1 |

| idx1 | label2 | v2 |

| idx2 | label1 | v3 |

* NOK

| idx1 | label1 | v1 |

| idx2 | label1 | v3 |

| idx1 | label2 | v2 |

In the latter case, 3 rows will be generated.

Also, if several rows have the same (index,label), then only the value corresponding to the last one is kept.
