# Code studios[¶](https://doc.dataiku.com/dss/latest/python-api/code-studios.html#code-studios "Permalink to this headline")

The API offers methods to:

* Create and list code studios

* Start/stop them and trigger file synchronizations

For code studio templates, the API offers methods to:

* list code studio templates

* build them

## Build a code studio template[¶](https://doc.dataiku.com/dss/latest/python-api/code-studios.html#build-a-code-studio-template "Permalink to this headline")

§ client = dataiku.api\_client()

§ template\_id = "my\_template\_id"

§ # Obtain a handle on the code studio template

§ my\_template = client.get\_code\_studio\_template(template\_id)

§ # Build the template. This operation is asynchronous

§ build\_template = my\_template.build()

§ build\_template.wait\_for\_result()

## Reference documentation[¶](https://doc.dataiku.com/dss/latest/python-api/code-studios.html#reference-documentation "Permalink to this headline")

*class* `dataikuapi.dss.codestudio.``DSSCodeStudioObject`(*client*, *project\_key*, *code\_studio\_id*)

A handle to manage a code studio object of a project

`delete`()

Delete the code studio

`get_settings`()

Get the code studio object’s definition

* Returns: a handle to manage the code studio definition

* Return type: `dataikuapi.dss.codestudio.DSSCodeStudioObjectSettings`

`get_status`()

Get the code studio object’s state

* Returns: a handle to inspect the code studio state

* Return type: `dataikuapi.dss.codestudio.DSSCodeStudioObjectStatus`

`stop`()

Stop a running code studio

* Returns: a future to wait on the stop, or None if already stopped

* Return type: `dataikuapi.dss.future.DSSFuture`

`restart`()

Restart a code studio

* Returns: a future to wait on the start

* Return type: `dataikuapi.dss.future.DSSFuture`

`check_conflicts`(*zone*)

Checks whether the files in a zone of the code studio have conflicting changes with what the DSS instance has

* Parameters: **zone** (*str*) – name of the zone to check (see `dataikuapi.dss.codestudio.DSSCodeStudioObjectStatus.get\_zones()`)

* Returns: a summary of the conflicts that were found

`pull_from_code_studio`(*zone*)

Copies the files from a zone of the code studio to the DSS instance

* Parameters: **zone** (*str*) – name of the zone to pull (see `dataikuapi.dss.codestudio.DSSCodeStudioObjectStatus.get\_zones()`)

* Returns: a dictionary mapping each zone to the changes that were foiund

`push_to_code_studio`(*zone*)

Copies the files from the DSS instance to a zone of the code studio

* Parameters: **zone** (*str*) – name of the zone to push (see `dataikuapi.dss.codestudio.DSSCodeStudioObjectStatus.get\_zones()`)

* Returns: a dictionary of {count: <number of files copied>, size: <total size copied>}

*class* `dataikuapi.dss.codestudio.``DSSCodeStudioObjectListItem`(*client*, *project\_key*, *data*)

An item in a list of code studios. Do not instantiate this class, use `dataikuapi.dss.project.DSSProject.list\_code\_studios()`

`to_code_studio`()

Gets the `DSSCodeStudioObject` corresponding to this code studio object

*property* `name`

*property* `id`

*property* `owner`

*property* `template_id`

*property* `template_label`

*property* `template_description`

*class* `dataikuapi.dss.codestudio.``DSSCodeStudioObjectSettings`(*client*, *project\_key*, *code\_studio\_id*, *settings*)

Settings for the code studio object

`get_raw`()

Gets all settings as a raw dictionary. This returns a reference to the raw settings, not a copy,

*property* `template_id`

*property* `lib_name`

*class* `dataikuapi.dss.codestudio.``DSSCodeStudioObjectStatus`(*client*, *project\_key*, *code\_studio\_id*, *status*)

Status of a code studio object

`get_raw`()

Gets the status as a raw dictionary. This returns a reference to the raw status, not a copy,

*property* `state`

*property* `last_state_change`

`get_zones`(*as\_type='names'*)

Get the list of the zones synchronized inside the code studio

*class* `dataikuapi.dss.admin.``DSSCodeStudioTemplateListItem`(*client*, *data*)

An item in a list of code studio templates. Do not instantiate this class, use `dataikuapi.DSSClient.list\_code\_studio\_templates()`

`to_code_studio_template`()

Gets the `DSSCodeStudioTemplate` corresponding to this code studio template

*property* `label`

*property* `id`

*property* `build_for_configs`

*property* `last_built`

*class* `dataikuapi.dss.admin.``DSSCodeStudioTemplate`(*client*, *template\_id*)

A handle to interact with a code studio template on the DSS instance

`get_settings`()

Get the template’s settings.

* Returns: a `DSSCodeStudioTemplateSettings` object to interact with code studio template settings

* Return type: `DSSCodeStudioTemplateSettings`

`build`()

Build or rebuild the template.

* Returns: a `DSSFuture` handle to the task of building the image

*class* `dataikuapi.dss.admin.``DSSCodeStudioTemplateSettings`(*client*, *template\_id*, *settings*)

The settings of a code studio template

`get_raw`()

Gets all settings as a raw dictionary. This returns a reference to the raw settings, not a copy,

`get_built_for_all_container_confs`()

Return whether the template an image for each container config

`get_built_container_confs`()

Return the list of container configs for which the template builds an image (if not all)

`set_built_container_confs`(*\*configs*, *\*\*kwargs*)

Set the list of container configs for which the template builds an image

* Parameters: * **all** (*boolean*) – if True, an image is built for each config
* **configs** (*list*) – list of configuration names to build images for

`save`()

Saves the settings of the code studio template
