# Dataiku applications[¶](https://doc.dataiku.com/dss/latest/python-api/dataiku-application.html#dataiku-applications "Permalink to this headline")

The API offers methods to:

* Create and list instances of an application

* Manipulate the manifest of an application

## Reference documentation[¶](https://doc.dataiku.com/dss/latest/python-api/dataiku-application.html#reference-documentation "Permalink to this headline")

*class* `dataikuapi.dss.app.``DSSApp`(*client*, *app\_id*)

A handle to interact with an application on the DSS instance. Do not create this class directly, instead use `dataikuapi.DSSClient.get\_app()`

`create_instance`(*instance\_key*, *instance\_name*, *wait=True*)

Creates a new instance of this application. Each instance. must have a globally unique instance key, separate from any project key across the whole DSS instance

* Returns:

`make_random_project_key`()

`create_temporary_instance`()

Creates a new temporary instance of this application. The return value should be used as a Python context manager. Upon exit, the temporary app instance is deleted :return a `TemporaryDSSAppInstance`

`list_instance_keys`()

List the existing instances of this app

:return a list of instance keys, each as a string

`list_instances`()

List the existing instances of this app

:return a list of instances, each as a dict containing at least a “projectKey” field :rtype: list of dicts

`get_instance`(*instance\_key*)

`get_manifest`()

*class* `dataikuapi.dss.app.``DSSAppInstance`(*client*, *project\_key*)

`get_as_project`()

Get the `dataikuapi.dss.project DSSProject` corresponding to this application instance

`get_manifest`()

Get the application manifest for this instance, as a `DSSAppManifest`

*class* `dataikuapi.dss.app.``DSSAppManifest`(*client*, *raw\_data*, *project\_key=None*)

`get_raw`()

`get_all_actions`()

`get_runnable_scenarios`()

Return the scenario identifiers that are declared as actions for this app

`save`()

Saves the changes to this manifest object back to the template project

*class* `dataikuapi.dss.app.``TemporaryDSSAppInstance`(*client*, *project\_key*)

internal class

`close`()
