# Discussions[¶](https://doc.dataiku.com/dss/latest/python-api/discussions.html#discussions "Permalink to this headline")

You can interact with the discussions on each DSS object through the API.

* Obtaining the discussions

* List the discussions of an object

* Reading the messages of a discussion

* Adding a new message to a discussion

* Creating a new discussion

* Reference documentation

## Obtaining the discussions[¶](https://doc.dataiku.com/dss/latest/python-api/discussions.html#obtaining-the-discussions "Permalink to this headline")

The first step is always to retrieve a `DSSObjectDiscussions` object corresponding to the DSS object your manipulating. Generally, it’s through a method called `get\_object\_discussionss`

§ # Get the discussions of a dataset

§ discussions = dataset.get\_object\_discussions()

§ # Get the discussion of a wiki article

§ discussions = wiki.get\_article("my article").get\_object\_discussions()

§ # Get the discussions of a project

§ discussions = project.get\_object\_discussions()

§ # ...

## List the discussions of an object[¶](https://doc.dataiku.com/dss/latest/python-api/discussions.html#list-the-discussions-of-an-object "Permalink to this headline")

§ for discussion in discussions.list\_discussions():

§ # Discussion is a DSSDiscussion object

§ print("Discussion with id: %s" % discussion.discussion\_id)

## Reading the messages of a discussion[¶](https://doc.dataiku.com/dss/latest/python-api/discussions.html#reading-the-messages-of-a-discussion "Permalink to this headline")

§ for message in discussion.get\_replies():

§ print("Message by author %s" % message.get\_author())

§ print("Message posted on %s" % message.get\_timestamp())

§ print("Message content: %s" % message.get\_text())

## Adding a new message to a discussion[¶](https://doc.dataiku.com/dss/latest/python-api/discussions.html#adding-a-new-message-to-a-discussion "Permalink to this headline")

§ discussion.add\_reply("hello world\n# This is Markdown")

## Creating a new discussion[¶](https://doc.dataiku.com/dss/latest/python-api/discussions.html#creating-a-new-discussion "Permalink to this headline")

§ new\_discussion = discussions.create\_discussion("Topic", "Hello, this is the message")

## Reference documentation[¶](https://doc.dataiku.com/dss/latest/python-api/discussions.html#reference-documentation "Permalink to this headline")

*class* `dataikuapi.dss.discussion.``DSSObjectDiscussions`(*client*, *project\_key*, *object\_type*, *object\_id*)

A handle to manage discussions on a DSS object

`list_discussions`()

Get the list of discussions on the object

* Returns: list of discussions on the object

* Return type: list of `dataikuapi.dss.discussion.DSSDiscussion`

`create_discussion`(*topic*, *message*)

Create a new discussion

* Parameters: * **topic** (*str*) – the discussion topic
* **message** (*str*) – the markdown formatted first message

* Returns: the newly created discussion

* Return type: `dataikuapi.dss.discussion.DSSDiscussion`

`get_discussion`(*discussion\_id*)

Get a specific discussion

* Parameters: **discussion\_id** (*str*) – the discussion ID

* Returns: the discussion

* Return type: `dataikuapi.dss.discussion.DSSDiscussion`

*class* `dataikuapi.dss.discussion.``DSSDiscussion`(*client*, *project\_key*, *object\_type*, *object\_id*, *discussion\_id*, *discussion\_data*, *discussion\_data\_has\_replies*)

Do not call directly, use `dataikuapi.dss.discussion.DSSObjectDiscussions.get\_discussion()`

`get_metadata`()

Get the discussion metadata

* Returns: the discussion metadata

* Return type: dict

`set_metadata`(*discussion\_metadata*)

Update the discussion metadata

* Parameters: **discussion\_metadata** (*dict*) – the discussion metadata

`get_replies`()

Get the list of replies in this discussion

* Returns: a list of replies

* Return type: list of `dataikuapi.dss.discussion.DSSDiscussionReply`

`add_reply`(*text*)

Add a reply to a discussion

* Parameters: **text** (*str*) – the markdown formatted text to reply

*class* `dataikuapi.dss.discussion.``DSSDiscussionReply`(*reply\_data*)

A read-only handle to access a discussion reply

`get_raw_data`()

Get the reply raw data

* Returns: the reply data

* Return type: dict

`get_text`()

Get the reply text

* Returns: the reply text

* Return type: str

`get_author`()

Get the reply author

* Returns: the author ID

* Return type: str

`get_timestamp`()

Get the reply timestamp

* Returns: the reply timestamp

* Return type: long

`get_edited_timestamp`()

Get the last edition timestamp

* Returns: the last edition timestamp

* Return type: long
