# Experiment Tracking[¶](https://doc.dataiku.com/dss/latest/python-api/experiment-tracking.html#experiment-tracking "Permalink to this headline")

For an introduction to Experiment Tracking in DSS, please see Experiment Tracking.

Experiment Tracking in DSS uses the MLflow Tracking API.

This section focuses on Dataiku-specific Extensions to the MLflow API

## API Reference[¶](https://doc.dataiku.com/dss/latest/python-api/experiment-tracking.html#api-reference "Permalink to this headline")

*class* `dataikuapi.dss.mlflow.``DSSMLflowExtension`(*client*, *project\_key*)

A handle to interact with specific endpoints of the DSS MLflow integration.

Do not create this directly, use `dataikuapi.dss.project.DSSProject.get\_mlflow\_extension()`

`list_models`(*run\_id*)

Returns the list of models of given run

* Parameters: **run\_id** (*str*) – run\_id for which to return a list of models

`list_experiments`(*view\_type='ACTIVE\_ONLY'*, *max\_results=1000*)

Returns the list of experiments in the DSS project for which MLflow integration is setup

* Parameters: * **view\_type** (*str*) – ACTIVE\_ONLY, DELETED\_ONLY or ALL
* **max\_results** (*int*) – max results count

* Return type: dict

`rename_experiment`(*experiment\_id*, *new\_name*)

Renames an experiment

* Parameters: * **experiment\_id** (*str*) – experiment id
* **new\_name** (*str*) – new name

`restore_experiment`(*experiment\_id*)

Restores a deleted experiment

* Parameters: **experiment\_id** (*str*) – experiment id

`restore_run`(*run\_id*)

Restores a deleted run

* Parameters: **run\_id** (*str*) – run id

`garbage_collect`()

Permanently deletes the experiments and runs marked as “Deleted”

`create_experiment_tracking_dataset`(*dataset\_name*, *experiment\_ids=[]*, *view\_type='ACTIVE\_ONLY'*, *filter\_expr=''*, *order\_by=[]*, *format='LONG'*)

Creates a virtual dataset exposing experiment tracking data.

* Parameters: * **dataset\_name** (*str*) – name of the dataset
* **experiment\_ids** (*list**(**str**)*) – list of ids of experiments to filter on. No filtering if empty
* **view\_type** (*str*) – one of ACTIVE\_ONLY, DELETED\_ONLY and ALL. Default is ACTIVE\_ONLY
* **filter\_expr** (*str*) – MLflow search expression
* **order\_by** (*list**(**str**)*) – list of order by clauses. Default is ordered by start\_time, then runId
* **format** (*str*) – LONG or JSON. Default is LONG

`clean_experiment_tracking_db`()

Cleans the experiments, runs, params, metrics, tags, etc. for this project

This call requires an API key with admin rights

`set_run_inference_info`(*run\_id*, *prediction\_type*, *classes=None*, *code\_env\_name=None*, *target=None*)

Sets the type of the model, and optionally other information useful to deploy or evaluate it.

prediction\_type must be one of: - REGRESSION - BINARY\_CLASSIFICATION - MULTICLASS - OTHER

Classes must be specified if and only if the model is a BINARY\_CLASSIFICATION or MULTICLASS model.

This information is leveraged to filter saved models on their prediction type and prefill the classes when deploying using the GUI an MLflow model as a version of a DSS Saved Model.

* Parameters: * **prediction\_type** (*str*) – prediction type (see doc)
* **run\_id** (*str*) – run\_id for which to set the classes
* **classes** (*list*) – ordered list of classes (not for all prediction types, see doc). Every class will be converted by calling str().
* **code\_env\_name** (*str*) – name of an adequate DSS python code environment
* **target** (*str*) – name of the target
