# Govern Roles and Permissions Handler[¶](https://doc.dataiku.com/dss/latest/python-api/govern/govern-admin-roles-permissions-handler.html#govern-roles-and-permissions-handler "Permalink to this headline")

The Roles and Permissions Handler is used to manage roles, role assignments and permissions.

## Add a rule to assign a role to a new user[¶](https://doc.dataiku.com/dss/latest/python-api/govern/govern-admin-roles-permissions-handler.html#add-a-rule-to-assign-a-role-to-a-new-user "Permalink to this headline")

§ import dataikuapi

§ host = "http(s)://DSS\_HOST:DSS\_PORT"

§ apiKey = "Your API key secret"

§ client = dataikuapi.GovernClient(host, apiKey)

§ # get the role and permissions editor

§ rp\_editor = client.get\_roles\_permissions\_handler()

§ # retrieve the role assignements for the Business initiative blueprint

§ bi\_ra = rp\_editor.get\_role\_assignments('bp.system.business\_initiative')

§ # get the definition

§ bi\_ra\_def = bi\_ra.get\_definition()

§ # add a rule to assign the new user to the project manager role

§ project\_manager\_def = bi\_ra\_def.get\_raw()['roleAssignmentsRules'].get('ro.project\_manager', [])

§ project\_manager\_def.append({

§ "criteria": [],

§ "userContainers": [{"type": "user", "login": "new\_user"}]

§ })

§ bi\_ra\_def.get\_raw()['roleAssignmentsRules']['ro.project\_manager'] = project\_manager\_def

§ bi\_ra\_def.save()

## Reference API doc[¶](https://doc.dataiku.com/dss/latest/python-api/govern/govern-admin-roles-permissions-handler.html#reference-api-doc "Permalink to this headline")

*class* `dataikuapi.govern.admin_roles_permissions_handler.``GovernAdminRolesPermissionsHandler`(*client*)

Handle to edit the roles and permissions Do not create this directly, use `get\_roles\_permissions\_handler()`

`list_roles`()

List roles

* Returns: a list of roles

* Return type: list of `GovernAdminRoleListItem`

`get_role`(*role\_id*)

Return a specific role on the Govern instance

* Parameters: **role\_id** (*str*) – Identifier of the role

* Return type: `GovernAdminRole`

`create_role`(*new\_identifier*, *role*)

Create a new role and returns the handle to interact with it.

* Parameters: * **new\_identifier** (*str*) – Identifier of the new role. Allowed characters are letters, digits, hyphen, and underscore.
* **role** (*dict*) – The definition of the role.

* Return type: `GovernAdminRole`

`list_role_assignments`()

List the blueprint role assignments

* Returns: A list of role assignments for each blueprint

* Return type: list of `GovernAdminBlueprintRoleAssignmentsListItem`

`get_role_assignments`(*blueprint\_id*)

Get the role assignments for a specific blueprint. Returns a handle to interact with it.

* Parameters: **blueprint\_id** (*str*) – id of the blueprint

* Returns: A object representing the role assignments for this blueprint

* Return type: `GovernAdminBlueprintRoleAssignments`

`create_role_assignments`(*role\_assignments*)

Create a role assignments on the Govern instance and returns the handle to interact with it.

* Parameters: **role\_assignment** (*dict*) – Blueprint permission as a dict

* Returns: The newly created role assignment.

* Return type: `GovernAdminBlueprintRoleAssignments`

`get_default_permissions_definition`()

Get the default permissions definition.

* Returns: A permissions object

* Return type: `GovernAdminDefaultPermissionsDefinition`

`list_blueprint_permissions`()

List blueprint permissions

* Returns: A list of blueprint permissions

* Return type: list of `GovernAdminBlueprintPermissionsListItem`

`get_blueprint_permissions`(*blueprint\_id*)

Get the permissions for a specific blueprint. Returns a handle to interact with the permissions

* Parameters: **blueprint\_id** (*str*) – id of the blueprint for which you need the permissions

* Returns: A permissions object for the specific blueprint

* Return type: `GovernAdminBlueprintPermissions`

`create_blueprint_permissions`(*blueprint\_permission*)

Create blueprint permissions and returns the handle to interact with it.

* Parameters: **blueprint\_permission** (*dict*) – Blueprint permission as a dict

* Returns: the newly created permissions object

* Return type: `GovernAdminBlueprintPermissions`

*class* `dataikuapi.govern.admin_roles_permissions_handler.``GovernAdminRoleListItem`(*client*, *data*)

An item in a list of roles. Do not create this directly, use `list\_roles()`

`get_raw`()

Get the raw content of the role list item

* Returns: the raw content of the role list item as a dict

* Return type: dict

`to_role`()

Gets the `GovernAdminRole` corresponding to this role object

* Returns: the role object

* Return type: a `GovernAdminRole`

*class* `dataikuapi.govern.admin_roles_permissions_handler.``GovernAdminRole`(*client*, *role\_id*)

A handle to interact with the roles of the instance as an admin. Do not create this directly, use `get\_role()`

`get_definition`()

Return the information of the role as an object

* Returns: the information of the role.

* Return type: `GovernAdminRoleDefinition`

`delete`()

Delete the role

* Returns: None

*class* `dataikuapi.govern.admin_roles_permissions_handler.``GovernAdminRoleDefinition`(*client*, *role\_id*, *definition*)

The definition of a specific role. Do not create this directly, use `get\_definition()`

`get_raw`()

Get raw information of the role.

* Returns: the raw definition of role, as a dict. Modifications made to the returned object are reflected when saving

* Return type: dict

`save`()

Save this information back to the role

* Returns: None

*class* `dataikuapi.govern.admin_roles_permissions_handler.``GovernAdminBlueprintRoleAssignmentsListItem`(*client*, *data*)

An item in a list of blueprint role assignments. Do not create this directly, use `list\_role\_assignments()`

`get_raw`()

Get the raw content of the blueprint role assignments list item

* Returns: the raw content of the blueprint role assignments list item as a dict

* Return type: dict

`to_blueprint_role_assignments`()

Gets the `GovernAdminBlueprintRoleAssignments` corresponding to this blueprint role assignments object

* Returns: the blueprint role assignments object

* Return type: a `GovernAdminBlueprintRoleAssignments`

*class* `dataikuapi.govern.admin_roles_permissions_handler.``GovernAdminBlueprintRoleAssignments`(*client*, *blueprint\_id*)

A handle to interact with the blueprint role assignments for a specific blueprint Do not create this directly, use `get\_role\_assignments()`

`get_definition`()

Get the role assignments definition. Returns a handle to interact with it.

* Returns: The role assignments for a specific blueprint.

* Return type: `GovernAdminBlueprintRoleAssignments`

`delete`()

Delete the role assignments for a specific blueprint.

* Returns: None

*class* `dataikuapi.govern.admin_roles_permissions_handler.``GovernAdminBlueprintRoleAssignmentsDefinition`(*client*, *blueprint\_id*, *definition*)

The role assignments for a specific blueprint. Do not create this class directly, instead use `get\_definition()`

`get_raw`()

Get the raw content definition of the assignments for this blueprint. This returns a reference to the raw assignments, not a copy, so changes made to the returned object will be reflected when saving.

* Return type: dict

`save`()

Save this role assignments.

* Returns: None

*class* `dataikuapi.govern.admin_roles_permissions_handler.``GovernAdminBlueprintPermissionsListItem`(*client*, *data*)

An item in a list of blueprint permissions. Do not create this directly, use `list\_blueprint\_permissions()`

`get_raw`()

Get the raw content of the blueprint permissions list item

* Returns: the raw content of the blueprint permissions list item as a dict

* Return type: dict

`to_blueprint_permissions`()

Gets the `GovernAdminBlueprintPermissions` corresponding to this blueprint permissions object

* Returns: the blueprint permissions object

* Return type: a `GovernAdminBlueprintPermissions`

*class* `dataikuapi.govern.admin_roles_permissions_handler.``GovernAdminBlueprintPermissions`(*client*, *blueprint\_id*)

A handle to interact with blueprint permissions for a specific blueprint Do not create this directly, use `get\_blueprint\_permissions()`

`get_definition`()

Get the blueprint permissions definition. Returns a handle to interact with it.

* Returns: The permissions definition for a specific blueprint.

* Return type: `GovernAdminBlueprintPermissionsDefinition`

`delete`()

Delete the permissions for this blueprint and use default permissions instead.

* Returns: None

*class* `dataikuapi.govern.admin_roles_permissions_handler.``GovernAdminBlueprintPermissionsDefinition`(*client*, *blueprint\_id*, *definition*)

The permissions for a specific blueprint. Do not create this class directly, instead use `get\_definition()`

`get_raw`()

Get the raw content of the permissions for this blueprint. This returns a reference to the raw permissions, not a copy, so changes made to the returned object will be reflected when saving.

* Return type: dict

`save`()

Save this permission back to the blueprint permission definition.

* Returns: None

*class* `dataikuapi.govern.admin_roles_permissions_handler.``GovernAdminDefaultPermissionsDefinition`(*client*, *definition*)

The default permissions of the instance Do not create this directly, use `get\_default\_permissions\_definition()`

`get_raw`()

Get the raw content of the default permissions. This returns a reference to the raw permissions, not a copy, so changes made to the returned object will be reflected when saving.

* Return type: dict

`save`()

Save the default permissions

* Returns: None
