# Python APIs[¶](https://doc.dataiku.com/dss/latest/python-api/rest-api-client/index.html#python-apis "Permalink to this headline")

DSS comes with a complete set of Python API.

In many parts of DSS, you can write Python code (recipes, notebooks, scenarios, webapps, …). This Python code interacts with DSS (for example, to read datasets) using the Python APIs of DSS.

In addition, you can use the Python APIs to automate many parts of the interaction with DSS.

Most of the Python APIs can be used both *within* DSS and *outside* of DSS.

The Dataiku Python APIs are contained within two Python packages:

* The `dataikuapi` package contains a wrapper for the public REST API, allowing you to automate all kinds of tasks in DSS

* The `dataiku` package contains lower-level interaction, notably what you would in most cases use in recipes, notebooks, …

* Using the APIs inside of DSS

* Using the APIs outside of DSS

* Datasets (introduction)

* Datasets (reading and writing data)

* Datasets (other operations)

* Datasets (reference)

* Feature Store

* Managed folders

* Streaming Endpoints

* Interaction with Pyspark

* The main DSSClient class

* Projects

* Project folders

* Project libraries

* Recipes

* Interaction with saved models

* Scenarios

* Scenarios (in a scenario)

* Flow creation and management

* Machine learning

* Experiment Tracking

* Statistics worksheets

* Code studios

* API Designer & Deployer

* Project Deployer

* Static insights

* Jobs

* Authentication information and impersonation

* Importing tables as datasets

* Wikis

* Discussions

* Performing SQL, Hive and Impala queries

* SQL Query

* Meanings

* Users and groups

* Connections

* Code envs

* Plugins

* Macros

* Dataiku applications

* Metrics and checks

* Model Evaluation Stores

* Other administration tasks

* Utilities

* Reference API documentation of `dataiku`

* Reference API documentation of `dataikuapi`

* API for plugin components

* Clusters

* Code studios

* API for Fleet Manager

* API for Dataiku Govern

* Workspaces

* Webapps
