# Interaction with saved models[¶](https://doc.dataiku.com/dss/latest/python-api/saved_models.html#interaction-with-saved-models "Permalink to this headline")

This is the main class that you will use in Python recipes and the iPython notebook.

For starting code samples, please see Python recipes.

As an example, see the following example of code to retrieve the associated scikit model with your DSS:

§ import dataiku

§ m = dataiku.Model(my\_model\_id)

§ my\_predictor = m.get\_predictor()

§ my\_clf = my\_predictor.\_clf

*class* `dataiku.``Model`(*lookup*, *project\_key=None*, *ignore\_flow=False*)

This is a handle to interact with a saved model

*static* `list_models`(*project\_key=None*)

Retrieve the list of saved models

* Parameters: **project\_key** – key of the project from which to list models

`get_info`()

`get_id`()

Get the unique identifier of the model

`get_name`()

Get the name of the model

`get_type`()

Get the type of the model, prediction or clustering

`get_definition`()

`list_versions`()

List the versions this saved model contains

`activate_version`(*version\_id*)

Activate a version in the model

* Parameters: **version\_id** – the unique identifier of the version to activate

`get_version_metrics`(*version\_id*)

Get the training metrics of a version of this model, as a `SavedModelVersionMetrics`

* Parameters: **version\_id** – the unique identifier of the version for which to retrieve metrics

`save_external_check_values`(*values\_dict*, *version\_id*)

Save checks on this model. The checks are saved with the type “external”

* Parameters: **values\_dict** – the values to save, as a dict. The keys of the dict are used as check names

`get_predictor`(*version\_id=None*)

Returns a Predictor for the given version of this Saved Model. If no version is specified, the current active version will be used.

*class* `dataiku.core.saved_model.``SavedModelVersionMetrics`(*metrics*, *version\_id*)

Handle to the metrics of a version of a saved model

`get_performance_values`()

Retrieve the metrics as a dict

`get_computed`()
