# Wikis[¶](https://doc.dataiku.com/dss/latest/python-api/wiki.html#wikis "Permalink to this headline")

You can interact with the Wiki of each project through the API.

* Getting the DSSWiki object

* Retrieving and modifying the content of an article

* Deleting an article

* Getting the list of all articles

* Uploading an attachment to an article

* Moving an article in the taxonomy

* Changing the home article of the wiki

* Reference documentation

## Getting the DSSWiki object[¶](https://doc.dataiku.com/dss/latest/python-api/wiki.html#getting-the-dsswiki-object "Permalink to this headline")

You must first retrieve the `DSSWiki` through the `get\_wiki()` method

§ project = client.get\_project("MYPROJECT")

§ wiki = project.get\_wiki()

## Retrieving and modifying the content of an article[¶](https://doc.dataiku.com/dss/latest/python-api/wiki.html#retrieving-and-modifying-the-content-of-an-article "Permalink to this headline")

§ article = wiki.get\_article("article\_name")

§ article\_data = article.get\_data()

§ # Modify the content of the article data

§ current\_markdown\_content = article\_data.get\_body()

§ article\_data.set\_body("# My new Markdown content")

§ # And save the modified content

§ article\_data.save()

## Deleting an article[¶](https://doc.dataiku.com/dss/latest/python-api/wiki.html#deleting-an-article "Permalink to this headline")

§ article = wiki.get\_article("article\_name")

§ article.delete()

## Getting the list of all articles[¶](https://doc.dataiku.com/dss/latest/python-api/wiki.html#getting-the-list-of-all-articles "Permalink to this headline")

This prints the content of all articles in the Wiki

§ for article in wiki.list\_articles():

§ print("Article: %s" % article.article\_id)

§ article\_data = article.get\_data()

§ print("Content:")

§ print(article\_data.get\_body())

## Uploading an attachment to an article[¶](https://doc.dataiku.com/dss/latest/python-api/wiki.html#uploading-an-attachment-to-an-article "Permalink to this headline")

After upload, the attachment can be referenced through the Markdown syntax

§ article = wiki.get\_article("article\_name")

§ with open("myimage.jpg") as f:

§ article.upload\_attachment(f, "myimage.jpg")

## Moving an article in the taxonomy[¶](https://doc.dataiku.com/dss/latest/python-api/wiki.html#moving-an-article-in-the-taxonomy "Permalink to this headline")

You can change the parent of an article

§ settings = wiki.get\_settings()

§ settings.move\_article\_in\_taxonomy("article\_name", "new\_parent\_of\_the\_article")

§ settings.save()

## Changing the home article of the wiki[¶](https://doc.dataiku.com/dss/latest/python-api/wiki.html#changing-the-home-article-of-the-wiki "Permalink to this headline")

§ settings = wiki.get\_settings()

§ settings.set\_home\_article\_id("new\_home\_article")

§ settings.save()

## Reference documentation[¶](https://doc.dataiku.com/dss/latest/python-api/wiki.html#reference-documentation "Permalink to this headline")

*class* `dataikuapi.dss.wiki.``DSSWiki`(*client*, *project\_key*)

A handle to manage the wiki of a project

`get_settings`()

Get wiki settings

* Returns: a handle to manage the wiki settings (taxonomy, home article)

* Return type: `dataikuapi.dss.wiki.DSSWikiSettings`

`get_article`(*article\_id\_or\_name*)

Get a wiki article

* Parameters: **article\_id\_or\_name** (*str*) – reference to the article, it can be its ID or its name

* Returns: a handle to manage the Article

* Return type: `dataikuapi.dss.wiki.DSSWikiArticle`

`list_articles`()

Get a list of all the articles in form of `dataikuapi.dss.wiki.DSSWikiArticle` objects

* Returns: list of articles

* Return type: list of `dataikuapi.dss.wiki.DSSWikiArticle`

`create_article`(*article\_name*, *parent\_id=None*, *content=None*)

Create a wiki article

* Parameters: * **article\_name** (*str*) – the article name
* **parent\_id** (*str*) – the parent article ID (or None if the article has to be at root level)
* **content** (*str*) – the article content

* Returns: the created article

* Return type: `dataikuapi.dss.wiki.DSSWikiArticle`

`get_export_stream`(*paper\_size='A4'*, *export\_attachment=False*)

Download the whole wiki of the project in PDF format as a binary stream. Warning: this stream will monopolize the DSSClient until closed.

* Parameters: * **paper\_size** (*str*) – the format of the exported page, can be one of ‘A4’, ‘A3’, ‘US\_LETTER’ or ‘LEDGER’
* **export\_attachment** (*bool*) – export the attachments of the article(s) in addition to the pdf in a zip file

* Returns: the exported pdf or zip file as a stream

`export_to_file`(*path*, *paper\_size='A4'*, *export\_attachment=False*)

Download the whole wiki of the project in PDF format into the given output file.

* Parameters: * **paper\_size** (*str*) – the format of the exported page, can be one of ‘A4’, ‘A3’, ‘US\_LETTER’ or ‘LEDGER’
* **export\_attachment** (*bool*) – export the attachments of the article(s) in addition to the pdf in a zip file

*class* `dataikuapi.dss.wiki.``DSSWikiSettings`(*client*, *project\_key*, *settings*)

Global settings for the wiki, including taxonomy. Call save() to save

`get_taxonomy`()

Get the taxonomy The taxonomy is an array listing at top level the root article IDs and their children in a tree format. Every existing article of the wiki has to be in the taxonomy once and only once. For instance: [

* {: ‘id’: ‘article1’,
‘children’: []

}, {

‘id’: ‘article2’, ‘children’: [

* {: ‘id’: ‘article3’,
‘children’: []

}

]

}

] Note that this is a direct reference, not a copy, so modifications to the returned object will be reflected when saving

* Returns: The taxonomy

* Return type: list

`move_article_in_taxonomy`(*article\_id*, *parent\_article\_id=None*)

An helper to update the taxonomy by moving an article with its children as a child of another article

* Parameters: * **article\_id** (*str*) – the main article ID
* **parent\_article\_id** (*str*) – the new parent article ID or None for root level

`set_taxonomy`(*taxonomy*)

Set the taxonomy

* Parameters: **taxonomy** (*list*) – the taxonomy

`get_home_article_id`()

Get the home article ID

* Returns: The home article ID

* Return type: str

`set_home_article_id`(*home\_article\_id*)

Set the home article ID

* Parameters: **home\_article\_id** (*str*) – the home article ID

`save`()

Save the current settings to the backend

*class* `dataikuapi.dss.wiki.``DSSWikiArticle`(*client*, *project\_key*, *article\_id\_or\_name*)

A handle to manage an article

`get_data`()

” Get article data handle

* Returns: the article data handle

* Return type: `dataikuapi.dss.wiki.DSSWikiArticleData`

`upload_attachement`(*fp*, *filename*)

Upload an attachment file and attaches it to the article Note that the type of file will be determined by the filename extension

* Parameters: * **fp** (*file*) – A file-like object that represents the upload file
* **filename** (*str*) – The attachement filename

`get_uploaded_file`(*upload\_id*)

” Download the attachement of an article

* Parameters: **upload\_id** (*str*) – The attachement upload id

* Returns: The requests.Response object

* Return type: `requests.Response`

`get_export_stream`(*paper\_size='A4'*, *export\_children=False*, *export\_attachment=False*)

Download the article in PDF format as a binary stream. Warning: this stream will monopolize the DSSClient until closed.

* Parameters: * **path** (*str*) – the path of the file where the pdf or zip file will be downloaded
* **paper\_size** (*str*) – the format of the exported page, can be one of ‘A4’, ‘A3’, ‘US\_LETTER’ or ‘LEDGER’
* **export\_children** (*bool*) – export the children of the article in the pdf
* **export\_attachment** (*bool*) – export the attachments of the article(s) in addition to the pdf in a zip file

* Returns: the exported pdf or zip file as a stream

`export_to_file`(*path*, *paper\_size='A4'*, *export\_children=False*, *export\_attachment=False*)

Download the article in PDF format into the given output file.

* Parameters: * **paper\_size** (*str*) – the format of the exported page, can be one of ‘A4’, ‘A3’, ‘US\_LETTER’ or ‘LEDGER’
* **export\_children** (*bool*) – export the children of the article in the pdf
* **export\_attachment** (*bool*) – export the attachments of the article(s) in addition to the pdf in a zip file

`delete`()

Delete the article

`get_object_discussions`()

Get a handle to manage discussions on the article

* Returns: the handle to manage discussions

* Return type: `dataikuapi.dss.wiki.DSSObjectDiscussions`

*class* `dataikuapi.dss.wiki.``DSSWikiArticleData`(*client*, *project\_key*, *article\_id*, *article\_data*)

A handle to manage an article

`get_body`()

Get the markdown body as string

* Returns: the article body

* Return type: str

`set_body`(*content*)

Set the markdown body

* Parameters: **content** (*str*) – the article content

`get_metadata`()

Get the article metadata Note that this is a direct reference, not a copy, so modifications to the returned object will be reflected when saving

* Returns: the article metadata

* Return type: dict

`set_metadata`(*metadata*)

Set the article metadata

* Parameters: **metadata** (*dict*) – the article metadata

`get_name`()

Get the article name

* Returns: the article name

* Return type: str

`set_name`(*name*)

Set the article name

* Parameters: **name** (*str*) – the article name

`save`()

Save the current article data to the backend.
