# Using Bokeh[¶](https://doc.dataiku.com/dss/latest/python/bokeh.html#using-bokeh "Permalink to this headline")

Bokeh is a Python interactive visualization library that provides interactive plots and dashboards. There are several ways you can use Bokeh in DSS:

* For fully-interactive interaction (multiple charts, various controls, …), by creating a Bokeh webapp

* To display interactive (pan/zoom/…) charts within a Jupyter notebook

* To display interactive (pan/zoom/…) charts on a Dashboard

Documentation for Bokeh is available at https://bokeh.pydata.org

## Installing Bokeh[¶](https://doc.dataiku.com/dss/latest/python/bokeh.html#installing-bokeh "Permalink to this headline")

* If you are using the DSS built-in environment, Bokeh is already installed. You don’t need to do any specific installation

* If you are using a code environment, you need to install the bokeh package

## Creating a Bokeh interactive web application[¶](https://doc.dataiku.com/dss/latest/python/bokeh.html#creating-a-bokeh-interactive-web-application "Permalink to this headline")

See Webapps

## Displaying charts in a Jupyter notebook[¶](https://doc.dataiku.com/dss/latest/python/bokeh.html#displaying-charts-in-a-jupyter-notebook "Permalink to this headline")

To display plot.ly charts in a Jupyter notebook, use this cell once in the notebook:

§ from bokeh.io import output\_notebook, show

§ output\_notebook()

You can then use `show()` to show Bokeh figures

For example, to display a chart showing simple circles:

§ from bokeh.plotting import figure

§ f = figure()

§ f.circle([1,2,3], [4,5,6], size=10)

§ show(f)

A complete documentation for the usage of Bokeh in a Jupyter notebook can be found at https://bokeh.pydata.org/en/latest/docs/user\_guide/notebook.html

### Using interactive controls in the Jupyter notebook[¶](https://doc.dataiku.com/dss/latest/python/bokeh.html#using-interactive-controls-in-the-jupyter-notebook "Permalink to this headline")

You can use interactive controls (sliders, inputs, …) that are displayed in the notebook. When you change these controls, the Bokeh chart can react dynamically.

Documentation for this is available here: https://bokeh.pydata.org/en/latest/docs/user\_guide/notebook.html#jupyter-interactors

## Displaying Bokeh charts on a dashboard[¶](https://doc.dataiku.com/dss/latest/python/bokeh.html#displaying-bokeh-charts-on-a-dashboard "Permalink to this headline")

Bokeh charts generated using Python code can be shared on a DSS dashboard using the “static insights” system. This does not include the capability to include controls. If you want to use Bokeh controls on a DSS Dashboard, use a Bokeh webapp.

Each Bokeh figure can become a single insight in the dashboard. Each chart will retain full zoom/pan/select/export capabilities;

To do so, create static insights

§ from dataiku import insights

§ # f is a Bokeh figure, or any object that can be passed to show()

§ insights.save\_bokeh("my-bokeh-plot", f)

From the Dashboard, you can then add a new “Static” insight, select the `my-bokeh-plot` insight

### Refreshing charts on a dashboard[¶](https://doc.dataiku.com/dss/latest/python/bokeh.html#refreshing-charts-on-a-dashboard "Permalink to this headline")

You can refresh the charts automatically on a dashboard by using a scenario to re-run the above piece of code.

This call to `dataiku.insights` code can be:

* In a DSS recipe (use a regular “Build” scenario step)

* In a Jupyter notebook (use a “Export notebook” scenario step)

* As a custom Python scenario step

## Displaying images in Bokeh[¶](https://doc.dataiku.com/dss/latest/python/bokeh.html#displaying-images-in-bokeh "Permalink to this headline")

To plot images in Bokeh, the image path specified must be relative to your “current location”.

You can plot images in a Jupyter notebook or display them in a webapp.

Images can be stored in `DATADIR/local/static`. An administrator can upload images to the DSS UI by going to Global Shared Code > Static Web Resources > +Add.

### In a Jupyter notebook[¶](https://doc.dataiku.com/dss/latest/python/bokeh.html#in-a-jupyter-notebook "Permalink to this headline")

Here’s an example of displaying an image in a Jupyter notebook:

§ import dataiku

§ from bokeh.plotting import figure, show

§ from bokeh.io import output\_notebook

§ path = '/local/static/cat-image.jpg'

§ f = figure(x\_range=(0,1), y\_range=(0,1), width=1000, height=500)

§ f.image\_url(url=[path], x=0, y=0, w=1, h=1, anchor='bottom\_left')

§ output\_notebook()

§ show(f)

### In a webapp[¶](https://doc.dataiku.com/dss/latest/python/bokeh.html#in-a-webapp "Permalink to this headline")

From a webapp, you’ll need to refer to the relative path to your image.

To refer to the image saved in `DATADIR/local/static` from a Bokeh webapp, you can use the relative path from the webapp directory:

§ import os

§ from bokeh.plotting import figure

§ from bokeh.layouts import row, widgetbox

§ from bokeh.io import curdoc

§ # get the full path to the image, and convert it to a relative path for the webapp

§ full\_path = os.path.join(os.environ["DIP\_HOME"], 'local/static/cat-image.jpg')

§ relative\_path = os.path.relpath(full\_path)

§ plot = figure(x\_range=(0,1), y\_range=(0,1), width=1000, height=500)

§ plot.image\_url(url=[relative\_path], x=0, y=0, w=1, h=1, anchor='bottom\_left')

§ curdoc().add\_root(row(plot, width=800))

For webapps, the image should be small enough to ensure a reasonable load time.
