# List of recognized meanings[¶](https://doc.dataiku.com/dss/latest/schemas/meanings-list.html#list-of-recognized-meanings "Permalink to this headline")

* Basic meanings

+ Text

+ Decimal

+ Integer

+ Boolean

+ Date / Dates (needs parsing)

+ Object / Array

+ Natural language

* Geospatial meanings

+ Latitude / Longitude

+ Geopoint

+ Geometry

+ Country

+ US State

* Web-specific meanings

* Other meanings

Here is the list of meanings that DSS recognizes.

## Basic meanings[¶](https://doc.dataiku.com/dss/latest/schemas/meanings-list.html#basic-meanings "Permalink to this headline")

### Text[¶](https://doc.dataiku.com/dss/latest/schemas/meanings-list.html#text "Permalink to this headline")

Anything is valid for the “Text” meaning.

### Decimal[¶](https://doc.dataiku.com/dss/latest/schemas/meanings-list.html#decimal "Permalink to this headline")

Recognizes “raw” decimals (like: 1234.32). Accepts negative and scientific notation

### Integer[¶](https://doc.dataiku.com/dss/latest/schemas/meanings-list.html#integer "Permalink to this headline")

Recognizes “raw” integers (like: 1234). If the number is higher than 2147483647 or lower than -2147483648, use bigint type.

### Boolean[¶](https://doc.dataiku.com/dss/latest/schemas/meanings-list.html#boolean "Permalink to this headline")

This meaning recognizes a large number of possible values (true, false, yes, no, 1, 0, …)

### Date / Dates (needs parsing)[¶](https://doc.dataiku.com/dss/latest/schemas/meanings-list.html#date-dates-needs-parsing "Permalink to this headline")

The Date meaning only recognizes dates in the ISO-8601 format, ie dates like `2014-12-31T23:05:43.123Z`

Note that the timezone information is mandatory for a valid *Date*

For all other kinds of dates the “Date (needs parsing)” meaning will be recognized. For more information, see:

* Handling and display of dates

* Managing dates

### Object / Array[¶](https://doc.dataiku.com/dss/latest/schemas/meanings-list.html#object-array "Permalink to this headline")

Recognizes objects and arrays in JSON notation

### Natural language[¶](https://doc.dataiku.com/dss/latest/schemas/meanings-list.html#natural-language "Permalink to this headline")

Recognizes “long text made of words”

## Geospatial meanings[¶](https://doc.dataiku.com/dss/latest/schemas/meanings-list.html#geospatial-meanings "Permalink to this headline")

### Latitude / Longitude[¶](https://doc.dataiku.com/dss/latest/schemas/meanings-list.html#latitude-longitude "Permalink to this headline")

This meaning recognizes a large number of formats for expressing geometric coordinates.

### Geopoint[¶](https://doc.dataiku.com/dss/latest/schemas/meanings-list.html#geopoint "Permalink to this headline")

This meaning recognizes a large number of formats for expressing a point in geometric coordinates (notably WKT)

### Geometry[¶](https://doc.dataiku.com/dss/latest/schemas/meanings-list.html#geometry "Permalink to this headline")

This meaning recognizes WKT format for geographic lines, polygons and multipolygons.

### Country[¶](https://doc.dataiku.com/dss/latest/schemas/meanings-list.html#country "Permalink to this headline")

The Country meaning recognizes country names (in English) and ISO Country codes

### US State[¶](https://doc.dataiku.com/dss/latest/schemas/meanings-list.html#us-state "Permalink to this headline")

This meaning recognizes both short codes and full names for USA states.

## Web-specific meanings[¶](https://doc.dataiku.com/dss/latest/schemas/meanings-list.html#web-specific-meanings "Permalink to this headline")

* IP Address (IPv4 and IPv6)

* URL

* HTTP Query String

* User Agent

* E-Mail address

## Other meanings[¶](https://doc.dataiku.com/dss/latest/schemas/meanings-list.html#other-meanings "Permalink to this headline")

DSS recognizes a few other specific meanings
