# Workspaces & dashboards authorizations[¶](https://doc.dataiku.com/dss/latest/security/dashboard-authorizations.html#workspaces-dashboards-authorizations "Permalink to this headline")

* Scope

* Adding objects to “Workspaces and dashboards authorizations” list

* Details by object type

+ Dataset

+ Saved model

+ Managed folder

+ Jupyter notebook

+ Web app

+ Scenario

Workspaces and DSS dashboards allow people who don’t have the permissions to read or write the full content of a project to access a selected set of insights about the data project.

Within a given project, these “dashboard-only” users (who can’t read or write the full content of a project) have thus access to a subset of the objects.

This is handled by the “Workspaces & dashboards authorizations” mechanism, which is available in Project > Settings > Security > Workspaces & dashboards authorizations.

Both project-local objects and objects shared from other projects can be “authorized”.

## Scope[¶](https://doc.dataiku.com/dss/latest/security/dashboard-authorizations.html#scope "Permalink to this headline")

“Workspaces & dashboards authorizations” menu defines which objects are allowed for project dashboard-only users and workspaces users.

* “Workspaces and dashboards authorizations” are not tied to a group. When an object is in the list of Workspace and dashboard authorizations, *all* dashboard-only users of the project have access to this object and *all* users of the workspace where is shared the object. It is not possible to restrict a given object to a given set of users within a project but it is possible with creation of a workspace.

* “Workspaces and dashboards authorizations” apply to a whole DSS object (a dataset, a saved model, …). Thus, if a dataset is in the list of “Workspaces and dashboards authorizations”, it is technically possible, even for users who only have “read dashboard” access to access the whole content of the dataset, even though only a single chart insight is present on the dashboard.

Most dashboard authorizations only give read access (see below for more information). A few kind of objects have “authorization modes” (WRITE and RUN).

## Adding objects to “Workspaces and dashboards authorizations” list[¶](https://doc.dataiku.com/dss/latest/security/dashboard-authorizations.html#adding-objects-to-workspaces-and-dashboards-authorizations-list "Permalink to this headline")

You can manage which objects are in the “Workspaces and dashboards authorizations” in Project > Security > Workspaces and dashboards authorizations. In order to achieve that you need the “Manage authorized objects” project-level permission. See Main project permissions for more info.

When you publish something on a dashboard (for example, a chart based on a dataset), and if this object is not yet in authorized objects list, you will get a warning:

* If you don’t have “Manage authorized objects” permission, the warning will indicate that dashboard-only users won’t be able to see this insight in the dashboard

* If you do have “Manage authorized objects” permission, the warning will include a prompt to add this item to the list of authorized objects of the project.

When you publish a dashboard or dataset in a Workspace, you need a “share to workspaces” permission in the project. This permission also implies a “Manage authorized objects” permission and it will add the object automatically to the authorized objects list.

In Project > Settings > Security > Workspaces and dashboards authorizations, it is also possible to define that all objects present in a project are authorized for Dashboard and workspaces. In that case, all authorizations are in read-only mode.

## Details by object type[¶](https://doc.dataiku.com/dss/latest/security/dashboard-authorizations.html#details-by-object-type "Permalink to this headline")

### Dataset[¶](https://doc.dataiku.com/dss/latest/security/dashboard-authorizations.html#dataset "Permalink to this headline")

Authorizing a dataset makes it possible to view and create the following insights on this dataset:

* Dataset table

* Chart

* Comments

* Metrics

Even if only a limited chart is available on the dashboard, if a given dataset is dashboard-authorized, then it’s technically possible to access all data in the dataset. There is no “intra-dataset” security.

### Saved model[¶](https://doc.dataiku.com/dss/latest/security/dashboard-authorizations.html#saved-model "Permalink to this headline")

Authorizing a dataset makes it possible to view and create the following insights on this model:

* Model report

* Comments

* Metrics

It gives dashboard-only users the ability to view all details (metrics, variables, …) of the model.

### Managed folder[¶](https://doc.dataiku.com/dss/latest/security/dashboard-authorizations.html#managed-folder "Permalink to this headline")

Authorizing a managed folder makes it possible to view and create the following insights on this folder:

* Managed folder (displays the content of the folder)

* Comments

* Metrics

It gives dashboard-only users the ability to view all files in the folder.

### Jupyter notebook[¶](https://doc.dataiku.com/dss/latest/security/dashboard-authorizations.html#jupyter-notebook "Permalink to this headline")

Authorizing a dataset makes it possible to view and create “Jupyter notebook”. These insights are based on *exports* of notebooks, not the notebook itself.

When a Jupyter notebook is dashboard-authorized, it does not give dashboard-only users the ability to execute code in the notebook, nor to create a new export of the notebook.

### Web app[¶](https://doc.dataiku.com/dss/latest/security/dashboard-authorizations.html#web-app "Permalink to this headline")

Authorizing a web app makes it possible to view and create the following insights on this webapp:

* Web app (displays the content of the webapp)

* Comments

It allows workspace and dashboard-only users to view the webapp. It does not allow them to modify the webapp or to view the backend code.

### Scenario[¶](https://doc.dataiku.com/dss/latest/security/dashboard-authorizations.html#scenario "Permalink to this headline")

Authorizing a scenario in read-only mode makes it possible to create an insight representing the history of runs of this scenario.

Authorizing a scenario in “run” mode makes it possible for dashboard-only users to run this scenario. This can lead to interesting use cases. For example, if a scenario takes as input a campaigns reference file on a FTP folder, the marketing team can update the file, and when they want, rerun a scenario directly from the dashboard.
