# How to Edit Dataiku Recipes and Plugins in Sublime[¶](https://knowledge.dataiku.com/latest/courses/advanced-code/work-environment/sublime.html#how-to-edit-dataiku-recipes-and-plugins-in-sublime "Permalink to this headline")

## Goal[¶](https://knowledge.dataiku.com/latest/courses/advanced-code/work-environment/sublime.html#goal "Permalink to this headline")

Though Jupyter notebooks are integrated into the Dataiku interface, some developers favor Sublime Text as an IDE. From within Sublime, you can:

* Install the `dataiku` package

* Configure Sublime to connect to an existing Dataiku instance

* Pull code from an existing code recipe or plugin into Sublime

* Edit the code in Sublime, and then

* Save the code back to the code recipe or plugin

Note

This method can edit *existing* recipes and plugin files on the Dataiku instance, but cannot create new recipes or files.

## Prerequisites[¶](https://knowledge.dataiku.com/latest/courses/advanced-code/work-environment/sublime.html#prerequisites "Permalink to this headline")

* Familiarity with code recipes or plugins in Dataiku.

## Technical Requirements[¶](https://knowledge.dataiku.com/latest/courses/advanced-code/work-environment/sublime.html#technical-requirements "Permalink to this headline")

* Access to a Dataiku instance

* Sublime Text 3 with Package Control extension manager.

* A personal API key to the Dataiku instance

## Install the Dataiku Package[¶](https://knowledge.dataiku.com/latest/courses/advanced-code/work-environment/sublime.html#install-the-dataiku-package "Permalink to this headline")

* In Sublime Text, open **Tools > Command Palette**.

* Search for `install` and select **Package Control: Install Package**.

* Search for `dataiku` and select **Dataiku**.

The Dataiku package provides commands for connecting to a Dataiku instance and editing recipes on the instance.

## Connect to a Dataiku Instance[¶](https://knowledge.dataiku.com/latest/courses/advanced-code/work-environment/sublime.html#connect-to-a-dataiku-instance "Permalink to this headline")

* Open the Sublime Text Command Palette

* Search for `dataiku` and select **Dataiku: Configure DSS instances**

* This opens *Dataiku.sublime-settings*. Insert JSON of the format shown below, using the information for your instance and personal API key secret.

* Save the settings.

§ {

§ "instances": [

§ {

§ "name": "My DSS Instance",

§ "base\_url": "http://localhost:12000",

§ "api\_key": "SaHZlgrDHi1AfAc14flWt8vIgUyyUy6V",

§ "list\_of\_project\_keys\_to\_exclude": [],

§ "list\_of\_plugin\_ids\_to\_exclude": [],

§ "keep\_only\_code\_recipes": true

§ }

§ ]

§ }

The parameters available for each Dataiku instance:

* *name.* A descriptive name for the Dataiku instance that will be displayed in Sublime Text

* *base\_url.* The base URL of the Dataiku instance, without / at the end

* *api\_key.* The secret for your personal API key

* *list\_of\_project\_keys\_to\_exclude.* An optional a list of project keys that are excluded when Sublime Text searches for code recipes

* *keep\_only\_code\_recipes.* Determines whether visual recipes are hidden in Sublime Text. It is *highly recommended* to keep this option set to true.

## Edit a Dataiku Recipe[¶](https://knowledge.dataiku.com/latest/courses/advanced-code/work-environment/sublime.html#edit-a-dataiku-recipe "Permalink to this headline")

* Open the Sublime Text Command Palette

* Search for `dataiku` and select **Dataiku: Edit DSS recipes**

* Choose the recipe you want to edit from list

Changes made in Sublime are made to the recipe in Dataiku when you Save, overwriting any edits made in the meantime on the Dataiku instance.

## Edit a Dataiku Plugin[¶](https://knowledge.dataiku.com/latest/courses/advanced-code/work-environment/sublime.html#edit-a-dataiku-plugin "Permalink to this headline")

* Open the Sublime Text Command Palette

* Search for `dataiku` and select **Dataiku: Edit DSS plugins**

* Choose the plugin whose code you want to edit

* Choose the file in the plugin that you want to edit

Changes made in Sublime are made to the recipe in Dataiku when you Save, overwriting any edits made in the meantime on the Dataiku instance.

## What’s Next?[¶](https://knowledge.dataiku.com/latest/courses/advanced-code/work-environment/sublime.html#what-s-next "Permalink to this headline")

The DataikuSublimeText extension is open sourced; feel free to contribute.
