# Concept: Git Integration for Plugins[¶](https://knowledge.dataiku.com/latest/courses/advanced-code/plugin-dev/git-integration-for-plugins-concept-summary.html#concept-git-integration-for-plugins "Permalink to this headline")

Tip

This content is also included in a free Dataiku Academy course on Plugin Development, which is part of the Developer learning path. Register for the course there if you’d like to track and validate your progress alongside concept videos, summaries, hands-on tutorials, and quizzes.

In this lesson, we’ll learn about Dataiku’s Git integration for plugins. We’ll also see how to use Git repositories for sharing development plugins with others in the plugin development community.

Tip

It is important to have a good understanding of the Git model and terminology before using the Git integration for plugins.

## Git Version Control Tasks Available to Plugins[¶](https://knowledge.dataiku.com/latest/courses/advanced-code/plugin-dev/git-integration-for-plugins-concept-summary.html#git-version-control-tasks-available-to-plugins "Permalink to this headline")

Each plugin we create in the plugin editor is associated with a local Git repository, and every change that we make in the plugin editor (e.g. saving a file or adding a new component) is automatically committed to the Git repository.

Note

The Git integration for plugins is separate from the Git integration for projects, and the two should not be confused.

The Plugin-Git integration allows us to perform common version control tasks, such as:

* pushing and pulling changes from a remote repository,

* using branches,

* viewing a plugin’s history,

* reverting changes, etc.

We’ll explore some of these tasks.

### Connecting to a Remote Repository[¶](https://knowledge.dataiku.com/latest/courses/advanced-code/plugin-dev/git-integration-for-plugins-concept-summary.html#connecting-to-a-remote-repository "Permalink to this headline")

Dataiku DSS can connect to a remote repository securely by using SSH.

Note

Connecting Dataiku DSS to a remote repository by SSH requires prior setup of SSH credentials. The product documentation provides in-depth guidance on how to set up this connection.

To share a development plugin via a remote repository, we connect to the remote Git repository by adding its SSH URL to DSS through the “change tracking” indicator. Ideally, the remote repository should be empty, as it is good practice to use a separate repository for each plugin.

Once connected to the remote repository, we can push the plugin’s code from the master branch of the local git repository. In the remote repository, we’ll be able to see that the master branch has been successfully pushed.

### Working With Branches[¶](https://knowledge.dataiku.com/latest/courses/advanced-code/plugin-dev/git-integration-for-plugins-concept-summary.html#working-with-branches "Permalink to this headline")

Back in DSS, we can also create a development branch off the local master branch to use for more development work on the plugin.

By navigating to the **History** tab, we can see the changes made on a branch and also revert changes as needed.

Once we’re satisfied with our changes, we can push any new updates back to the remote Git repository.

### Merging Branches[¶](https://knowledge.dataiku.com/latest/courses/advanced-code/plugin-dev/git-integration-for-plugins-concept-summary.html#merging-branches "Permalink to this headline")

Because the ability to merge branches is not directly available in Dataiku DSS, we’ll have to go outside DSS (into a Git client such as GitHub) to merge the changes on the development branch into the master branch.

Upon returning to DSS, we can then switch to the local master branch and pull in the changes from the remote master, so that the merged changes are now available on the local master branch in DSS.

### Importing Plugins From Git Repositories[¶](https://knowledge.dataiku.com/latest/courses/advanced-code/plugin-dev/git-integration-for-plugins-concept-summary.html#importing-plugins-from-git-repositories "Permalink to this headline")

Furthermore, for plugins that have been developed by others and stored in a remote Git repository, we can import them into Dataiku DSS for our use or for further development.

For example, we can fetch the Geocoder plugin directly from its remote Git repository and clone this remote repository for use on our DSS instance.

We can also select the option to clone in “development mode” so that we can make changes to the plugin locally and push our changes to the remote repository, provided that we have write privileges on the remote repository.

When working in development mode, we are also able to choose whether to clone the entire repository or clone a subfolder if the repository contains multiple plugins.

## What’s Next?[¶](https://knowledge.dataiku.com/latest/courses/advanced-code/plugin-dev/git-integration-for-plugins-concept-summary.html#whats-next "Permalink to this headline")

Continue learning about plugins by working through the hands-on lesson on Plugin Development.
