# Hands-On Tutorial: Deep Learning for Sentiment Analysis[¶](https://knowledge.dataiku.com/latest/courses/advanced-analytics/nlp-code/introduction.html#hands-on-tutorial-deep-learning-for-sentiment-analysis "Permalink to this headline")

**Binary Sentiment Analysis** is the task of automatically analyzing a text data to decide whether it is *positive* or *negative*. This is useful when faced with a lot of text data that would be too time-consuming to manually label.

In addition to simpler options, Dataiku enables you to build a convolutional neural network model for binary sentiment analysis.

## Objectives[¶](https://knowledge.dataiku.com/latest/courses/advanced-analytics/nlp-code/introduction.html#objectives "Permalink to this headline")

This tutorial walks through how to build a convolutional network for sentiment analysis, using Keras code in Dataiku’s Visual Machine Learning. After building an initial model, we’ll use pre-trained word embeddings to improve the preprocessing of inputs, and then evaluate both models on test data.

## Prerequisites[¶](https://knowledge.dataiku.com/latest/courses/advanced-analytics/nlp-code/introduction.html#prerequisites "Permalink to this headline")

Before beginning this tutorial you should have:

* Some experience with Deep Learning with code in Dataiku.

* Some familiarity with Keras.

You will also need to create a code environment, or use an existing one, that has the necessary libraries. When creating a code environment, you can add sets of packages on the **Packages to Install** tab. Choose the Visual Deep Learning package set that corresponds to the hardware you’re running on.

## Preparing the Data[¶](https://knowledge.dataiku.com/latest/courses/advanced-analytics/nlp-code/introduction.html#preparing-the-data "Permalink to this headline")

We will be working with IMDB movie reviews. The original data is from the Large Movie Review Dataset, which is a compressed folder with many text files, each corresponding to a review. In order to simplify this how-to, we have provided two CSV files:

* Training data

* Test data

Download these CSV files, then create a new project and upload the CSV files into two new datasets.
