# Events Aggregator (Plugin)[¶](https://knowledge.dataiku.com/latest/courses/advanced-data-prep/events-aggregator/introduction.html#events-aggregator-plugin "Permalink to this headline")

Feature Factory is our global initiative for automated feature engineering. It aims to reduce the countless hours data scientists spend building insightful features.

The first outcome of this initiative is the EventsAggregator plugin, which works with data where each row records a specific action, or event, and the timestamp of when it occurred. Web logs, version histories, medical and financial records, and machine maintenance logs are all examples of events data.

The plugin can generate more than 20 different types of aggregated features per aggregation group, such as the frequency of the events, recency of the events, the distribution of the features, etc., over several time windows and populations that you can define. The generated features can outperform raw features when training machine learning algorithms.

## Events Aggregator Settings[¶](https://knowledge.dataiku.com/latest/courses/advanced-data-prep/events-aggregator/introduction.html#events-aggregator-settings "Permalink to this headline")

To use the plugin, there are critical pieces of information you need to provide:

A column that records the timestamp of when each event in the dataset occurred

One or more columns (aggregation keys) that define the group the event belongs to. For example, in an order log, the customer id provides a natural grouping.

The level of aggregation. The examples below will go into greater detail of how to use the level of aggregation.

* In the By group case, the features are aggregated by group and the output will have one row per group.

* In the By event case, for each event, all events before this event will be aggregated together. The output will contain one row per event.

## Install the Plugin[¶](https://knowledge.dataiku.com/latest/courses/advanced-data-prep/events-aggregator/introduction.html#install-the-plugin "Permalink to this headline")

Install the EventsAggregator plugin. This requires Administrator privileges on the Dataiku DSS instance.
