# Common Steps in Visual Recipes: Pre-Filter, Post-Filter & Computed Columns[¶](https://knowledge.dataiku.com/latest/courses/advanced-data-prep/visual-recipes-102/common-steps/common-steps-summary.html#common-steps-in-visual-recipes-pre-filter-post-filter-computed-columns "Permalink to this headline")

When working with Dataiku DSS visual recipes, you can leverage some common steps that can be used within multiple Dataiku DSS recipes. These common steps include:

* Pre-Filter

* Post-Filter

* Computed Columns

When working on data projects with visual recipes in Dataiku DSS, filtering is often used in combination with other data preparation steps. For example, we can use a Filter recipe to choose a smaller subset of a larger dataset *before* applying other visual recipes.

In other cases, we may use a Filter recipe *after* applying a visual recipe that computed aggregated statistics on the whole dataset, but we want to keep only a certain subset of interest.

In order to make this process easier, Dataiku DSS allows users to apply a **Pre-Filter** or **Post-Filter** in most visual recipes. This means, instead of having to add a standalone Filter recipe before or after another recipe, we can simply go to the “Pre-Filter” or “Post-Filter” step of the recipe itself.

Similarly, the **Computed Columns** step allows computation of new columns as part of a visual recipe, without having to create a new Prepare recipe with a Formula processor.

Let’s see how each of these common visual recipe steps work.

## Pre-Filter[¶](https://knowledge.dataiku.com/latest/courses/advanced-data-prep/visual-recipes-102/common-steps/common-steps-summary.html#pre-filter "Permalink to this headline")

The Pre-Filter step can be applied in almost all visual recipes, including:

* Group

* Distinct

* Sort

* Join

* Split

* Stack

* Window

* Pivot, and

* TopN

To apply a Pre-Filter, go to the “Pre-Filter” step of any of the visual recipes listed above and activate Filter. For instance, if we’re working on a dataset containing credit card transactions, we could use a Pre-Filter to only keep rows that correspond to a given state, before we apply another visual recipe.

## Post-Filter[¶](https://knowledge.dataiku.com/latest/courses/advanced-data-prep/visual-recipes-102/common-steps/common-steps-summary.html#post-filter "Permalink to this headline")

The Post-Filter step in visual recipes functions in a similar way as the Pre-Filter step. You can apply a Post-Filter in the following recipes:

* Group

* Join

* Distinct

* Window

* Stack

Let’s say that we’re working on the same credit card transactions dataset. We want to leverage one of the visual recipes listed above, and in addition, we only want to keep the transactions for which the average purchase amount is over 100.

In this case, we would need a Post-Filter, because we’d be filtering the newly created rows based on the values computed by the Group recipe.

We can also use the Distinct function in the Post-Filter step to remove row duplicates. Similarly to the Filter function, the Distinct function lets us avoid having to create a separate Distinct recipe.

## Computed Columns[¶](https://knowledge.dataiku.com/latest/courses/advanced-data-prep/visual-recipes-102/common-steps/common-steps-summary.html#computed-columns "Permalink to this headline")

We often want to create new columns based on those already present in our dataset. This can be achieved by using the Formula processor in the Prepare recipe.

However, we don’t always need to create an entirely new Prepare recipe just to add a formula step and compute a new column. Instead, we could save time by using the **Computed Columns** step, which is available in the following visual recipes:

* Group

* Sort

* Join

* Split

* Window

* Pivot, and

* Top N

The Computed Columns step lets us create a new column using either a Dataiku DSS formula or SQL, based on the existing columns of the input dataset of the visual recipe.

For example, as shown below, we can create a new column *card\_purchase\_amount\_range* using a formula or a column *count\_of\_records* using a SQL expression.

## What’s Next?[¶](https://knowledge.dataiku.com/latest/courses/advanced-data-prep/visual-recipes-102/common-steps/common-steps-summary.html#whats-next "Permalink to this headline")

We will learn more about creating new columns with Dataiku DSS formulas in the Advanced Formula & Regex section of the Advanced Designer learning path in Dataiku Academy.
