# Hands-On Tutorial: Create the Project[¶](https://knowledge.dataiku.com/latest/courses/basics/create-project/create-your-project.html#hands-on-tutorial-create-the-project "Permalink to this headline")

Welcome to your first hands-on lesson with Dataiku DSS!

Note

As opposed to concept lessons, lessons marked as “Hands-On” have step-by-step instructions aimed at having you reproduce the actions described.

In Basics 101, Basics 102 and Basics 103, we’ll cover much of what you need to familiarize yourself with Dataiku DSS.

* You’ll create a project and import data.

* You’ll explore the data with charts and statistical tests.

* You’ll prepare the data with recipes.

* You’ll even publish results to a dashboard.

Tip

This content is also included in the free Dataiku Academy course, Basics 101, which is part of the Core Designer learning path.

Let’s get started!

## Prerequisites[¶](https://knowledge.dataiku.com/latest/courses/basics/create-project/create-your-project.html#prerequisites "Permalink to this headline")

* To follow along with the steps in this tutorial, you will need access to an instance of Dataiku DSS (version 9.0 or above). If you do not already have access, there are two ways to get started. From the Dataiku website, you can:

+ install the free edition,

+ or start a 14-Day Free Online Trial.

* You’ll also need to upload a file from your computer to Dataiku DSS. Download the orders CSV file before getting started.

## Create Your Project[¶](https://knowledge.dataiku.com/latest/courses/basics/create-project/create-your-project.html#create-your-project "Permalink to this headline")

The first step is to create a new Dataiku DSS project. From the Dataiku homepage, click **+New Project**, select **DSS Tutorials** from the list, click on the **Core Designer / Basics** section and select **Basics 101**.

Note

You can also download the starter project from this website and import it as a zip file.

This action creates the starter project for you along with a unique project ID, e.g., “DKU\_TUTORIAL\_BASICS\_101”.

Note

Note that you cannot change the project ID once it is created in Dataiku DSS. If you want a project with a different ID, you can duplicate the project and specify a new ID for the duplicate project. The product documentation describes how to copy a Dataiku project in detail.

Upon creating the starter project, you immediately land on the project home page.

* Take a moment to explore some of the other tabs and features within the project homepage. For instance, you can check out the **Activity** tab for a high-level overview of user contributions to a project or visit the **Metrics** tab for project-level metrics and checks.

Note

The starter project for this course will have an empty Flow, but for other Academy courses, the starter project will already have datasets and recipes ready for you to use.

## What’s Next?[¶](https://knowledge.dataiku.com/latest/courses/basics/create-project/create-your-project.html#id1 "Permalink to this headline")

You now have a project, but no data in it. Acquiring some data will be the next step! To continue this hands-on tutorial see Hands-On Tutorial: Create The Dataset.
