# Reviews and Sign-offs[¶](https://knowledge.dataiku.com/latest/courses/govern/deploy-monitor/reviews-signoffs.html#reviews-and-sign-offs "Permalink to this headline")

A sign-off process ensures that model versions and bundles have the proper approval before being deployed. Let’s see how the sign-off process works in Dataiku Govern.

## The Sign-off Process[¶](https://knowledge.dataiku.com/latest/courses/govern/deploy-monitor/reviews-signoffs.html#the-sign-off-process "Permalink to this headline")

In the standard workflow, model versions and bundles have the sign-off process built into certain steps. You can recognize the sign-off step(s) in the workflow by its tagged **state**.

Note

To start the sign-off step, be sure to select **Set as Finished** on the previous step if applicable.

### Types of Reviewers[¶](https://knowledge.dataiku.com/latest/courses/govern/deploy-monitor/reviews-signoffs.html#types-of-reviewers "Permalink to this headline")

There are two types of reviewers: feedback reviewers and final approvers.

Feedback reviews are optional. You do not need any feedback reviews to have a Final Approver sign-off. However, they are useful if you want input on how to make improvements. Feedback reviews also provide additional information to help Final Approvers make informed decisions.

Only the Final Approval is checked by the Deployer node. You can add multiple approvers, but only one final approval is needed for the Deployer node to recognize the approval.

### Add Reviewers[¶](https://knowledge.dataiku.com/latest/courses/govern/deploy-monitor/reviews-signoffs.html#add-reviewers "Permalink to this headline")

To add specific reviewers, open the parent project of the model version or bundle that you plan to deploy.

In the project overview, click the **+Add** button to add one or more reviewers to certain slots. Reviewers can be specific groups or individuals.

By default, you can add Feedback reviewers to three different “slots”:

* IT & Operations Reviewers,

* Risk & Compliance Reviewers,

* and Business Reviewers.

There is only one slot for Final Approvers.

To start the feedback review process:

* Return to the model version or bundle.

* Go to the sign-off step of the workflow.

* Click **Request Review** at the top of the sign-off section.

* Select reviewers.

To start the final approval process:

* Stay in the sign-off step of the workflow.

* Click **Request the Final Approval** button.

* Select approvers.

### Review and Sign-off[¶](https://knowledge.dataiku.com/latest/courses/govern/deploy-monitor/reviews-signoffs.html#review-and-sign-off "Permalink to this headline")

If you have been requested to review or approve a model version or bundle, you will receive an email notification.

To submit a review or approval, click the link in the email or open the sign-off step in the relevant Dataiku item. Select the **Review** button to begin.

If you know that someone else is better suited to review or approve the item, you can request that someone else review it. Click **Delegate** to assign the review to a different person or role.

Note

After the final approval, the sign-off step must be **Set as Finished** to be able to move on to the next step in the workflow.

### Deployment[¶](https://knowledge.dataiku.com/latest/courses/govern/deploy-monitor/reviews-signoffs.html#deployment "Permalink to this headline")

The Final Approver can add a comment to their approval and set its status to Approved, Rejected, or Abandoned.

If the Final Approver **approves** the model version or bundle, the deployment can finally be performed.

If the model version or bundle is **rejected**, it still could be deployed depending on the Govern Policy.

If the sign-off is **abandoned**, the review is stopped and you cannot try to deploy.

Note

The Govern Policy is defined in the Deployer node. There are three possible Govern Policies:

* Prevent the deployment of unapproved packages.

* Warn and ask for confirmation before deploying unapproved packages.

* Always deploy without checking.

If Dataiku Govern and Dataiku Deploy have not been linked and a Govern Policy has not been chosen, an administrator can configure this using the product documentation on sign-offs.
