# Safely Sharing Data Downstream[¶](https://knowledge.dataiku.com/latest/courses/governance/gdpr/safe-sharing.html#safely-sharing-data-downstream "Permalink to this headline")

This tutorial has demonstrated how the GDPR plugin assists in documenting personal data at the project level (through a GDPR admin group) and the dataset level (through a GDPR documentation group).

We may next wish to consider structuring a workflow that allows datasets to be safely shared with users not permitted to access personal data.

In the above example, the green icon of *Orders\_enriched\_prepared* signifies that it no longer contains personal data, following the Prepare recipe. Accordingly, it is free to be shared downstream with groups of users that should not have access to personal data.

To share the *Orders\_enriched\_prepared dataset* with another project, first select it from the Flow. From the Actions section of the right panel, find the **Share** icon. In the following dialog, under Target Projects, select one or more projects with which to share the dataset.

That dataset now appears in the selected project’s Flow. Its name will have the name of the origin project prefixed to it. Moreover, after having been shared, the GDPR status with respect to personal data for that dataset remains present in the new project.

In addition to sharing a dataset from the Flow, we can also navigate to the Exposed elements section of the **… > Security** menu found in the top Navigation bar. This menu lists not only datasets, but all objects (which may include models, notebooks, web apps, etc.) currently exposed, and the projects with which they have been shared. Add or delete new exposed objects from this menu at any time.

Note

For more information on exposed objects, please see the reference documentation.
