# Technical Prerequisites for MLOps Tutorials[¶](https://knowledge.dataiku.com/latest/courses/mlops/_shared/mlops-tech-prereqs.html#technical-prerequisites-for-mlops-tutorials "Permalink to this headline")

Below is a list of technical prerequisites needed to fully reproduce the tutorials in the MLOps Practitioner learning path.

* A Business or Enterprise license for Dataiku (version 10.0 or above).

Note

The free edition and free trials of Dataiku Online are not fully compatible.

* The starter project for the MLOps tutorials was built on an instance where the builtin Python environment is Python 3.6. (The default Python environment for Dataiku Online is 3.6). If the builtin environment for your instance is Python 2.7, you will need your instance administrator to upgrade the instance to Python 3.6.

Note

You can learn about choosing the version of Python for the builtin environment in the product documentation.

* The Reverse Geocoding plugin (version 2.1 or above) installed on your Dataiku instance. (This plugin is installed by default on Dataiku Online).

* A SQL database (the tutorials use PostgreSQL, but other alternatives may be compatible).

* A Design node connected to both Automation and API nodes and deployment infrastructure.

Note

A person with administrative privileges on your Dataiku instance can follow the product documentation for setting up the Deployer.

Dataiku Online users can consult additional documentation for setting up an Automation node and API node from the Launchpad.

* A user profile belonging to a group with access to the deployment infrastructure.

In addition, for the Batch Deployment tutorials, you’ll also need:

* Users need to be able to create a project bundle, which requires the admin permission on the “DKU\_TUT\_MLOPS” project used throughout the learning path.

* If you choose to include one, a Mail reporter should be configured to be able to send emails via a scenario on both Design and Automation nodes. Dataiku Online users can add a mail reporter from their launchpad by clicking **Extensions > Add an Extension > Email channel**, and then selecting to use this feature on **both** their DSS instance and Automation node.
