# Monitor Output of API Endpoints[¶](https://knowledge.dataiku.com/latest/courses/mlops/real-time-apis/monitor-output-of-endpoints.html#monitor-output-of-api-endpoints "Permalink to this headline")

After deploying an API service with one or more endpoints, it can be useful to set up a monitoring system to centralize the logs from the API node and to monitor the responses of endpoints.

## Monitor the API Node[¶](https://knowledge.dataiku.com/latest/courses/mlops/real-time-apis/monitor-output-of-endpoints.html#monitor-the-api-node "Permalink to this headline")

The **Event Server** is a Dataiku component that allows for monitoring API nodes. API nodes can send event logs to the Event server, and in turn, it will take care of sorting and storing the logs in an accessible place.

In more detail, the Event server centralizes the logs of all queries that the API node receives and the responses an API service returns. The Event server then makes these logs available as a dataset that one can use in a Dataiku project.

## Configure the Event Server[¶](https://knowledge.dataiku.com/latest/courses/mlops/real-time-apis/monitor-output-of-endpoints.html#configure-the-event-server "Permalink to this headline")

A person with administrator permissions on an instance of Dataiku can set up the Event server on a Dataiku Design or automation node by following the product documentation on Installing the event server. After setting up the Event server, the admin can configure audit logging for API nodes.

## Use the Event Server[¶](https://knowledge.dataiku.com/latest/courses/mlops/real-time-apis/monitor-output-of-endpoints.html#use-the-event-server "Permalink to this headline")

After setting up the Event server and configuring the API infrastructure, you can test it.

First, you’ll want to send a few calls to the API endpoint deployed to the API node.

Next, return to the Dataiku project where you designed the API service. Here, create a new dataset on the file system connection and the path that the Dataiku admin configured as the destination for the event server logs. Browse to the `YOUR PATH/apinode-query/YOUR-ROUTING-KEY`. That’s it! You now have the logs of this service across your API node!

## Potential Uses of the API Audit Logs[¶](https://knowledge.dataiku.com/latest/courses/mlops/real-time-apis/monitor-output-of-endpoints.html#potential-uses-of-the-api-audit-logs "Permalink to this headline")

You can use the audit logs of the API node to monitor your endpoint. The information contained in the collected logs can be useful for several different use cases, including:

* Understanding who the users of the API service are: the logs contain information, such as the API address and timestamp for each query. This information can help to provide a better understanding of the end-users of the API.

* Checking the health of the API, for instance, by monitoring its response time.

* Checking the predictions of the API and monitoring them for drift.

* Implementing an ML feedback loop: In the case of a machine learning model trained on a few data points, the queries sent to the API can be used, after manual relabelling, to re-train the original model with more data.

## What’s Next?[¶](https://knowledge.dataiku.com/latest/courses/mlops/real-time-apis/monitor-output-of-endpoints.html#what-s-next "Permalink to this headline")

The Dataiku product documentation provides more details about the Event server and how to configure it for use in centralizing the logs of API node queries.
