# Concept Summary: Defining Variables[¶](https://knowledge.dataiku.com/latest/courses/o16n/variables/variables-for-coders/defining-variables-summary.html#concept-summary-defining-variables "Permalink to this headline")

In this lesson, we’ll learn about variables including those defined at the Dataiku instance level, and those defined at the project level. We’ll also learn how to define project-level variables.

## Global Variables[¶](https://knowledge.dataiku.com/latest/courses/o16n/variables/variables-for-coders/defining-variables-summary.html#global-variables "Permalink to this headline")

Variables defined for the DSS instance are referred to as global variables. These variables are rarely changed and can be used in any project on the instance.

These are managed by the administrator of the instance from the administrator settings page.

An example of a set of global variables that could be useful for reporting purposes would be the emails of all of the users on the Dataiku instance.

You probably won’t be working with variables at the instance level very often.

## Project Variables[¶](https://knowledge.dataiku.com/latest/courses/o16n/variables/variables-for-coders/defining-variables-summary.html#project-variables "Permalink to this headline")

When you work with variables you’ll likely be working with them at the project level. There are two types of project variables: Global project variables and Local project variables.

Global project variables are not the same as the global variables at the instance level. All project-level variables are available to a specific project.

One way to differentiate between these two types of project-level variables is whether or not they are included in the project bundle.

Global project variables are included in the project bundle when deploying your project to the Automation node, while local project variables are not.

### Defining Project Variables[¶](https://knowledge.dataiku.com/latest/courses/o16n/variables/variables-for-coders/defining-variables-summary.html#defining-project-variables "Permalink to this headline")

To define your project variables, you’ll first open the project, then visit the **More Options** menu, then choose **Variables**.

In our project, the global project variables are merch\_state and merch\_category, and there are no local project variables.

You define variables between curly brackets. The syntax to define a variable is to insert both the name and the value in double quotes and separate them by a colon.

Once you’ve defined your project variables, you can use them to transform an input dataset, such as in the step of a Prepare recipe.

In this lesson, we learned about global and project variables and how to define variables that we can then use in our project.

## What’s Next?[¶](https://knowledge.dataiku.com/latest/courses/o16n/variables/variables-for-coders/defining-variables-summary.html#what-s-next "Permalink to this headline")

We’ll look at ways we can use project variables in other lessons in this course.

For more information about custom variables including syntax, you can visit Custom Variables Expansion.
