# A Look at Coding with Variables[¶](https://knowledge.dataiku.com/latest/courses/o16n/variables/variables101/variables101-for-coders.html#a-look-at-coding-with-variables "Permalink to this headline")

Although you do not need to be a coder to take advantage of variables, code provides the flexibility to take variables even further. For that purpose, coders will want to explore the Variables for Coders course in the Developer learning path. However, we can take a brief look here at how coders can work with variables.

## Defining Variables[¶](https://knowledge.dataiku.com/latest/courses/o16n/variables/variables101/variables101-for-coders.html#defining-variables "Permalink to this headline")

All variables are defined as a JSON object. When naming variables, you should follow a convention that uses a descriptive noun and includes only alphanumeric characters or the underscore character.

You can manually define project variables by selecting **… > Variables** from the top navigation bar in Dataiku DSS, and typing the applicable JSON code.

To let others know how the project variables are defined, you can document them in the project’s Wiki.

Note

The project variables page has a section for **global variables** and **local variables**. While the variables that are defined in both sections are project-specific, those that are defined in the “local variables” section are also instance-specific. Therefore, local variables are not exported when you bundle a project for the purpose of deploying it from the design node to the automation node.

You can also visit the product documentation for more details.

## Using Variables in a Code Recipe[¶](https://knowledge.dataiku.com/latest/courses/o16n/variables/variables101/variables101-for-coders.html#using-variables-in-a-code-recipe "Permalink to this headline")

You can define and call variables from any place where you can write code within Dataiku DSS, such as notebooks or code recipes.

The syntax used to define and call variables depends on the code language used in a recipe. For example, the following code in an SQL Recipe calls a variable “your\_variable\_name”:

§ WHERE "column" = '${your\_variable\_name}'

The Dataiku DSS Python API offers multiple ways of getting and setting variables. For example, the following code in a Python recipe calls a variable “your\_variable\_name”:

§ import dataiku

§ dataiku.get\_custom\_variables()["your\_variable\_name"]

Instead of `get\_custom\_variables()`, you can also define a Python dictionary of variables after creating a project handle:

§ import dataiku

§ p = dataiku.Project() # create a project handle

§ variables = p.get\_variables() # retrieve your variables as a dictionary

§ variables["standard"]["your\_variable\_name"] = "your\_variable\_value" # manipulate the dictionary to update the variable you want

§ p.set\_variables(variables) # set the updated dictionary

Note

`get\_variables` gets the variables of this project. Visit the Dataiku Reference Documentation for more details.

As you can see, when calling and updating a variable via code, such as in a code recipe, the core objective is the same as when calling a variable using a visual recipe.

Using code, you can leverage your variables in coding recipes and webapps. You can leverage scenarios to automate the variable update process. For example, you can combine scenarios with applications to update the project variables based on user input, or external parameters such as dates.

## What’s Next?[¶](https://knowledge.dataiku.com/latest/courses/o16n/variables/variables101/variables101-for-coders.html#what-s-next "Permalink to this headline")

Now you can try building a more advanced application that uses a customer ID variable in the **Dataiku Applications Tutorials** lesson: Create a Visual Application.

When you are ready to use variables in the code of your recipes and scenarios, visit the Academy course Variables for Coders.
