# Prerequisites for SQL Integration[¶](https://knowledge.dataiku.com/latest/courses/sql-integration/tech-prerequisites/install-postgresql.html#prerequisites-for-sql-integration "Permalink to this headline")

* DSS Admin permission is required in order to configure a database connection as described below.

Tip

The instructions below refer to a local installation of PostgreSQL. If you’re using Dataiku Online, rather than connect to a local PostgreSQL connection, you might consider starting a free trial using Snowflake Partner Connect, following these instructions.

## Install PostgreSQL[¶](https://knowledge.dataiku.com/latest/courses/sql-integration/tech-prerequisites/install-postgresql.html#install-postgresql "Permalink to this headline")

If it isn’t already available, install PostgreSQL version 9 or above. Take note of the host on which PostgreSQL is installed.

Note

**Tip:** On macOS, we recommend using the Postgres App.

## Create and Configure Your PostgreSQL Database[¶](https://knowledge.dataiku.com/latest/courses/sql-integration/tech-prerequisites/install-postgresql.html#create-and-configure-your-postgresql-database "Permalink to this headline")

At a minimum you need a user and a database, as explained in the PostgreSQL guide. As a best practice, we recommend using schemas in order to administer multiple projects within a database.

For example:

§ psql -h localhost

§ CREATE DATABASE dku;

§ \c dku

§ CREATE SCHEMA dku\_churn;

§ CREATE USER matthieu WITH PASSWORD 'Password';

§ GRANT ALL PRIVILEGES ON SCHEMA dku\_churn TO matthieu;

§ CREATE SCHEMA dku\_tshirt;

§ CREATE USER dku\_tshirt\_admin WITH PASSWORD 'Password';

§ GRANT ALL PRIVILEGES ON SCHEMA dku\_tshirt TO dku\_tshirt\_admin;

§ \q

This sample code creates the user `matthieu`, with password `Password`, and grants this user all privileges (can create and delete tables) in the `dku\_churn` schema in the `dku` database.

Similarly, user `dku\_tshirt\_admin` has been granted all privileges on the `dku\_tshirt` schema in the `dku` database.
