# Concept: Plugin Store Usage[¶](https://knowledge.dataiku.com/latest/courses/plugin-store/plugin-store-concept-summary.html#concept-plugin-store-usage "Permalink to this headline")

Recall that there are four ways to get plugins in Dataiku:

* By installing them from the Dataiku plugin store

* By developing them within Dataiku,

* By uploading .zip files that package plugins, and

* By fetching them from a git repository.

We’ll take a closer look at the plugin store and see how to access new plugins from it.

Tip

This content is also included in a free Dataiku Academy course on the Plugin Store, which is part of the Advanced Designer learning path. Register for the course there if you’d like to track and validate your progress alongside concept videos, summaries, hands-on tutorials, and quizzes.

## Authorization[¶](https://knowledge.dataiku.com/latest/courses/plugin-store/plugin-store-concept-summary.html#authorization "Permalink to this headline")

Recall that a user working on a local instance of Dataiku (such as the Free Edition) can install and develop plugins.

However, on a shared instance (such as in a customer setting), this privilege is restricted to users that are admins or users who have been authorized by an admin to install and develop plugins on the instance.

## Plugin Store Interface[¶](https://knowledge.dataiku.com/latest/courses/plugin-store/plugin-store-concept-summary.html#plugin-store-interface "Permalink to this headline")

You can navigate to the Dataiku plugin store from your Dataiku instance by choosing **Plugins** from the Apps menu. Here, you can install available plugins.

Once in the store, you can see a list of plugins and checkboxes that are useful for filtering the list based on categories such as tags, installation status, and support coverage.

You can also search for plugins in the search box. Dataiku searches the title and the description of the plugin and displays results as you type. The plugins that are available to you in the store will depend on your version of Dataiku.

## Plugin Summary Page[¶](https://knowledge.dataiku.com/latest/courses/plugin-store/plugin-store-concept-summary.html#plugin-summary-page "Permalink to this headline")

For every plugin in the store, you can click **See Details** to see the Summary page. This page contains information such as the author, version, license, tags, components, and a link to the plugin documentation.

From the documentation page, you can also often access the plugin’s Github page, which contains its source code.

## Plugin Usage[¶](https://knowledge.dataiku.com/latest/courses/plugin-store/plugin-store-concept-summary.html#plugin-usage "Permalink to this headline")

Once plugins are installed, how you use them varies depending on their components. The main idea though is that they work just like normal visual components.

For example, you can access **dataset connectors** from the Flow.

You can also access **plugin recipes** from the Flow or the Actions sidebar.

You can access **plugin processors** through the Prepare recipe.

Finally, you can access custom **webapps** through the webapps panel for a webapp template.

Working with plugins fits seamlessly into the overall Dataiku experience. You use plugin components as you would use native Dataiku components.

## Plugin Customization[¶](https://knowledge.dataiku.com/latest/courses/plugin-store/plugin-store-concept-summary.html#plugin-customization "Permalink to this headline")

Finally, if you have the right to install plugins, you can also customize a plugin by converting it to a development plugin.

Although customizing a plugin will prevent you from getting future updates from the store, you’ll have the flexibility to edit the plugin code as desired.

## Learn More[¶](https://knowledge.dataiku.com/latest/courses/plugin-store/plugin-store-concept-summary.html#learn-more "Permalink to this headline")

To learn more about the plugin store, including through hands-on tutorials, please register for the free Academy course on this subject found in the Advanced Designer learning path.

You can also find this hands-on lesson, which uses the Census USA plugin in the Flow, directly linked here.
