# Concept: Introduction to Time Series[¶](https://knowledge.dataiku.com/latest/courses/timeseries-basics/introduction/intro-concept-summary.html#concept-introduction-to-time-series "Permalink to this headline")

Time series data sets consist of repeated numerical measurements of a variable or entity ordered sequentially with time. Data sets containing variables such as the daily closing prices of a stock, or repeated measurements of the average hourly temperature of a room are examples of time series.

## Time Series Properties[¶](https://knowledge.dataiku.com/latest/courses/timeseries-basics/introduction/intro-concept-summary.html#time-series-properties "Permalink to this headline")

Some properties of time series include:

* **Time dependence**: As in the previous examples, the variables in a time series depend on time.

* **Chronological ordering**: The values in a time series are ordered in sequence.

* **Equispaced values**: Time series data entries arrive in equally spaced time intervals, such as hourly, daily, yearly, and so on. In addition, raw time series data can sometimes contain irregularly-spaced entries, thereby requiring some processing to space the data equally.

The time interval used for collecting time series data can depend on data availability and the analysis to be performed on the dataset. For example, data on your electricity usage may be available on the hourly level. However, if you want to study the evolution of your monthly electricity usage, it would be more appropriate to collect this data monthly. Various resampling techniques are available for converting your data from one time interval level to another.

Because of the properties mentioned earlier, time series data sets are different from other tabular data sets that are typically used in data analysis (e.g., a dataset containing measurements of wine density recorded at a specific time).

## Time Series Use-Cases[¶](https://knowledge.dataiku.com/latest/courses/timeseries-basics/introduction/intro-concept-summary.html#time-series-use-cases "Permalink to this headline")

Applications of time series can be found in a wide range of industries, such as:

* **Economics**, for describing the quarterly GDP growth of a country

* **Meteorology**, for forecasting the average monthly temperature of a region

* **Advertising**, for predicting the weekly number of page views for a website,

* **Finance**, for analyzing the daily price changes of stocks
