# Product Recommendation[¶](https://knowledge.dataiku.com/latest/kb/business-solutions/product-reco/product-reco.html#product-recommendation "Permalink to this headline")

Contents

* Overview

+ Business Case

+ Technical Requirements

+ Installation

+ Data Requirements

+ Workflow Overview

* Walkthrough

+ Plug and Play with Your Data and Parameter Choices

+ Prepare our Data and Identify Customer Types

+ Leveraging Item Metadata in Product Recommendations

+ Defining and Training our Recommendation Model

+ Recommending Products to Grow Customer Engagement

+ A Short Note on Automation

+ Reproducing these Processes With Minimal Effort For Your Data

## Overview[¶](https://knowledge.dataiku.com/latest/kb/business-solutions/product-reco/product-reco.html#overview "Permalink to this headline")

### Business Case[¶](https://knowledge.dataiku.com/latest/kb/business-solutions/product-reco/product-reco.html#business-case "Permalink to this headline")

Companies that successfully implement personalization drive 40% more revenue than the average company. And this should come as no surprise: indeed, 71% of consumers expect companies to deliver personalization and are more likely to shop with brands that they recognize, that understand them, and provide relevant offers and recommendations that grow lasting relationships.

Recommending the right product to customers is now a must-do to secure market share and build loyalty. This can notably be done by implementing a recommendation engine based on a collaborative filtering approach which aims at answering a simple question: what items will appeal to customers who share similar preferences? By answering this important question, brands can in turn recommend products that have not yet been purchased by a customer. The resulting outcome: product discovery; increased customer engagement; and improved revenue. With this solution, companies open an opportunity to optimize their customer engagement activities, starting with online experiences: offer a website landing page specifically tailored to logged-in users; a digital app connecting customers to personalized offers; promotional emails personalized based on purchase history; and much more…

### Technical Requirements[¶](https://knowledge.dataiku.com/latest/kb/business-solutions/product-reco/product-reco.html#technical-requirements "Permalink to this headline")

To leverage this solution, you must meet the following requirements:

* Have access to a DSS 11+ instance

* Recommendation System Plugin

* Sankey Charts Plugin

* A Python 3.6 code environment named `solution\_product-recommendations` with the following required packages:

§ Flask==2.0.2

§ scikit-learn==0.20.4

§ Pillow==8.4.0

§ scikit-image==0.17.2

§ opencv-python==4.5.5.64

§ imageio==2.15.0

The Solution is delivered with empty filesystem-managed datasets. Still, it needs SQL databases to use the Recommendation System Plugin, as its recipes depend on a SQL engine to run memory-intensive processes. This solution is compatible with the following connections :

* PostgreSQL

* Snowflake

* Google BigQuery, Microsoft SQL Server, and Azure Synapse are compatible with the plugin but require roll-out services for this Solution.

### Installation[¶](https://knowledge.dataiku.com/latest/kb/business-solutions/product-reco/product-reco.html#installation "Permalink to this headline")

Once your instance has been prepared, you can install this solution in one of two ways:

* On your Dataiku instance click **+ New Project** > **Business solutions** > Search for **Product Recommendation**.

* Download the .zip project file and upload it directly to your Dataiku instance as a new project.

### Data Requirements[¶](https://knowledge.dataiku.com/latest/kb/business-solutions/product-reco/product-reco.html#data-requirements "Permalink to this headline")

The Solution comes without any data, but the following data model should be respected when connecting your data:

* *iteractions\_history* - Mandatory dataset containing records of all the historical interactions between users and items with the following columns:

+ User ID (mandatory)

+ Item ID (mandatory)

+ Date (mandatory)

+ Revenue Identifier (optional)

* *user\_metadata* - Optional dataset containing information about our customers with the following columns:

+ Customer ID (mandatory)

+ Customer Age (optional)

+ Additional columns describing our customers (optional)

* *item\_metadata* - Optional dataset providing information about our products with the following columns:

+ Item ID (mandatory)

+ Categorial Product Description Columns (optional)

+ Datatype Production Description Columns (optional)

+ Name of the .jpg picture file of the Production (optional)

* *item\_pictures* - Optional managed folder containing all our product pictures. All images must be .jpg format

### Workflow Overview[¶](https://knowledge.dataiku.com/latest/kb/business-solutions/product-reco/product-reco.html#workflow-overview "Permalink to this headline")

You can follow along with the sample project in the Dataiku gallery.

The project has the following high-level steps:

Connect your data as input and select your analysis parameters via the Dataiku Application.

Join and prepare our input data.

Apply collaborative filtering on established customers to create negative samples for downstream modeling.

Train a recommendation model with VisualML.

Calculate affinity scores and apply collaborative filtering on growth customers.

Predict product recommendations for growth customers.

Interactively explore the outputs of our analytics flow and automate reports.

## Walkthrough[¶](https://knowledge.dataiku.com/latest/kb/business-solutions/product-reco/product-reco.html#walkthrough "Permalink to this headline")

Note

In addition to reading this document, it is recommended to read the wiki of the project before beginning to get a deeper technical understanding of how this solution was created, the different types of data enrichment available, longer explanations of solution-specific vocabulary, and suggested future direction for the solution.

### Plug and Play with Your Data and Parameter Choices[¶](https://knowledge.dataiku.com/latest/kb/business-solutions/product-reco/product-reco.html#plug-and-play-with-your-data-and-parameter-choices "Permalink to this headline")

You will need to create a new Product Recommendation Dataiku Application instance. This can be done by selecting the Dataiku Application from your instance home and clicking **Create App Instance**.

Once the new instance has been created, you can walk through the application steps to add your data and select the analysis parameters to run. Users of any skill level can input their desired parameters for analysis and view the results directly in a user-friendly Webapp. You could also instantiate multiple **Product Recommendation** projects to compare your approaches.

The first step of the Dataiku Application, **Connection settings**, is to specify the Connection where our data is available to be ingested into the Product Recommendation Solution. It is recommended to use the Dataiku App to reconfigure the flow to your connection and data since it provides a more straightforward and seamless experience than manually updating the flow to your desired connection.

In the following two sections (**Data specifications** and **Columns identification**) of the Dataiku App, we specify the datasets from our connection that we want to use and which optional datasets we want to include before going on to identify the main columns used by each included dataset. After inputting these details and reconfiguring the flow, this allows the Solution to automatically map our data to the data schema of the Solution as simply as possible.

### Prepare our Data and Identify Customer Types[¶](https://knowledge.dataiku.com/latest/kb/business-solutions/product-reco/product-reco.html#prepare-our-data-and-identify-customer-types "Permalink to this headline")

Moving along to the **Recommendation framing** sections of the Dataiku App, we can set the main parameters associated with the data batch used to create our Recommendation System. Here we can:

* Define the data batch parameters, including the reference data and the window of historical data to use for feature engineering and machine learning training

* Set the minimum number of interactions a user must have to be included in the recommendation System

* Define our items selection strategy

* Precise the max number of recommendations to propose for each user

The values that we input in this section and our selections within the **Data specifications** and **Columns identification** are applied to our data via the data prep flow zones. The flow zone, **ages\_clustering**, is optionally run only if our data contains a user’s age column for age clustering. The resulting prepared data has been filtered to our specifications, cleaned and split so that some data is set aside for computing affinity scores, and the rest is ready for training a machine learning model based on the computed affinity scores.

### Leveraging Item Metadata in Product Recommendations[¶](https://knowledge.dataiku.com/latest/kb/business-solutions/product-reco/product-reco.html#leveraging-item-metadata-in-product-recommendations "Permalink to this headline")

In the **Recommendation feature engineering** section of the Dataiku App, we can configure how to use the ingested item metadata for feature engineering. Three options are provided to us:

* Item characteristics feature engineering will apply collaborative filtering on the user-item-characteristics interactions recorded in our specified batch. If chosen, optional flow zones to apply characteristics of collaborative filtering will be run

+ If the above is selected, then we can also select the specific columns to use for computing collaborative filtering features

* Model features enrichment will join item characteristics to all other features so that the recommendation model can take them into account

* Item characteristics feature engineering and model features enrichment will use both methods listed above

Note

Collaborative filtering is an approach to feature engineering that uses information about the number of interactions and user ratings for products to generate affinity scores between users and products. These scores are based on correlations between pairs of items and pairs of users. Using matrix factorization, these affinity scores for a given user/item pair are calculated from the pairwise correlations.

Once we’ve selected how we want to use the item metadata, we can also choose to retrain the ages\_clustering\_model during the flow build.

### Defining and Training our Recommendation Model[¶](https://knowledge.dataiku.com/latest/kb/business-solutions/product-reco/product-reco.html#defining-and-training-our-recommendation-model "Permalink to this headline")

The final section of the Dataiku App where we need to input parameters is the **Product recommendations modeling** section. Here we can configure the machine learning model parameters used for training. To begin, we’ll be asked to choose an optimization strategy between:

* Optimize model ‘Precision’: It means that you will give preference to having a precise model at the risk of missing positive predictions.

* Optimize model ‘Recall’: It means that you will give preference to having an opportunistic model over a precise model.

* Optimize model ‘F1 Score’: It is a trade-off between being precise and opportunistic.

Lastly, we can create model evaluation visualizations (Subpopulation Analysis and PDP) for the Dashboard in order to better understand the model we create. Doing so can prove valuable in model transparency and understanding but will significantly increase computation time. Once we’re satisfied with our chosen parameters, we can press the Run button and wait for the full flow to build. When complete, we can directly go to the pre-built dashboard by clicking the provided link in the Dataiku App.

### Recommending Products to Grow Customer Engagement[¶](https://knowledge.dataiku.com/latest/kb/business-solutions/product-reco/product-reco.html#recommending-products-to-grow-customer-engagement "Permalink to this headline")

The Product Recommendation solution comes with a prebuilt dashboard containing:

* The **Recommendations Explorer** tab provides a prebuilt Webapp to audit and validates the behavior of your Product Recommendations model in an interactive and visually rich way. It will allow us to select users from our operating system and see their historical purchases side-by-side with their recommended products. This can be viewed in a tabular format, or if the item\_images managed folder contains images, in a picture grid way.

* The **Recommendation model evaluation** tab provides metrics by which we can evaluate our model. If we choose to evaluate our model via Subpopulation Analysis, the resulting graph will be available in this tab.

* **Recommendation model interpretation** provides a feature importance graph and, optionally, a partial dependence plot so that we can understand our most important variables and assess the relationship between input features and model predictions

* The **User Analysis** and **Item Analysis** tabs provide several charts to explain our “users” behavior/how items are solicited so that we can iteratively tune the selected parameters of the Dataiku Application to create a more accurate Product Recommendation model

* Lastly, we can get a global overview of the volume of users and items involved in our batch, among all collaborative key milestones, via Sankey Charts provided in the **Recommendation pipelines** tab.

### A Short Note on Automation[¶](https://knowledge.dataiku.com/latest/kb/business-solutions/product-reco/product-reco.html#a-short-note-on-automation "Permalink to this headline")

It is possible to automate the flow of this solution to be triggered based on new data, a specific time, etc, via the Dataiku Application. All of these trigger parameters can be tuned in the **Scenarios** menu of the project. Additionally, reporters can be created to send messages to Teams, Slack, email, etc., to keep our full organization informed. These scenarios can also be run ad-hoc as needed. Full detail on the scenarios and project automation can be found in the wiki.

### Reproducing these Processes With Minimal Effort For Your Data[¶](https://knowledge.dataiku.com/latest/kb/business-solutions/product-reco/product-reco.html#reproducing-these-processes-with-minimal-effort-for-your-data "Permalink to this headline")

The intent of this project is to enable Customer Management and Marketing teams to understand how Dataiku can be used to generate personalized product recommendations for customers. By creating a singular solution that can benefit and influence the decisions of a variety of teams in a single organization, smarter and more holistic strategies can be designed to engage with customers, design marketing strategies, and serve as the basis for better product pricing.

We’ve provided several suggestions on how to use transaction data to recommend products but ultimately, the “best” approach will depend on your specific needs and your data. If you’re interested in adopting this project to the specific goals and needs of your organization, roll-out and customization services can be offered on demand.
