# Getting Started with the Dataiku DSS Plugin Store[¶](https://knowledge.dataiku.com/latest/kb/customization/plugin-management/Getting-Started-with-the-Dataiku-DSS-Plugin-Store.html#getting-started-with-the-dataiku-dss-plugin-store "Permalink to this headline")

## What is the Plugin Store, and how do I access it?[¶](https://knowledge.dataiku.com/latest/kb/customization/plugin-management/Getting-Started-with-the-Dataiku-DSS-Plugin-Store.html#what-is-the-plugin-store-and-how-do-i-access-it "Permalink to this headline")

A plugin is a package of reusable components that extends the functionality of Dataiku DSS. When you develop a plugin, you are extending the native capabilities of DSS. A plugin contains one or more components. A component is a GUI wrapper around custom code that exposes a Dataiku element such as a Recipe, Dataset, or Web App.

The Dataiku DSS Plugin Store is a repository of extensions created by or for DSS. The main actions you can take in the Plugin Store are: browse, search, find by tag, find by support coverage, and view plugin details. If your user profile belongs to the administrator’s group, you can install and update plugins from the Plugin Store.

Plugins vary from the very simple to the very complex. For example, you can retrieve Wikipedia page views, connect with Salesforce data, or get weather forecasts by location. You can find all public plugins in the plugin store. If you are a developer, you can create your own plugins. The possibilities are limitless!

To browse the Plugin Store, first launch Dataiku DSS. Then choose **Plugins** from the Apps menu.

## Search for a plugin[¶](https://knowledge.dataiku.com/latest/kb/customization/plugin-management/Getting-Started-with-the-Dataiku-DSS-Plugin-Store.html#search-for-a-plugin "Permalink to this headline")

To find a plugin, start typing your search criteria in the search box. Dataiku DSS searches the title and the description of the plugin and displays results as you type. For example, if you start typing the first three letters of *Kubernetes*, Dataiku DSS displays all results that contain *kub*.

## See a plugin’s details[¶](https://knowledge.dataiku.com/latest/kb/customization/plugin-management/Getting-Started-with-the-Dataiku-DSS-Plugin-Store.html#see-a-plugins-details "Permalink to this headline")

You can use the Plugin Store to determine where a plugin originated. Click **See Details** to find out a plugin’s details including the author, version, license, tags, and components.

## Install a plugin[¶](https://knowledge.dataiku.com/latest/kb/customization/plugin-management/Getting-Started-with-the-Dataiku-DSS-Plugin-Store.html#install-a-plugin "Permalink to this headline")

To install the plugin from the Plugin Store, you must have permission to install plugins, and your Dataiku DSS instance must have HTTPS connectivity to the internet. If you do not have access to the internet, you can install existing plugins from the store by uploading a Zip file, or from a Git repository.

Note

You can install plugins from the Plugin Store if your user profile belongs to the administrator’s group. For more information about security settings, visit Main Permissions.

### To install a plugin:[¶](https://knowledge.dataiku.com/latest/kb/customization/plugin-management/Getting-Started-with-the-Dataiku-DSS-Plugin-Store.html#to-install-a-plugin "Permalink to this headline")

* Search for the plugin you want to install and click Install.

* Confirm that you want to install the plugin.

* If the plugin requires a dedicated code environment, accept the default option, **Managed by DSS (recommended)**. If you want to manage the code environment manually, select Managed manually. Optionally, you can also select to use Conda or a specific Python environment.

* Click **Build New Environment**. Dataiku DSS displays Environment creation.

* Wait while Dataiku DSS creates the environment and displays Creation result then click **OK**.

* Click **Next** to accept the code environment. Alternatively, If you want to change the code environment, click **Change**. Once completed, DSS displays a success message.

The plugin is now available to use. Click **Go to Plugin Page** to view the installed plugin.

## Use a plugin[¶](https://knowledge.dataiku.com/latest/kb/customization/plugin-management/Getting-Started-with-the-Dataiku-DSS-Plugin-Store.html#use-a-plugin "Permalink to this headline")

### How do I use the plugin after installing it?[¶](https://knowledge.dataiku.com/latest/kb/customization/plugin-management/Getting-Started-with-the-Dataiku-DSS-Plugin-Store.html#how-do-i-use-the-plugin-after-installing-it "Permalink to this headline")

Once installed, the plugin is now available to the DSS instance where you installed it. It is available to all users of the instance. Only administrators can update plugins.

Visit **Plugins > Installed** to view the newly installed plugin:

To use the plugin, open a project on the Dataiku DSS instance where you installed the plugin, then go to the Flow. A plugin can have more than one component. The type of component determines where the plugin displays. For example, if the plugin contains a Recipe component, you will find the plugin under Plugin recipes.

Recipe plugins display in **Plugin recipes**:

Likewise, if the plugin contains a Dataset component, you will find the plugin in the connectors menu:

Finally, if the plugin contains a Web App component, you will find the plugin in the Actions menu when viewing a dataset in the Flow:

## Manage your plugins[¶](https://knowledge.dataiku.com/latest/kb/customization/plugin-management/Getting-Started-with-the-Dataiku-DSS-Plugin-Store.html#manage-your-plugins "Permalink to this headline")

If you have administrator privileges on your instance of Dataiku DSS, you can manage your installed plugins by visiting the Summary, Settings, and Usages tabs.

For example, you can use the **Summary** tab to find out more information about an installed plugin, including which components it contains and whether or not it requires a dedicated code environment.

In the **Settings** tab, you can manage a plugin’s pre-set parameters.

In the **Usages** tab, you can find out all projects that use the plugin. This information is useful when you are deciding whether or not to update or remove a plugin.

## Update a plugin[¶](https://knowledge.dataiku.com/latest/kb/customization/plugin-management/Getting-Started-with-the-Dataiku-DSS-Plugin-Store.html#update-a-plugin "Permalink to this headline")

Plugin authors update their plugins periodically. Check the Plugin Store to find out if there is an available update for your installed plugins. Click **Update** to install the update.

## Remove or uninstall a plugin[¶](https://knowledge.dataiku.com/latest/kb/customization/plugin-management/Getting-Started-with-the-Dataiku-DSS-Plugin-Store.html#remove-or-uninstall-a-plugin "Permalink to this headline")

Dataiku does not recommend removing a plugin. If you must remove a plugin, do the following:

* Check the **Usages** tab to see if any projects are using the plugin.

* If the plugin is not being used, delete the `DATA\_DIR/plugins/installed/name-of-plugin directory`.

## Get support[¶](https://knowledge.dataiku.com/latest/kb/customization/plugin-management/Getting-Started-with-the-Dataiku-DSS-Plugin-Store.html#get-support "Permalink to this headline")

Dataiku Support covers some plugins. Plugins are not supported by default. Plugins covered by Dataiku Support or tier 2 support are explicitly indicated in the Plugin Store. Visit the Reference Documentation to find out more about support tiers.

## Edit a plugin[¶](https://knowledge.dataiku.com/latest/kb/customization/plugin-management/Getting-Started-with-the-Dataiku-DSS-Plugin-Store.html#edit-a-plugin "Permalink to this headline")

You can convert a plugin from the Plugin Store to a Dev Plugin. Use caution. You will not be able to get updates from the store or from your own repositories afterward.

## Find the code for a plugin[¶](https://knowledge.dataiku.com/latest/kb/customization/plugin-management/Getting-Started-with-the-Dataiku-DSS-Plugin-Store.html#find-the-code-for-a-plugin "Permalink to this headline")

You can find the code for some but not all of the public plugins on GitHub.

## What’s next?[¶](https://knowledge.dataiku.com/latest/kb/customization/plugin-management/Getting-Started-with-the-Dataiku-DSS-Plugin-Store.html#whats-next "Permalink to this headline")

You can find out more information about plugins and even get started making your own plugins. Here is some information to get you started:

* Visit the Plugin Store in DSS (Apps > Plugins > Store).

* Product Plugin page.

* GitHub repository. This is a public repository for some published DSS plugins.

* Plugins general reference documentation.

* Developing plugins reference documentation.

* Developing plugins Knowledge Base articles.
