# Start a Dataiku Online Trial from Snowflake Partner Connect[¶](https://knowledge.dataiku.com/latest/kb/dataiku-cloud-offer/snowflake-partner-connect.html#start-a-dataiku-online-trial-from-snowflake-partner-connect "Permalink to this headline")

## Introduction[¶](https://knowledge.dataiku.com/latest/kb/dataiku-cloud-offer/snowflake-partner-connect.html#introduction "Permalink to this headline")

A Dataiku Online Trial through Snowflake Partner Connect provides the following benefits:

* An end-to-end AI solution up & running in minutes.

* Fourteen days of free Dataiku Online Trial.

* Ready-to-use sample projects securely connected to your Snowflake account.

* The ability to easily create additional Snowflake connections and use your data in Dataiku DSS.

Note

If you already have a Dataiku Online account, you can create a Snowflake connection.

## Prerequisites[¶](https://knowledge.dataiku.com/latest/kb/dataiku-cloud-offer/snowflake-partner-connect.html#prerequisites "Permalink to this headline")

* A Snowflake Account — To use Snowflake Partner Connect, you will need to sign in to your Snowflake account or sign up for a new free trial.

Warning

To sign up for a free trial, use the same email address that you use to connect to Dataiku.

When signing up for a free trial, you’ll also need to identify a cloud storage provider.

Tip

After you sign up for a free Snowflake trial, you’ll receive an email message from Snowflake that you can use to activate your Snowflake account. Remember to save this email message. The email contains a link where you can access Snowflake Partner Connect.

## How to Sign Up for a Dataiku Online Trial from Snowflake Partner Connect[¶](https://knowledge.dataiku.com/latest/kb/dataiku-cloud-offer/snowflake-partner-connect.html#how-to-sign-up-for-a-dataiku-online-trial-from-snowflake-partner-connect "Permalink to this headline")

To sign up for a Dataiku Online Trial from Snowflake Partner Connect:

* Sign in to Snowflake using your username and password.

Snowflake displays the console.

Verify that your user is operating under the **Account Admin** role.

To do this:

* Click your account name in the upper right-hand corner.

* Choose **Switch Role** from the drop-down list.

* Click **ACCOUNTADMIN**.

* In the top navigation bar, click **Partner Connect**.

Snowflake displays partner offers.

* Select the **Dataiku tile**.

* Review the information and click **Connect**.

* Click **Activate**.

The Dataiku DSS Snowflake Partner Trial registration displays. To complete the Dataiku DSS Snowflake Partner Trial registration:

* Sign up using the pre-filled email address (this should be the same email address that you used to set up your Snowflake account).

You’ll receive a verification email message.

* From the email message, confirm your email address.

* Accept the legal terms and conditions.

* Complete the additional user information.

Once completed, an instance of Dataiku Online is created for you. Wait for it to finish powering up.

* Click **Open Dataiku DSS** to launch DSS.

Note

To find out how you can get started with Dataiku DSS, you can explore Dataiku Academy and Dataiku Community.

To find out how to create a connection to a specific database in your Snowflake Partner Connect account, visit How to create a Snowflake connection on Dataiku Online.

## Working with the Sample Projects[¶](https://knowledge.dataiku.com/latest/kb/dataiku-cloud-offer/snowflake-partner-connect.html#working-with-the-sample-projects "Permalink to this headline")

Two sample projects that use Snowflake connections are pre-loaded on the DSS instance. These projects are titled *Covid-19* and *Flight Delays Snowflake*.

You can also add a new project from resources such as DSS tutorials and Sample projects. The tutorials and samples may or may not use Snowflake.

### Flight Delays Snowflake[¶](https://knowledge.dataiku.com/latest/kb/dataiku-cloud-offer/snowflake-partner-connect.html#flight-delays-snowflake "Permalink to this headline")

This project is immediately usable. When running the project, sample data is loaded to dedicated tables in the PC\_DATAIKU\_DB Snowflake database using the connection that was automatically created by Partner Connect.

### Covid-19[¶](https://knowledge.dataiku.com/latest/kb/dataiku-cloud-offer/snowflake-partner-connect.html#covid-19 "Permalink to this headline")

Running this project requires first providing data from the Snowflake marketplace to the database PC\_DATAIKU\_DB.

* Using the Snowflake console, navigate to the Snowflake Data Marketplace.

* Locate the COVID-19 Epidemiological Data provided by Starschema

* Connect to the database in the Snowflake console.

* Run the following SQL to copy the required tables to PC\_DATAIKU\_DB:

§ use role PC\_DATAIKU\_ROLE;

§ use database PC\_DATAIKU\_DB;

§ create or replace view JHU\_COVID\_19 as select \* from COVID19.PUBLIC.JHU\_COVID\_19;

§ create or replace view GOOG\_GLOBAL\_MOBILITY\_REPORT as select \* from COVID19.PUBLIC.GOOG\_GLOBAL\_MOBILITY\_REPORT;
