# Code Sample: Find out which users are logged onto the Dataiku instance[¶](https://knowledge.dataiku.com/latest/kb/governance/How-to-find-out-which-users-are-logged-onto-the-DSS-instance.html#code-sample-find-out-which-users-are-logged-onto-the-dataiku-instance "Permalink to this headline")

As a Dataiku administrator, you might need to restart Dataiku and want to know which users are logged onto the instance.

You can use the `list\_users()` method in the Dataiku Python API. The list\_users method returns a value for `activeWebSocketSesssions` which indicates the number of Dataiku sessions a user is logged on. Anything other than 0 indicates that a user is connected to the Dataiku instance.

Here is a code snippet you can use:

§ import dataiku

§ client = dataiku.api\_client()

§ dss\_users = client.list\_users()

§ user\_list = []

§ # Grab list of users where they have active web socket sessions

§ for user in dss\_users:

§ if user['activeWebSocketSesssions'] != 0:

§ user\_list.append(user['displayName'])

§ print(user\_list)
