# Managing Your Dataiku DSS License File[¶](https://knowledge.dataiku.com/latest/kb/setup-admin/configure/licenses/manage-dss-license-fm.html#managing-your-dataiku-dss-license-file "Permalink to this headline")

Dataiku DSS (DSS) requires an up-to-date license to work. A Dataiku administrator uses a license file to install a new DSS instance or update an existing DSS instance.

In this article, you’ll find information for managing your license file, including how to add, update, and read the license file.

## Configuring Your DSS License[¶](https://knowledge.dataiku.com/latest/kb/setup-admin/configure/licenses/manage-dss-license-fm.html#configuring-your-dss-license "Permalink to this headline")

To deploy a DSS instance, you’ll need to configure your DSS license in Fleet Manager.

* For Cloud Stacks on AWS, visit Configure Your Dataiku License.

* For Cloud Stacks on Azure, visit Configure Your Dataiku License.

Note

In addition to the global license. You can configure a sublicense for a particular instance.

## Updating a License File Through the License Override Setting[¶](https://knowledge.dataiku.com/latest/kb/setup-admin/configure/licenses/manage-dss-license-fm.html#updating-a-license-file-through-the-license-override-setting "Permalink to this headline")

You can use the license override setting in Fleet Manager to update a license file.

* For Cloud Stacks on AWS, visit Modifying Instance Templates and Virtual Networks > License Override.

* For Cloud Stacks on Azure, visit Modifying Instance Templates and Virtual Networks > License Override.

## Selecting a Sublicense[¶](https://knowledge.dataiku.com/latest/kb/setup-admin/configure/licenses/manage-dss-license-fm.html#selecting-a-sublicense "Permalink to this headline")

You can configure a sublicense for a particular instance. To do this:

* Launch Fleet Manager.

* Select **Instances** > **All**.

* Select an instance to manage.

* Select the **Settings** tab and then navigate to the License section.

* Choose **Select a sublicense**

* In **Sublicense**, choose the sublicense to apply.

* Save your changes.

## Update a License File for a Cloud Setup[¶](https://knowledge.dataiku.com/latest/kb/setup-admin/configure/licenses/manage-dss-license-fm.html#update-a-license-file-for-a-cloud-setup "Permalink to this headline")

When you deploy a Dataiku instance using Dataiku Cloud Stacks, you configure your Dataiku license. You can update this license. One way to do this is by using the settings under Cloud setup. To do this:

* Launch Fleet Manager.

* Under **Settings**, choose **Cloud setup**.

* Select **Edit**.

* In the License section, under **License mode**, choose **Manually entered**.

* In **License file**, enter your license file. Be sure to copy the JSON file’s entire contents, including the final ‘}’.

* **Save** your changes.

The license file now displays the updated license expiration date. You’ll need to reprovision the instances to apply the updated license information.

### Reprovision the Instance to Apply the Update[¶](https://knowledge.dataiku.com/latest/kb/setup-admin/configure/licenses/manage-dss-license-fm.html#reprovision-the-instance-to-apply-the-update "Permalink to this headline")

To reprovision an instance after updating the license file:

* From **Instances**, choose **All** and then locate the instance.

* Select the name of the instance to view its settings.

* Select **Reprovision** then select **Confirm**.

The operation running in the background is a complete reprovision. A new VM instance is created based on the right template, the same data disk is attached to the instance, and the upgrade procedure is launched. After this, all the configurations defined in the instance template are replayed.

Before reprovisioning, Fleet Manager automatically takes a snapshot of the data disk. If something fails during an upgrade, you can change the version back in the settings and revert to the previous state by selecting **Reprovision From** in the **Snapshots** tab.

## Fetch Usage Statistics in Fleet Manager[¶](https://knowledge.dataiku.com/latest/kb/setup-admin/configure/licenses/manage-dss-license-fm.html#fetch-usage-statistics-in-fleet-manager "Permalink to this headline")

You can fetch quotas and view usage data globally and for each instance that is running. To do this:

* Launch Fleet Manager.

* Under Settings, choose **License management**.

## View License Information from the DSS Administration Menu[¶](https://knowledge.dataiku.com/latest/kb/setup-admin/configure/licenses/manage-dss-license-fm.html#view-license-information-from-the-dss-administration-menu "Permalink to this headline")

You can also view license information, including features and quotas from the instance’s Administration menu. To do this:

* From your DSS instance, select the **Administration** menu.

* Navigate to the **License** tab.

Dataiku displays license information including features and quotas.

## Related Resources[¶](https://knowledge.dataiku.com/latest/kb/setup-admin/configure/licenses/manage-dss-license-fm.html#related-resources "Permalink to this headline")

To learn about Dataiku editions and licenses, visit DSS license. You can also read about Dataiku’s Plans and Features. For terms governing the use of Dataiku software, visit Master License Agreement.

Visit DSS license to find out more about renewing a license file for an Enterprise Edition installation through the Dataikiu DSS user interface.

Each user has a user profile. You can find out about User profiles and licenses by visiting the reference documentation.
