# Build Your Security Model - User Groups[¶](https://knowledge.dataiku.com/latest/kb/setup-admin/configure/security/user-groups.html#build-your-security-model-user-groups "Permalink to this headline")

Dataiku DSS (Dataiku) uses a groups-based model to allow users to perform actions through it. Users can belong to an arbitrary number of groups. Groups can have one or several permissions.

There are two types of permissions: global permissions and per-resource group permissions. Examples of resources controlled by per-resource group permissions include projects, code environments, and Kubernetes clusters.

This article addresses global group permissions which begins with setting up user groups.

Setting up user groups is a three-step process:

* Create a permission model based on user types

* Set up groups and assign permissions

* Verify group membership and permissions

Completing these steps will help you understand the various permissions available and how to assign permissions to different groups. You’ll also be able to verify which permissions are assigned to each group and user after you set up the groups.

## Step 1. Create Permissions Model Based on User Types[¶](https://knowledge.dataiku.com/latest/kb/setup-admin/configure/security/user-groups.html#step-1-create-permissions-model-based-on-user-types "Permalink to this headline")

Before setting up groups in the platform, you should work with relevant teams in your organization to identify the different end-user types. You should start with a small number of groups, around two to four.

When setting up your model, pay special attention to those permissions that create elements for other platform users, like projects, code environments and managed clusters. Those permissions should only be assigned to a small number of people to maintain a clear structure on the platform.

For example, an organization might have three user groups with the following access needs:

* Administrators who configure and maintain the installation and need full access

* Visual users who only need to view and share dashboards

* Data scientists and analysts who need to create, complete and share projects using code

In this article we’ll look at default groups built into Dataiku. We’ll also create a new group and set custom global permissions.

## Step 2. Set Up Groups and Assign Global Permissions[¶](https://knowledge.dataiku.com/latest/kb/setup-admin/configure/security/user-groups.html#step-2-set-up-groups-and-assign-global-permissions "Permalink to this headline")

### Launch Dataiku[¶](https://knowledge.dataiku.com/latest/kb/setup-admin/configure/security/user-groups.html#launch-dataiku "Permalink to this headline")

* Log in to Fleet Manager.

* From **Instances**, choose **All** and then locate the instance you want to manage.

* Select **Go to DSS**.

Note

The instance must be provisioned and running.

### View Default Groups[¶](https://knowledge.dataiku.com/latest/kb/setup-admin/configure/security/user-groups.html#view-default-groups "Permalink to this headline")

* In your Dataiku instance, choose **Administration** from the **Applications** menu.

* Navigate to the **Security** tab.

* In the left panel, select **Groups**.

You should see the three default groups built into each Dataiku instance: administrators, data-team, and readers. You can select each group name to view its settings. This is also where you can change permissions for each group.

Notice the administrator’s group grants all permissions to those in the group, and the instance admin is included in this group by default.

### Create a New Group[¶](https://knowledge.dataiku.com/latest/kb/setup-admin/configure/security/user-groups.html#create-a-new-group "Permalink to this headline")

Let’s say we wanted to create a new group with custom permissions. To do this:

* Select **+New Group** in the top right.

* Type a group name.

* Enter a description.

* Type should be **Local**.

### Assign Global Permissions[¶](https://knowledge.dataiku.com/latest/kb/setup-admin/configure/security/user-groups.html#assign-global-permissions "Permalink to this headline")

Based on the permissions model within your organization, select the permissions you want to allow for this group. Refer to the chart below to learn more about each permission option.

Administrator[¶](https://knowledge.dataiku.com/latest/kb/setup-admin/configure/security/user-groups.html#id2 "Permalink to this table")

| Permission | Description |

| --- | --- |

| Administrator | When you select **Administrator**, all other permissions are automatically selected, meaning members of this group can perform any action on Dataiku. Administrators also may access any project, even without explicitly being granted access to each one. |

Projects creation[¶](https://knowledge.dataiku.com/latest/kb/setup-admin/configure/security/user-groups.html#id3 "Permalink to this table")

| Permission | Description |

| --- | --- |

| Create projects | Allows users to create their own projects using a blank project, project duplication or project import. |

| Create projects using macros | Allows users to create projects using project creation macros, which are administrator-controlled code. |

| Create projects using templates | Allows users to create projects using predefined templates from Dataiku samples and tutorials. |

| Write in root project folder | Allows users to create folders and projects in the root folder, or move them to the root. |

Workspaces[¶](https://knowledge.dataiku.com/latest/kb/setup-admin/configure/security/user-groups.html#id4 "Permalink to this table")

| Permission | Description |

| --- | --- |

| Create workspaces | Allows users to create their own workspaces. |

| Share to workspaces | Allows users to share project objects to workspaces. |

Note

To find out more about setting up workspaces, visit How-To: Set Up Dataiku Workspaces.

Code execution[¶](https://knowledge.dataiku.com/latest/kb/setup-admin/configure/security/user-groups.html#id5 "Permalink to this table")

| Permission | Description |

| --- | --- |

| Write isolated code | Allows users to write code that will run with impersonated rights. This permission is only available when User Isolation Framework is enabled. The framework is automatically managed for you when using Dataiku Cloud Stacks installation. |

| Write unisolated code | Allows users to run local code without impersonation isolation. Code will be executed with the UNIX privileges of the user. |

| Create active Web content | Allows users to author Web content, such as webapps, Jupyter notebooks and RMarkdown reports, that is able to execute JavasScript when viewed by other users. |

Code envs & Dynamic clusters[¶](https://knowledge.dataiku.com/latest/kb/setup-admin/configure/security/user-groups.html#id6 "Permalink to this table")

| Permission | Description |

| --- | --- |

| Manage all code envs | Allows users to create and manage code environments, including their own, those they’ve been given administrative access to, and others. If selected this will automatically also select “Create code envs.” |

| Create code envs | Allows users to create new code environments. Can be selected separately without giving access to manage all code envs. |

| Manage all clusters | Allows users to create and manage clusters, including their own, those they’ve been given administrative access to, and others. If selected this will automatically also select “Create clusters.” |

| Create clusters | Allows users to create new clusters. Can be selected separately without giving access to manage all clusters. |

Advanced permissions[¶](https://knowledge.dataiku.com/latest/kb/setup-admin/configure/security/user-groups.html#id7 "Permalink to this table")

| Permission | Description |

| --- | --- |

| Develop plugins | Allows users to create and edit development plugins. Be aware that this could allow a hostile user to circumvent the permissions system. |

| Edit lib folders | Allows users to edit the Python and R libraries and the static Web resources in the Dataiku instance. |

| Create personal connections | Allows users to create new connections to SQL, NoSQL, and cloud storage. |

| View indexed Hive connections | Allows users to view indexed Hive connections using the Dataiku catalog. |

| Manage user-defined meanings | Allows users to create instance-wide user-defined meanings, which will be accessible and usable by all projects. |

| Create published API services | Allows users to create an API service endpoint and publish it to a Dataiku API node through the Deployer. |

| Create published projects | Allows users to create and publish projects to a Dataiku Automation node through the Deployer. |

### Save Your Changes[¶](https://knowledge.dataiku.com/latest/kb/setup-admin/configure/security/user-groups.html#save-your-changes "Permalink to this headline")

* Click **Save** in the top right.

Dataiku adds the new group to the group management page.

## Step 3. Verify group membership and permissions[¶](https://knowledge.dataiku.com/latest/kb/setup-admin/configure/security/user-groups.html#step-3-verify-group-membership-and-permissions "Permalink to this headline")

You can verify group membership and permissions in one chart.

* Go to **Administration** and select the **Security** tab.

* In the left panel, choose **Authorization Matrix**.

Dataiku displays access permissions by user.

To view access permissions by group:

* Select **By group** from the **By user** menu arrow.

Dataiku now displays access permissions by group.

Note

All permissions are cumulative. Users in a group are granted all of the group permissions, even if they are also a member of a group that doesn’t have the same permissions. Dataiku does not have negative permissions.
