# -*- coding: utf-8 -*-

# Import Libraries
import os
import dataiku
import pandas as pd, numpy as np
from dataiku import pandasutils as pdu
from gtts import gTTS
from io import BytesIO
import tempfile
from pathlib import Path
import shutil


# Read recipe inputs
images_captions = dataiku.Dataset("images_captions")
images_captions_df = images_captions.get_dataframe()

# Read the output folder
folder = dataiku.Folder("ShQW2Upa")

# Set Language for Text-to-Speech
language = 'en'

# Text-to-Speech Conversion Loop
with tempfile.TemporaryDirectory() as tmpdirname:
    for index, row in images_captions_df.iterrows():
        record = gTTS(text=row["captions"], lang=language, slow=False)    
        local_file_path = tmpdirname + "{}.mp3".format(row["images"])
        record.save(local_file_path)
        folder.upload_file("{}.mp3".format(row["images"]), local_file_path)