# -*- coding: utf-8 -*-

# Import necessary libraries and modules
import dataiku
import pandas as pd, numpy as np
from dataiku import pandasutils as pdu
import openai
from openai import OpenAI
import os
import base64
from io import BytesIO
from PIL import Image
import requests

# Function to encode an image into base64 format
def encode_image(image):
    buffered = BytesIO()
    image.save(buffered, format="JPEG")
    return base64.b64encode(buffered.getvalue()).decode('utf-8')

# Access the "questions" dataset
questions = dataiku.Dataset("questions")
questions_df = questions.get_dataframe()

# Access the folder containing images
images = dataiku.Folder("TVEwE7rl")

# Select LLM Model
MODEL = "gpt-4-vision-preview"

# Provide the OpenAI API key
auth_info = dataiku.api_client().get_auth_info(with_secrets=True)
for secret in auth_info["secrets"]:
    if secret["key"] == "openai_key":
        openai_key_provided = True
        openai.api_key = secret["value"]
client = OpenAI(api_key=openai.api_key)

# Declare a list to store the answers
answers = list()

# Iterate through each row in the questions dataset
for i, image_question in questions_df.iterrows():
    # Open the image from the folder
    image_name = image_question["image"]
    with images.get_download_stream(path=image_name) as stream:
        raw_image = Image.open(stream)

    # Encode the image in base64 format
    b64_image = encode_image(raw_image)

    # Retrieve the question associated with the image
    question = image_question["question"]

    # Call the Chat Completion endpoint of the OpenAI API
    result = client.chat.completions.create(
        model=MODEL,
        messages=(
            [
                {"role": "user", "content":
                 [
                  {
                    "type": "text",
                    "text": f"{question}"
                  },
                  {
                    "type": "image_url",
                    "image_url": {
                        "url": f"data:image/jpeg;base64,{b64_image}",
                        "detail" : "low"
                    }
                  }
                ]
              }
            ]
        ),
        temperature=0,
        max_tokens=300
    )

    # Store the result
    answers.append(result.choices[0].message.content)

# Add the answers to the original questions dataframe
questions_df["answer"] = answers

# Write the augmented dataframe with answers to the output dataset
answers = dataiku.Dataset("gpt4v_answers")
answers.write_with_schema(questions_df)