# -*- coding: utf-8 -*-

# Import Libraries
import dataiku
import pandas as pd, numpy as np
from dataiku import pandasutils as pdu
from openai import OpenAI
import openai
import os
from io import BytesIO
from PIL import Image
import base64
import requests

# Function to encode the image as base64
def encode_image(image):
    buffered = BytesIO()
    image.save(buffered, format="JPEG")
    return base64.b64encode(buffered.getvalue()).decode('utf-8')

# Read recipe inputs
images_folder = dataiku.Folder("rwNI6KPi")
images_paths = images_folder.list_paths_in_partition()

# Select LLM Model
MODEL = "gpt-4-vision-preview"

# Provide the OpenAI API key
auth_info = dataiku.api_client().get_auth_info(with_secrets=True)
for secret in auth_info["secrets"]:
    if secret["key"] == "openai_key":
        openai_key_provided = True
        openai.api_key = secret["value"]
client = OpenAI(api_key=openai.api_key)

# Declare a list to store the captions
captions = list()

# Define the prompt for the image captioning task
prompt = """You are an expert in art. Provide a descriptive caption for the painting."""

# Load the images
for img_path in images_paths:
    
    # Open the image from the folder    
    with images_folder.get_download_stream(path=img_path) as stream:
        raw_image = Image.open(stream)

    # Encode the image in base64 format
    b64_image = encode_image(raw_image)

    # Call the Chat Completion endpoint of the OpenAI API
    result = client.chat.completions.create(
        model=MODEL,
        messages=(
            [
                {"role": "user", "content":
                    [
                        {
                            "type": "text",
                            "text": prompt
                        },
                        {
                            "type": "image_url",
                            "image_url": {
                                            "url": f"data:image/jpeg;base64,{b64_image}",
                                            "detail" : "low"
                                        }
                        }
                    ]
                }
            ]
        ),
        temperature=0,
        max_tokens=300
    )
    # Store the result
    captions.append(result.choices[0].message.content)

# Create the final dictionary containing the image paths and the captions
final_captions = {'images': images_paths, 'captions': captions}

# Create the pandas dataframe containing the captions
captions_df = pd.DataFrame(final_captions)

# Write recipe outputs
captions = dataiku.Dataset("images_captions")
captions.write_with_schema(captions_df)