# py_39_llm_vision

## General

**Extra options for pip install**: 

```
--index-url
https://download.pytorch.org/whl/cu117
--extra-index-url
https://pypi.org/simple
```

## List of packages

```
accelerate==0.27.2
aiohttp==3.9.3
aiosignal==1.3.1
annotated-types==0.6.0
anyio==4.2.0
async-timeout==4.0.3
attrs==23.2.0
backcall==0.2.0
bitsandbytes==0.42.0
blinker==1.7.0
certifi==2024.2.2
charset-normalizer==3.3.2
click==8.1.7
cmake==3.28.3
dash==2.15.0
dash-bootstrap-components==1.5.0
dash-core-components==2.0.0
dash-html-components==2.0.0
dash-mantine-components==0.12.1
dash-table==5.0.0
dataclasses-json==0.6.4
datasets==2.14.7
decorator==5.1.1
dill==0.3.7
distro==1.9.0
exceptiongroup==1.2.0
filelock==3.13.1
Flask==3.0.2
frozenlist==1.4.1
fsspec==2023.10.0
ftfy==6.1.3
greenlet==3.0.3
gTTS==2.5.1
h11==0.14.0
httpcore==1.0.3
httpx==0.26.0
huggingface-hub==0.17.3
idna==3.6
importlib-metadata==7.0.1
ipykernel==4.8.2
ipython==7.34.0
ipython-genutils==0.2.0
itsdangerous==2.1.2
jedi==0.19.1
Jinja2==3.1.3
jsonpatch==1.33
jsonpointer==2.4
jupyter-client==6.1.12
jupyter_core==4.12.0
langchain==0.1.7
langchain-community==0.0.20
langchain-core==0.1.23
langchain-openai==0.0.6
langsmith==0.0.87
lit==17.0.6
MarkupSafe==2.1.5
marshmallow==3.20.2
matplotlib-inline==0.1.6
mpmath==1.3.0
multidict==6.0.5
multiprocess==0.70.15
mypy-extensions==1.0.0
nest-asyncio==1.6.0
networkx==3.2.1
numpy==1.23.5
open-clip-torch==2.24.0
openai==1.12.0
packaging==23.2
pandas==1.1.5
parso==0.8.3
pexpect==4.8.0
pickleshare==0.7.5
pillow==10.2.0
plotly==5.19.0
prompt-toolkit==3.0.43
protobuf==4.25.3
psutil==5.9.8
ptyprocess==0.7.0
pyarrow==15.0.0
pyarrow-hotfix==0.6
pydantic==2.6.1
pydantic_core==2.16.2
Pygments==2.17.2
python-dateutil==2.8.2
pytz==2022.7.1
PyYAML==6.0.1
pyzmq==23.2.1
regex==2023.12.25
requests==2.31.0
retrying==1.3.4
safetensors==0.4.2
scipy==1.12.0
sentencepiece==0.1.99
simplegeneric==0.8.1
six==1.16.0
sniffio==1.3.0
SQLAlchemy==2.0.27
sympy==1.12
tenacity==8.2.3
tiktoken==0.6.0
timm==0.9.12
tokenizers==0.14.1
torch==2.0.1+cu117
torchvision==0.15.2+cu117
tornado==5.1.1
tqdm==4.66.2
traitlets==5.1.1
transformers==4.35.1
triton==2.0.0
typing-inspect==0.9.0
typing_extensions==4.9.0
urllib3==1.26.18
wcwidth==0.2.13
Werkzeug==3.0.1
xxhash==3.4.1
yarl==1.9.4
zipp==3.17.0
```

## Resources

```
## Base imports
import os

from dataiku.code_env_resources import clear_all_env_vars
from dataiku.code_env_resources import grant_permissions
from dataiku.code_env_resources import set_env_path
from dataiku.code_env_resources import set_env_var
import huggingface_hub
import torch


# Clears all environment variables defined by previously run script
clear_all_env_vars()

## Hugging Face
# Set HuggingFace cache directory
set_env_path("HF_HOME", "huggingface")
hf_home_dir = os.getenv("HF_HOME")
set_env_path("TRANSFORMERS_CACHE", "transformers")
transformers_home_dir = os.getenv("TRANSFORMERS_CACHE")

from transformers import (
    AutoTokenizer, 
    AutoModelForSeq2SeqLM,
    IdeficsForVisionText2Text,
    AutoProcessor,
    BlipForConditionalGeneration,
    AutoModelForZeroShotImageClassification
)


## LENS
tokenizer = AutoTokenizer.from_pretrained("google/flan-t5-small",truncation_side = 'left',padding = True)
LLM_model = AutoModelForSeq2SeqLM.from_pretrained("google/flan-t5-small")

huggingface_hub.hf_hub_download(
    repo_id="llm-lens/attributes",
    filename="zw_attributes_laion_ViT_H_14_2B_descriptors_text_davinci_003_full.pt",
    local_dir=hf_home_dir + "/" + "weights",
)

huggingface_hub.hf_hub_download(
    repo_id="llm-lens/tags",
    filename="zw_tags_laion_ViT_H_14_2B_vocab_lens.pt",
    local_dir=hf_home_dir + "/" + "weights",
)

# BLIP
blip_model = BlipForConditionalGeneration.from_pretrained("Salesforce/blip-image-captioning-large")
blip_processor = AutoProcessor.from_pretrained("Salesforce/blip-image-captioning-large")

# CLIP
processor = AutoProcessor.from_pretrained("openai/clip-vit-large-patch14")
model = AutoModelForZeroShotImageClassification.from_pretrained("openai/clip-vit-large-patch14")

## IDEFICS
checkpoint = "HuggingFaceM4/idefics-9b-instruct"
model = IdeficsForVisionText2Text.from_pretrained(checkpoint)
processor = AutoProcessor.from_pretrained(checkpoint)

grant_permissions(hf_home_dir)
grant_permissions(transformers_home_dir)
```


