# -*- coding: utf-8 -*-

# Import necessary libraries and modules
import dataiku
import pandas as pd, numpy as np
from dataiku import pandasutils as pdu
from transformers import AutoTokenizer, AutoModelForSeq2SeqLM
from lens import Lens, LensProcessor
from PIL import Image
import torch
import openai
import tiktoken
import os

# Retrieve data from the "questions" dataset
questions = dataiku.Dataset("questions")
questions_df = questions.get_dataframe()

# Access the folder containing images
images = dataiku.Folder("TVEwE7rl")

# Load Hugging face environment path
hf_home_dir = os.getenv("HF_HOME")

# Initialize LENS model and processor
lens = Lens()
processor = LensProcessor()

# Declare a list to store the answers
captions = list()

# Iterate through each row in the questions dataset
for i, image_question in questions_df.iterrows():

    # Open and convert the image to RGB format
    with images.get_download_stream(path=image_question['image']) as stream:
        raw_image = Image.open(stream).convert('RGB')

    # Retrieve the question associated with the image
    question = image_question["question"]

    # Pre-processing through LENS
    with torch.no_grad():

        # Process the raw image through the LENS processor
        samples = processor([raw_image])

        # Get the output from the LENS model
        output = lens(samples)

        # Extract prompts from the LENS output
        prompts = output["prompts"]

    # Store the result
    captions.append(prompts)

# Add the captions to the original questions dataframe
questions_df["captions"] = captions

# Write recipe outputs
answers = dataiku.Dataset("lens_captions")
answers.write_with_schema(questions_df)