# Incorporating AI impacts in BLS employment projections: occupational case studies : Monthly Labor Review: U.S. Bureau of Labor Statistics                       

February 2025

_In the last few years, artificial intelligence (AI) has advanced rapidly, finding growing applications across industries and occupations. This development has generated interest in how the U.S. Bureau of Labor Statistics assesses and incorporates AI’s potential labor market impacts in its employment projections. In this article, we explain the Bureau’s approach to this type of projections work, illustrating it with several occupational case studies based on research done for the 2023–33 projections cycle. The case studies focus on selected occupations in the computer, legal, business and financial, and architecture and engineering occupational groups._

Discussions about advances in artificial intelligence (AI) have become commonplace. In recent years, such advances have received constant news coverage, especially since the deployment of Open AI’s ChatGPT in November 2022.[1](#_edn1) ChatGPT, a natural language processing tool driven by AI technology that allows users to have humanlike conversations, was the first to offer many users the opportunity to directly experience the potential power of AI in their lives. Millions of Americans have since used ChatGPT.[2](#_edn2) Although AI and chatbots are not new, ChatGPT and similar tools have opened a new portal into the world of large language models (LLMs) and their wide-ranging applications.[3](#_edn3) Generative AI (GenAI) tools are becoming increasingly powerful in creating prose, images, videos, and sound. Because of the sheer potential of these tools, many people have been asking how they might affect our future, including that of workers and employment.

The U.S. Bureau of Labor Statistics (BLS) Employment Projections (EP) program approaches AI in the same way as it does other technologies.[4](#_edn4) Established technologies and other structural changes to the labor market have impacts that register in the historical data.[5](#_edn5) BLS projection methods are designed to measure and reflect structural technological changes, and these changes and their employment impacts tend to occur gradually.[6](#_edn6) There have been many claims about new technologies displacing jobs, and although such displacement has occurred in the past, it tends to take longer than technologists typically expect. Various technologies have had occupational impacts throughout recent history, but many affected occupations have still seen employment growth. Although it is always possible that future developments will deviate from historical patterns, BLS projection methods are not designed to capture extremely rapid technological change and, therefore, assume that the overall pace of technological change will be consistent with past experience.

Projecting future employment involves substantial uncertainty, especially in the case of evaluating the future impacts of a developing technology. BLS acknowledges this uncertainty in analyzing the relative likelihood of employment impacts across occupations. In this article, we use case studies to illustrate how BLS considers various factors of uncertainty in its employment projections. The next section provides more details, along with illustrative examples, on how BLS has approached this type of projections work in the past. The section after that presents several case studies, based on EP research done for the 2023–33 projections cycle, examining the potential employment impacts of AI technological advancements on selected occupations in the computer, legal, business and financial, and architecture and engineering occupational groups. The final section concludes, summarizing our results and noting EP’s plans for future research.

## Background and research considerations

EP research connects the potential employment impacts of a new technology with data trends. The goal of this approach is to determine whether these impacts are likely to continue as the new technology grows in adoption and maturation or whether they are likely to diminish as the benefits of the technology are fully realized. For an emerging technology that is not yet reflected in historical data, EP aims to determine whether there is sufficient evidence to support a conclusion about the direction and magnitude of the technology’s future impact on the labor market.

One illustrative example of how this research has affected BLS projections involves photographic process workers. To show a decline in labor demand for this occupation in the early 2000s, when digital cameras were on the verge of displacing most film cameras, EP adjusted its models accordingly. Digital cameras improved on an already-existing technology, and the path to integrating them into business operations and consumer lives was clear. Digital cameras were already replacing film cameras, and the employment impacts of this shift were directly implied by the speed and maturation of technological change. Despite the absence of historical data showing employment declines for photographic process workers, EP projected that employment in the occupation would decline 23.6 percent from 2004 to 2014. Indeed, employment in the occupation started to fall precipitously in the early 2000s, declining from a peak of 86,300 in 2004 to 28,800 in 2014, with a further decline to only 9,200 in 2023.[7](#_edn7)

By contrast, EP did not make any adjustments to its models for another occupation, truck drivers, despite speculations about autonomous vehicles potentially affecting this occupation in the 2010s. At the time, EP determined that the potential impacts of autonomous vehicles were too uncertain, judging that any such impacts were not likely to be felt in the short-to-medium term. Specifically, EP deemed that incorporating the new technology into actual work would likely take time because of regulatory and public safety concerns. So far, history has shown this assumption to have been correct: autonomous trucking remains a developing technology and has not yet had any meaningful employment impacts. Employment of heavy and tractor-trailer truck drivers was about 1.7 million in 2012 and had grown to over 2.2 million by 2023.[8](#_edn8)

The timing and scale of many potential impacts of GenAI are too uncertain to be reflected in BLS projections. New technologies such as autonomous vehicles or AI are harder to assess than technologies that constitute incremental improvements. The lack of relevant historical data on AI technology necessitates assumptions about both the time frame and scale of technological impacts. Brand-new technologies inherently present many sources of uncertainty, including those related to degree of usefulness, developmental roadblocks, regulatory constraints, and pace and cost of adoption. EP generally makes adjustments to its models only if its research on a new technology provides clear expectations for the technology’s employment impacts.

Each occupation involves a set of tasks. Even when a new technology advances rapidly, it takes time for employers and workers to determine how to best incorporate the technology into their work. Although new technologies may change the composition or weighting of tasks performed by workers in an occupation, sometimes dramatically, they may still have no employment impacts. For example, the relatively recent ubiquitousness of smartphones has likely changed the operation of many workplaces, possibly affecting occupational tasks. However, it is unlikely that many workers have lost their jobs to smartphones. In the case of AI, it is important to keep in mind that BLS projections are not about the overall impact of the new technology, but rather about its potential employment impacts.

## Case studies of AI-related occupational employment impacts

The 2023–33 BLS employment projections incorporate AI-related impacts for several occupations for which high exposure to automation is deemed likely. These impacts are discussed in a recent _Monthly Labor Review_ article titled “Industry and occupational employment projections overview and highlights, 2023–33.”[9](#_edn9) However, researchers have identified additional occupations potentially susceptible to AI-related impacts,[10](#_edn10) although the employment trajectories of these occupations remain uncertain.

This section discusses some of these occupations, explaining how any potential AI impacts on them are incorporated—or not—in the 2023–33 National Employment Matrix.[11](#_edn11) The occupations featured in this article are concentrated in the computer, legal, business and financial, and architecture and engineering occupational groups. The employment projections outlined below reflect research based on EP’s interpretation of information available in June 2024, when the program was finalizing its 2023–33 projections. Other interpretations and conclusions derived from existing information are also possible. AI is a new and dynamic technology, and new information about its development and potential uses is continually being released. As such information becomes available, EP will continue to assess the potential employment impacts of AI tools and make appropriate updates to its future sets of projections.

### Computer occupations

Workers in many computer-related occupations use AI in their day-to-day work. Programming is one of many work activities in which new LLMs and GenAI are well suited to augment worker efforts and increase productivity.[12](#_edn12) Software developers can use GenAI to develop, test, and document code; improve data quality; and build user stories that articulate how a software feature will provide value.[13](#_edn13) The effects of AI proliferation on this occupation are highly uncertain. On the one hand, AI is well suited for the occupation’s tasks; on the other hand, increased productivity from the use of AI may lower prices and increase demand for software products, thus boosting employment demand for software developers. In addition, AI itself may lead to increased demand for software developers, who may be needed to develop AI-based business solutions and maintain AI systems. Thus, despite its exposure to GenAI applications, this occupation is unlikely to experience a decline in employment, because robust software needs are expected to support continued demand for its workers. Although it is always possible that AI-induced productivity improvements will outweigh continued labor demand, there is no clear evidence to support this conjecture. Given these considerations, BLS projects employment of software developers to increase 17.9 percent between 2023 and 2033, much faster than the average for all occupations (4.0 percent). (See table 1.)

Database administrators (DBAs) and database architects are other examples of computer occupations susceptible to potential AI impacts. With ever-growing volumes of data comes the need for data maintenance and security. Increased labor demand for DBAs and database architects is expected to stem from growing demand for cloud computing and data infrastructure. According to one report on the potential applications of GenAI across industries, superannuated data infrastructure is among the greatest obstacles to business implementation of the technology: “As organisations adopt GenAI, tech, cloud and data infrastructure will need to be set up effectively—both the technology ecosystem and the capabilities within it. For example, data in many organisations is spread across multiple systems and data infrastructure will need to be set up in the right way to be able to benefit from GenAI.”[14](#_edn14) Consistent with this observation, a common refrain heard by BLS staff from other researchers, economists, and professors on the subject of AI is the claim that insufficient data infrastructure is the greatest obstacle to AI usage.[15](#_edn15) Greater adoption of AI is expected to lead to greater database complexity, which could support additional demand for DBAs and database architects.[16](#_edn16) As businesses race to integrate AI solutions into their workflows, they will need DBAs and database architects to navigate the obstacles to such integration.

However, AI tools also have the potential to perform many DBA tasks, such as generating code, predictive analysis, and system integration.[17](#_edn17) Survey results documented in a 2024 industry report by Redgate suggest that, at the time of the survey, more than half of respondents were either already using AI to improve the productivity of database management work or considering doing so in the near future.[18](#_edn18) As more AI tools are integrated into systems management, the tasks of DBAs and database architects will likely evolve.[19](#_edn19) Although some people may see these productivity enhancements as potentially leading to slower job growth in these occupations, their employment effects are projected to be outweighed by those of strong business demand for database management and data infrastructure solutions. Indeed, integration of AI into business operations is likely to spur even more demand for these workers. In the 2023–33 projections, employment of DBAs is projected to grow 8.2 percent, faster than average, and employment of database architects is projected to grow 10.8 percent, much faster than average. (See table 1.)

Table 1. Employment projections for selected computer occupations susceptible to potential artificial intelligence impacts, 2023–33

2023 NEM occupation title

2023 NEM occupation code

Employment, 2023  
(thousands)

Employment, 2033  
(thousands)

Numeric change, 2023–33  
(thousands)

Percent change, 2023–33

Total, all occupations

00-0000

167,849.8

174,589.0

6,739.2

4.0

Computer occupations

15-1200

5,021.8

5,608.5

586.8

11.7

Database administrators

15-1242

80.5

87.1

6.6

8.2

Database architects

15-1243

61.4

68.0

6.6

10.8

Software developers

15-1252

1,692.1

1,995.7

303.7

17.9

Note: Research by the U.S. Bureau of Labor Statistics indicates that the occupations included in the table are likely to be affected by artificial intelligence, but they are not intended as an exhaustive list of occupations susceptible to such impacts. NEM = National Employment Matrix.

Source: U.S. Bureau of Labor Statistics, Employment Projections program.

### Legal occupations

GenAI, particularly LLMs, can potentially greatly enhance productivity in the legal services industry. This technology can sift through massive amounts of information and synthesize findings, thereby reducing the time lawyers and paralegals spend on various tasks related to document review. Among the legal, tax, and accounting professionals surveyed for one study in 2023, 67 percent “forecasted the emergence of AI and generative AI to have either a transformational or high-impact change to their profession over the next five years.”[20](#_edn20) Improved productivity was the top priority for 3 in 4 law firms surveyed, followed by improved internal efficiency.[21](#_edn21) Similarly, another 2023 study found that the “legal profession had the second highest \[AI\] exposure, with an estimated 44% of tasks susceptible to automation.”[22](#_edn22)

In recent years, several companies have started to provide machine learning or GenAI services to law firms for tasks such as contract review, pretrial discovery, or research.[23](#_edn23) For example, some existing AI tools can comb legal libraries during the discovery process, while others can serve as study guides or encyclopedias of the law.[24](#_edn24) Researchers at Stanford Law School confirm these developments, noting that “a dizzying number of legal technology startups and law firms are now advertising and leveraging LLM-based tools for a variety of tasks.”[25](#_edn25) Some of these tools are already in use to some degree, and more law firms are expected to adopt them over the 2023–33 projections decade. Partly for this reason, employment growth in the legal services industry is projected to be slower (1.6 percent) than growth for the total economy (4.0 percent).[26](#_edn26)

Among legal occupations, paralegals and legal assistants are expected to see the strongest employment impact from the productivity gains afforded by GenAI.[27](#_edn27) Although the new technology is also likely to increase productivity for lawyers, workers in this occupation will still need to review output from LLMs and to conduct tasks for which clients may prefer human interaction (e.g., advising services). Despite GenAI’s great potential for enhancing the efficiency of producing legal briefs and other documents, that output will still require detailed review by lawyers because it may contain errors or biases.[28](#_edn28) Given that accuracy is very important in legal settings and existing AI tools cannot provide the legal context a human can, there will continue to be a need for human reviewers to understand ambiguities, identify model hallucinations or other errors, and ensure that true intent is captured.[29](#_edn29) In addition, the efficiency gains from using LLMs may allow lawyers to spend more time on networking, trial preparation, and other aspects of legal work.[30](#_edn30)

These productivity gains can potentially lower costs for clients by reducing billable hours, allowing law firms to offer more competitive pricing. Because of continued demand for legal services, employment of lawyers is projected to grow 5.2 percent through 2033, about as fast as the average for all occupations. (See table 2.) This projected growth rate, which is slower than that in the two previous projections sets, reflects an expectation of modest productivity gains against a backdrop of strong overall demand (reflected in the projection for the legal services industry, which employs more than half of all lawyers).

Table 2. Employment projections for selected legal occupations susceptible to potential artificial intelligence impacts, 2023–33

2023 NEM occupation title

2023 NEM occupation code

Employment, 2023  
(thousands)

Employment, 2033  
(thousands)

Numeric change, 2023–33  
(thousands)

Percent change, 2023–33

Total, all occupations

00-0000

167,849.8

174,589.0

6,739.2

4.0

Legal occupations

23-0000

1,394.4

1,446.2

51.8

3.7

Lawyers

23-1011

859.0

903.3

44.2

5.2

Paralegals and legal assistants

23-2011

366.2

370.5

4.3

1.2

Note: Research by the U.S. Bureau of Labor Statistics indicates that the occupations included in the table are likely to be affected by artificial intelligence, but they are not intended as an exhaustive list of occupations susceptible to such impacts. NEM = National Employment Matrix.

Source: U.S. Bureau of Labor Statistics, Employment Projections program.

### Business and financial operations occupations

The business and financial operations occupational group also may be affected by AI. The new technology is largely expected to improve productivity growth for certain occupations within the group, thus moderating or reducing (but not eliminating) employment demand for them. 

Among the occupations included in this group are two insurance-related occupations: claims adjusters, examiners, and investigators; and insurance appraisers, auto damage. Claims adjusting and examining involve assessing damage to property (often a house or a car) in order to estimate the required payouts insurance companies must pay to their customers. In recent years, insurance companies have deployed drones to take aerial photographs of sites, without sending a human examiner into the field.[31](#_edn31) In the future, AI is expected to work in tandem with drone technology to further bolster productivity. Once photographs are taken, the analysis and initial payout estimates, traditionally prepared by an adjuster, can be autogenerated by AI.[32](#_edn32) In addition, AI can speed up other tasks performed by claims adjusters, examiners, and investigators, including summarizing “policies, documents and other unstructured forms of content.”[33](#_edn33) Insurance appraisers, auto damage—a smaller occupation—are also expected to be affected by this technology because they can use the same damage-assessment software for cars and trucks.[34](#_edn34) These developments mean that more insurance-related work can be done with fewer employees, reducing employment demand. Over the 2023–33 projections period, employment of claims adjusters, examiners, and investigators is projected to decline 4.4 percent, and employment of insurance appraisers, auto damage, is projected to decline 9.2 percent. (See table 3.)

Personal financial advisors, another occupation in the business and financial operations occupational group, have already begun to see job competition from AI. Specifically, app-based “robo-advisors” have started to compete with human advisors by providing automated financial advice on how much users should spend, save, and invest and how they should allocate their investments. Robo-advisors are especially popular with younger people, who tend to be more comfortable with newer technology and have simpler financial planning needs.[35](#_edn35) However, given that the share of older age groups in the U.S. population is expected to increase over the projections period, the underlying demand for human financial advisors is likely to remain strong.[36](#_edn36) Because older people are closer to or past retirement age, they have more accumulated savings and more complex investment advisory needs. A 2020 study found that the uptake of robo-advisors among older adults is “very limited,” reportedly because these individuals are less likely to trust the technology.[37](#_edn37) In addition, a 2023 survey found that the vast majority of robo-advisor users are in their twenties, thirties, and forties, with only 5.9 percent in their sixties or older.[38](#_edn38) These population and usage patterns suggest that the demographic subset more likely to prefer human advisors will have more weight in the personal financial advisory market than the younger, app-friendly subset. Therefore, although AI technology can compete with personal financial advisors at their core tasks, demand for human advisors is still expected to remain very strong over the projections decade. Employment of personal financial advisors is projected to grow 17.1 percent from 2023 to 2033, much faster than average. (See table 3.)

Several “analyst” occupations within the business and financial operations occupational group are also susceptible to potential impacts from AI automation. Because these occupations largely involve desk work in which computer software is already a primary tool of the trade, further software advances driven by AI could raise the productivity of many analysts but are unlikely to eliminate employment demand for them. For example, budget analysts, who are predominantly employed by government agencies, prepare and review budgets and perform socially oriented tasks such as making presentations and answering questions from stakeholders. Although AI will likely speed up the budgeting review process and even offer data visualization tools that can be used in presentations, the communication and customer service tasks of budget analysts (e.g., discussing the nuances and alternative paths of proposed budgets) will likely continue to require conversations between humans and cannot be easily replaced by AI. Given the expectation for a strong floor of demand for the core tasks performed by these workers, employment of budget analysts is projected to grow 3.9 percent from 2023 to 2033, about as fast as the average for all occupations. (See table 3.)

Credit analysts also are experiencing the effects of automation. These workers analyze financial data and prepare reports used by lending firms to determine whether credit can be extended to individuals or businesses. AI can synthesize large amounts of data and reach big-picture conclusions, and, indeed, these tasks are the essence of a credit rating, which combines a range of financial information on a potential borrower into an overall score. As AI improves, the speed and accuracy of producing credit scores and reports will increase.[39](#_edn39) Therefore, credit analysts are likely to see decreasing employment demand, and their employment is projected to decline 3.9 percent from 2023 to 2033. (See table 3.)

By comparison, financial and investment analysts are more protected from the effects of AI. Like personal financial advisors, these workers perform tasks with varying tolerance for automation, depending on the employer. Some financial firms lean heavily on automated trading with algorithm-based sales and purchases throughout a day, whereas others focus on long-term investments based on deliberate decisions made by a team of analysts who consider a wide range of variables.[40](#_edn40) Although the latter investment strategy may benefit from software improvements (such as those providing faster and more useful numeric comparisons across securities),[41](#_edn41) the final investment decisions associated with it will still be made by humans. Therefore, a sizeable share of institutional investment will still rely on financial and investment analysts. Employment of these workers is projected to grow 9.5 percent from 2023 to 2033, much faster than average. (See table 3.)

Table 3. Employment projections for selected business and financial operations occupations susceptible to potential artificial intelligence impacts, 2023–33

2023 NEM occupation title

2023 NEM occupation code

Employment, 2023  
(thousands)

Employment, 2033  
(thousands)

Numeric change, 2023–33  
(thousands)

Percent change, 2023–33

Total, all occupations

00-0000

167,849.8

174,589.0

6,739.2

4.0

Business and financial operations occupations

13-0000

10,977.2

11,738.5

761.3

6.9

Claims adjusters, examiners, and investigators

13-1031

345.2

330.0

\-15.2

\-4.4

Insurance appraisers, auto damage

13-1032

10.5

9.5

\-1.0

\-9.2

Budget analysts

13-2031

50.8

52.7

2.0

3.9

Credit analysts

13-2041

73.7

70.8

\-2.8

\-3.9

Financial and investment analysts

13-2051

347.4

380.5

33.1

9.5

Personal financial advisors

13-2052

321.0

375.9

55.0

17.1

Note: Research by the U.S. Bureau of Labor Statistics indicates that the occupations included in the table are likely to be affected by artificial intelligence, but they are not intended as an exhaustive list of occupations susceptible to such impacts. NEM = National Employment Matrix.

Source: U.S. Bureau of Labor Statistics, Employment Projections program.

### Architecture and engineering occupations

GenAI can support many tasks involved in architecture and engineering occupations, potentially increasing worker productivity. In fact, many engineering fields are already harnessing the power of various AI tools. Although these developments may affect labor demand, the unique technical expertise of engineering professionals and existing regulatory requirements create uncertainty about the extent and employment impact of AI adoption. For this reason, underlying demand for engineering services is expected to remain strong, resulting in employment growth for most engineering occupations over the 2023–33 decade.

For example, civil engineers can use AI to account for specific building codes in designing complex mechanical, electrical, and plumbing systems, thus reducing the incidence of errors and design revisions and accelerating the design process. Yet, government-mandated quality-control regulations still require civil and other professional engineers to review and approve any work completed with the use of emerging technologies. Although open-source LLMs and small language models (SLMs) can complete specialized tasks when trained on high-quality data,[42](#_edn42) the level of technical knowledge needed to navigate the intricacies of civil engineering work, such as those involving complex calculations or adherence to codes, will keep civil engineers in demand.[43](#_edn43) As a result, the magnitude of productivity enhancements offered by various AI tools remains unclear, and strong underlying demand for civil engineering services is expected to offset the potential employment impacts of efficiency gains. Employment of civil engineers is projected to grow 6.5 percent from 2023 to 2033, faster than the average for all occupations. (See table 4.)

Two other engineering occupations—aerospace engineers and aerospace engineering and operations technologists and technicians—may also see some of their specific tasks completed or aided by GenAI. Aerospace engineers can leverage GenAI in aircraft design, prescriptive analytics, and predictive maintenance in order to increase productivity and efficiency.[44](#_edn44) Likewise, aircraft and avionics equipment mechanics and technicians can use GenAI tools to perform various aircraft maintenance tasks, achieving more efficient and timely maintenance processes.[45](#_edn45) Despite these enhancements, demand for workers in these occupations is expected to be strong because of the need to comply with federal regulations around quality control for passenger aircraft, as well as continued interest in and funding for commercial air transportation. Therefore, although both occupations are expected to see productivity improvements from GenAI, they are still projected to add jobs over the projections period. Employment of aerospace engineers is projected to grow 6.0 percent from 2023 to 2033, faster than average, and employment of aerospace engineering and operations technologists and technicians is projected to grow 7.9 percent, also faster than average. (See table 4.)

Electrical and electronic engineering occupations may be even more insulated from any employment impacts stemming from the increased use of GenAI. This condition is due to the vast need for electrical and electronic circuitry and infrastructure modernization to support grid updates, electric-vehicle (EV) manufacturing, and other activities in industries reliant on electrical systems. So far, companies have released GenAI tools to more efficiently complete semiconductor chip and electrical circuit design tasks and related activities.[46](#_edn46) For computer hardware engineers, the greatest productivity enhancements are estimated to come from increased efficiency in debugging tasks aided by LLMs.[47](#_edn47) However, despite the rising use of GenAI and LLMs in electrical and electronic device engineering activities, employment of the workers performing these activities is still expected to grow. Over the next decade, the need for energy-efficient electronic features in EVs and electronic control units across products is likely to be robust,[48](#_edn48) driving up labor demand. As a result, between 2023 and 2033, employment is expected to grow for electrical and electronics engineers (9.1 percent), electrical and electronic engineering technologists and technicians (3.0 percent), and computer hardware engineers (7.2 percent). (See table 4.)

Table 4. Employment projections for selected architecture and engineering occupations susceptible to potential artificial intelligence impacts, 2023–33

2023 NEM occupation title

2023 NEM occupation code

Employment, 2023  
(thousands)

Employment, 2033  
(thousands)

Numeric change, 2023–33  
(thousands)

Percent change, 2023–33

Total, all occupations

00-0000

167,849.8

174,589.0

6,739.2

4.0

Architecture and engineering occupations

17-0000

2,639.7

2,819.7

180.0

6.8

Aerospace engineers

17-2011

68.9

73.0

4.1

6.0

Civil engineers

17-2051

341.8

363.9

22.1

6.5

Electrical engineers

17-2071

189.1

206.3

17.2

9.1

Electronics engineers, except computer

17-2072

98.7

107.6

8.9

9.1

Aerospace engineering and operations technologists and technicians

17-3021

11.0

11.9

0.9

7.9

Electrical and electronic engineering technologists and technicians

17-3023

99.6

102.6

3.0

3.0

Note: Research by the U.S. Bureau of Labor Statistics indicates that the occupations included in the table are likely to be affected by artificial intelligence, but they are not intended as an exhaustive list of occupations susceptible to such impacts. NEM = National Employment Matrix.

Source: U.S. Bureau of Labor Statistics, Employment Projections program.

## Conclusion

The potential for AI, particularly GenAI, to disrupt future employment has been a prominent topic in recent economic commentary. BLS employment projections consider and reflect the productivity-enhancing effects of automation and a wide range of technologies, including AI, on occupations and industries. Over the 2023–33 projections period, AI is expected to primarily affect occupations whose core tasks can be most easily replicated by GenAI in its current form. These occupations include medical transcriptionists and customer service representatives, whose employment is projected to decline by 4.7 and 5.0 percent, respectively, through 2033.[49](#_edn49)

Other occupations also may see AI impacts, although not to the same extent. For instance, computer occupations may see productivity impacts from AI, but the need to implement and maintain AI infrastructure could in actuality boost demand for some occupations in this group. Among legal occupations, paralegals and legal assistants are likely to experience lower employment demand because of LLM adoption, while lawyers are expected to be less affected. Within business and financial operations occupations, insurance adjusters and appraisers are expected to see reduced employment demand, with AI being able to quickly produce monetary estimates of property damage. Meanwhile, other occupations in this group, such as personal financial advisors, will likely continue to see strong employment growth because demand for human counsel in complex financial matters will persist, particularly for older clients. Architecture and engineering occupations may see some productivity gains from GenAI, but these gains will likely be in line with those afforded by software and other technological advancements in prior decades. As a result, occupations in this group are not expected to see substantial GenAI-driven reductions in employment demand over the projections period.

Each year, BLS issues new 10-year projections that incorporate new data, research, and analysis. EP continually conducts research on new technologies, including AI and LLMs, to better understand their potential employment and economic impacts over the projections period. Besides reflecting these findings in its 10-year projections, the program also evaluates previous projections, explores shifts among skills that are in demand, and considers the potential for technology to create new types of jobs. EP will continue to monitor AI as it evolves, ensuring that BLS projections reflect an updated assessment of the latest developments in this technology and its likely employment impacts.

Suggested citation:

Christine Machovec, Michael J. Rieley, and Emily Rolen, "Incorporating AI impacts in BLS employment projections: occupational case studies," _Monthly Labor Review,_ U.S. Bureau of Labor Statistics, February 2025, [https://doi.org/10.21916/mlr.2025.1](https://doi.org/10.21916/mlr.2025.1)

## Notes

* * *

[1](#_ednref1) “Introducing ChatGPT” (OpenAI, November 30, 2022), [https://openai.com/index/chatgpt/](https://openai.com/index/chatgpt/).

[2](#_ednref2) Colleen McClain, “Americans’ use of ChatGPT is ticking up, but few trust its election information” (Washington, DC: Pew Research Center, March 26, 2024), [https://www.pewresearch.org/short-reads/2024/03/26/americans-use-of-chatgpt-is-ticking-up-but-few-trust-its-election-information/](https://www.pewresearch.org/short-reads/2024/03/26/americans-use-of-chatgpt-is-ticking-up-but-few-trust-its-election-information/).

[3](#_ednref3) “What are large language models (LLMs)?” (IBM, November 2, 2023), [https://www.ibm.com/think/topics/large-language-models](https://www.ibm.com/think/topics/large-language-models).

[4](#_ednref4) For more information on the Employment Projections (EP) program’s methodology, see “Employment projections: overview,” _Handbook of Methods_ (U.S. Bureau of Labor Statistics, last modified August 29, 2024), [https://www.bls.gov/opub/hom/emp/](https://www.bls.gov/opub/hom/emp/).

[5](#_ednref5) For more details on the historical record of automation, see Michael J. Handel, “Growth trends for selected occupations considered at risk from automation,” _Monthly Labor Review_, July 2022, [https://doi.org/10.21916/mlr.2022.21](https://doi.org/10.21916/mlr.2022.21).

[6](#_ednref6) See “Employment projections: overview.”

[7](#_ednref7) See “2014–24 projections” (downloadable compressed file) in “Projections archive,” _Employment Projections_ (U.S. Bureau of Labor Statistics, last modified August 29, 2024), [https://www.bls.gov/emp/data/projections-archive.htm](https://www.bls.gov/emp/data/projections-archive.htm). Historical EP releases are available online, going back to the 2008–18 projections set. Older data are available upon request.

[8](#_ednref8) See “2012–22 projections” (downloadable compressed file) in “Projections archive.”

[9](#_ednref9) Javier Colato, Lindsey Ice, and Sofia Laycock, “Industry and occupational employment projections overview and highlights, 2023–33,” _Monthly Labor Review_, November 2024, [https://doi.org/10.21916/mlr.2024.21](https://doi.org/10.21916/mlr.2024.21).

[10](#_ednref10) Edward W. Felten, Manav Raj, and Robert Seamans, “Occupational heterogeneity in exposure to Generative AI” (SSRN, April 10, 2023), pp. 2, 12, [https://papers.ssrn.com/sol3/papers.cfm?abstract\_id=4414065](https://papers.ssrn.com/sol3/papers.cfm?abstract_id=4414065); and A. Shaji George, A. S. Hovan George, and A. S. Gabrio Martin, “ChatGPT and the future of work: a comprehensive analysis of AI’s impact on jobs and employment,” _Partners Universal International Innovation Journal_, vol. 1, no. 3, May–June 2023, pp. 157–173, [https://puiij.com/index.php/research/article/view/57](https://puiij.com/index.php/research/article/view/57).

[11](#_ednref11) The National Employment Matrix (NEM) is a cross-tabulation of industries and occupations that displays data on projected employment. The NEM database can be searched by occupation or industry. For further details, see “Occupational employment projections data,” _Employment Projections_ (U.S. Bureau of Labor Statistics, last modified August 29, 2024), [https://www.bls.gov/emp/data/occupational-data.htm](https://www.bls.gov/emp/data/occupational-data.htm).

[12](#_ednref12) Fabrizio Dell’Acqua, Edward McFowland III, Ethan Mollick, Hila Lifshitz-Assaf, Katherine C. Kellogg, Saran Rajendran, Lisa Krayer, François Candelon, and Karim R. Lakhani, “Navigating the jagged technological frontier: field experimental evidence of the effects of AI on knowledge worker productivity and quality,” Working Paper 24-013 (Harvard University, Harvard Business School, September 22, 2023), p. 3, [https://www.hbs.edu/ris/Publication%20Files/24-013\_d9b45b68-9e74-42d6-a1c6-c72fb70c7282.pdf](https://www.hbs.edu/ris/Publication%20Files/24-013_d9b45b68-9e74-42d6-a1c6-c72fb70c7282.pdf).

[13](#_ednref13) Jay Bhatnagar, Jonathan Frick, and Arun Ganti, “The talent implications of Generative AI,” in _Technology Report 2023_ (Bain & Company, September 18, 2023), p. 65, [https://www.bain.com/insights/the-talent-implications-of-generative-ai-tech-report-2023/](https://www.bain.com/insights/the-talent-implications-of-generative-ai-tech-report-2023/).

[14](#_ednref14) “GenAI: which industries and sectors have the greatest potential for value creation?” (Strategy& United Kingdom, accessed May 15, 2024), [https://www.strategyand.pwc.com/uk/en/insights/genai.html](https://www.strategyand.pwc.com/uk/en/insights/genai.html).

[15](#_ednref15) _The State of the Database Landscape_ (Redgate Software, Inc., 2024), [https://www.red-gate.com/solutions/entrypage/state-of-database-landscape-2024/ai](https://www.red-gate.com/solutions/entrypage/state-of-database-landscape-2024/ai).

[16](#_ednref16) Mariusz Kujawski, “From database to AI: the evolution of data platforms,” _Medium_, January 8, 2024, [https://medium.com/@mariusz\_kujawski/from-database-to-ai-the-evolution-of-data-platforms-59f487e235df](https://medium.com/@mariusz_kujawski/from-database-to-ai-the-evolution-of-data-platforms-59f487e235df).

[17](#_ednref17) Dell’Acqua et al., “Navigating the jagged technological frontier,” p. 3.

[18](#_ednref18) Ibid.; and _The State of the Database Landscape._

[19](#_ednref19) Tania Babina, Anastassia Fedyk, Alex Xi He, and James Hodson, “Firm investments in artificial intelligence technologies and changes in workforce composition” (SSRN, December 10, 2023), pp. 23, 25–26, [https://ssrn.com/abstract=4060233](https://ssrn.com/abstract=4060233).

[20](#_ednref20) _Future of Professionals Report: How AI is the Catalyst for Transforming Every Aspect of Work_ (Thomson Reuters, August 2023), p. 7, [https://www.thomsonreuters.com/content/dam/ewp-m/documents/thomsonreuters/en/pdf/reports/future-of-professionals-august-2023.pdf](https://www.thomsonreuters.com/content/dam/ewp-m/documents/thomsonreuters/en/pdf/reports/future-of-professionals-august-2023.pdf).

[21](#_ednref21) Ibid., p. 8.

[22](#_ednref22) Roger E. Barton, “How will leveraging AI change the future of legal services?,” _Reuters_, August 23, 2023, [https://www.reuters.com/legal/legalindustry/how-will-leveraging-ai-change-future-legal-services-2023-08-23/](https://www.reuters.com/legal/legalindustry/how-will-leveraging-ai-change-future-legal-services-2023-08-23/).

[23](#_ednref23) Matthew Stepka, “Law bots: how AI is reshaping the legal profession,” _Business Law Today_ (American Bar Association, February 21, 2022), [https://businesslawtoday.org/2022/02/how-ai-is-reshaping-legal-profession/](https://businesslawtoday.org/2022/02/how-ai-is-reshaping-legal-profession/).

[24](#_ednref24) See, for example, “What can CoCounsel do?” (Thomson Reuters, accessed August 15, 2024), [https://casetext.com/cocounsel/](https://casetext.com/cocounsel/); and Eric Revell, “Thomson Reuters launches new AI tools for legal professionals,” _Fox Business_, March 2, 2024, [https://www.msn.com/en-us/money/other/thomson-reuters-launches-new-ai-tools-for-legal-professionals/ar-BB1jdJSV](https://www.msn.com/en-us/money/other/thomson-reuters-launches-new-ai-tools-for-legal-professionals/ar-BB1jdJSV).

[25](#_ednref25) Matthew Dahl, Varun Magesh, Mirac Suzgun, and Daniel E. Ho, “Hallucinating law: legal mistakes with large language models are pervasive” (Stanford University, Stanford Law School, January 11, 2024), [https://law.stanford.edu/2024/01/11/hallucinating-law-legal-mistakes-with-large-language-models-are-pervasive/](https://law.stanford.edu/2024/01/11/hallucinating-law-legal-mistakes-with-large-language-models-are-pervasive/).

[26](#_ednref26) “Table 2.11. Employment and output by industry (employment in thousands of jobs; output in billion of chained 2017 dollars),” _Employment Projections_ (U.S. Bureau of Labor Statistics, last modified August 29, 2024), [https://www.bls.gov/emp/tables/industry-employment-and-output.htm](https://www.bls.gov/emp/tables/industry-employment-and-output.htm).

[27](#_ednref27) Colato, Ice, and Laycock, “Industry and occupational employment projections overview and highlights, 2023–33.”

[28](#_ednref28) Luca CM Melchionna, “Bias and fairness in artificial intelligence” (New York State Bar Association, June 29, 2023), [https://nysba.org/bias-and-fairness-in-artificial-intelligence/](https://nysba.org/bias-and-fairness-in-artificial-intelligence/).

[29](#_ednref29) Jeff Neal, “The legal profession in 2024: AI,” _Harvard Law Today_ (Harvard University, Harvard Law School, February 14, 2024), [https://hls.harvard.edu/today/harvard-law-expert-explains-how-ai-may-transform-the-legal-profession-in-2024/](https://hls.harvard.edu/today/harvard-law-expert-explains-how-ai-may-transform-the-legal-profession-in-2024/).

[30](#_ednref30) Bernard Marr, “How Generative AI will change the jobs of lawyers,” _Forbes_, March 14, 2024, [https://www.forbes.com/sites/bernardmarr/2024/03/14/how-generative-ai-will-change-the-jobs-of-lawyers/](https://www.forbes.com/sites/bernardmarr/2024/03/14/how-generative-ai-will-change-the-jobs-of-lawyers/).

[31](#_ednref31) Jack Shaw, “5 ways drones are changing insurance claims” (Insurance Thought Leadership, Inc., March 2024), [https://www.insurancethoughtleadership.com/claims/5-ways-drones-are-changing-insurance-claims](https://www.insurancethoughtleadership.com/claims/5-ways-drones-are-changing-insurance-claims).

[32](#_ednref32) Kassandra Jimenez-Sanchez, “McKenzie Intelligence Services launches AI damage classifier to revolutionize insurance assessments,” _Reinsurance News_, June 2024, [https://www.reinsurancene.ws/mckenzie-intelligence-services-launches-ai-damage-classifier-to-revolutionise-insurance-assessments/](https://www.reinsurancene.ws/mckenzie-intelligence-services-launches-ai-damage-classifier-to-revolutionise-insurance-assessments/).

[33](#_ednref33) Chris Raimondo and Vidhya Sekhar, “How insurers can leverage the power of generative AI” (Ernst & Young, August 28, 2023), [https://www.ey.com/en\_us/insights/insurance/how-insurers-can-leverage-the-power-of-generative-ai](https://www.ey.com/en_us/insights/insurance/how-insurers-can-leverage-the-power-of-generative-ai).

[34](#_ednref34) “Artificial intelligence: who are the leaders in smart vehicle damage assessment for the insurance industry?” (Life Insurance International, updated September 2, 2024), [https://www.lifeinsuranceinternational.com/data-insights/innovators-ai-smart-vehicle-damage-assessment-insurance/?cf-view](https://www.lifeinsuranceinternational.com/data-insights/innovators-ai-smart-vehicle-damage-assessment-insurance/?cf-view).

[35](#_ednref35) Amanda Abella, “Robo-advisors and young investors,” _Investopedia_, August 2023, updated November 22, 2024, [https://www.investopedia.com/articles/investing/121615/are-roboadvisors-good-idea-young-investors.asp](https://www.investopedia.com/articles/investing/121615/are-roboadvisors-good-idea-young-investors.asp).

[36](#_ednref36) “Table 3.2. Civilian noninstitutional population by age, sex, race, and ethnicity, 2003, 2013, 2023, and projected 2033 (numbers in thousands),” _Employment Projections_ (U.S. Bureau of Labor Statistics, last modified August 29, 2024), [https://www.bls.gov/emp/tables/civilian-noninstitutional-population.htm](https://www.bls.gov/emp/tables/civilian-noninstitutional-population.htm).

[37](#_ednref37) Shangjun Wang and Sojen Pradhan, “Exploring factors influencing older adults’ willingness to use robo-advisors,” Australasian Conference on Information Systems 2020, Wellington, New Zealand, December 1–4, 2020, p. 8, [https://opus.lib.uts.edu.au/bitstream/10453/145124/2/ACIS%202020\_Adoption%20of%20Robo-Advisors%20by%20older%20adults.pdf](https://opus.lib.uts.edu.au/bitstream/10453/145124/2/ACIS%202020_Adoption%20of%20Robo-Advisors%20by%20older%20adults.pdf).

[38](#_ednref38) Michael Sacchitello and Will Baker, “Investopedia’s 2023 Robo-Advisor Consumer Survey,” _Investopedia_, October 2, 2023, [https://www.investopedia.com/investopedias-2023-robo-advisor-consumer-survey-8303191](https://www.investopedia.com/investopedias-2023-robo-advisor-consumer-survey-8303191).

[39](#_ednref39) Aneta Buchert, “AI in credit: 5 tips for corporate credit analysts” (Global Institute of Credit Professionals, May 15, 2023), [https://gicp.org/news-and-insights/aI-in-credit-5-tips-for-corporate-credit-analysts](https://gicp.org/news-and-insights/aI-in-credit-5-tips-for-corporate-credit-analysts).

[40](#_ednref40) Daniel Cohen, “Retail and algo trading: the new giants of the financial world,” _Forbes_, November 1, 2023, [https://www.forbes.com/councils/forbesfinancecouncil/2023/11/01/retail-and-algo-trading-the-new-giants-of-the-financial-world/](https://www.forbes.com/councils/forbesfinancecouncil/2023/11/01/retail-and-algo-trading-the-new-giants-of-the-financial-world/).

[41](#_ednref41) Ashish Jain and Varun Sharma, “Digital intelligence: how to make your analytics functions more efficient and cost-effective” (PricewaterhouseCoopers, accessed September 10, 2024), [https://www.pwc.com/us/en/industries/financial-services/library/analytics-and-automation.html](https://www.pwc.com/us/en/industries/financial-services/library/analytics-and-automation.html).

[42](#_ednref42) Michael Rustell, “How civil engineers can use generative AI to create value in projects,” _New Civil Engineer_, December 11, 2023, [https://www.newcivilengineer.com/opinion/how-civil-engineers-can-use-generative-ai-to-create-value-in-projects-11-12-2023/](https://www.newcivilengineer.com/opinion/how-civil-engineers-can-use-generative-ai-to-create-value-in-projects-11-12-2023/).

[43](#_ednref43) Nitin Rane, Saurabh Choudhary, and Jayesh Rane, “Transforming the civil engineering sector with generative artificial intelligence, such as ChatGPT or Bard” (SSRN, January 12, 2024), p. 20, [https://papers.ssrn.com/sol3/papers.cfm?abstract\_id=4681718](https://papers.ssrn.com/sol3/papers.cfm?abstract_id=4681718).

[44](#_ednref44) Dee Waddell and Steven Peterson, “How generative AI can transform the aviation industry,” _IBM Think_, December 4, 2023, [https://www.ibm.com/think/topics/generative-ai-for-aviation](https://www.ibm.com/think/topics/generative-ai-for-aviation); and Amina Zaoui, Dieudonne Tchuente, Samuel Fosso Wamba, and Bernard Kamsu-Foguem, “Impact of artificial intelligence on aeronautics: an industry-wide review,” _Journal of Engineering and Technology Management_, vol. 71, January–March 2024, pp. 10–11, [https://www.sciencedirect.com/science/article/pii/S0923474824000055](https://www.sciencedirect.com/science/article/pii/S0923474824000055).

[45](#_ednref45) Christian Langer, Daniel Leblanc, Dave Marcontell, Joe Nutter, Eric Porter, and Joel Thibert, “The generative AI opportunity in airline maintenance” (McKinsey & Company, Aerospace & Defense Practice, April 8, 2024), [https://www.mckinsey.com/industries/aerospace-and-defense/our-insights/the-generative-ai-opportunity-in-airline-maintenance](https://www.mckinsey.com/industries/aerospace-and-defense/our-insights/the-generative-ai-opportunity-in-airline-maintenance).

[46](#_ednref46) Examples of such tools include ChipNeMo and SnapMagic Copilot. See Jialin Song and Jonathan Raiman, “Using Generative AI models in circuit design,” _Nvidia Technical Blog_, September 6, 2024, [https://developer.nvidia.com/blog/using-generative-ai-models-in-circuit-design/](https://developer.nvidia.com/blog/using-generative-ai-models-in-circuit-design/); and Samuel K. Moore, “Nvidia is piloting a Generative AI for its engineers,” _IEEE Spectrum_, October 31, 2023, [https://spectrum.ieee.org/ai-for-engineering](https://spectrum.ieee.org/ai-for-engineering).

[47](#_ednref47) Karan Singh and Umar Shah, “Generative AI for semiconductor design and verification,” _AWS for Industries_ (Amazon Web Services, March 19, 2024), [https://aws.amazon.com/blogs/industries/generative-ai-for-semiconductor-design/](https://aws.amazon.com/blogs/industries/generative-ai-for-semiconductor-design/).

[48](#_ednref48) Doug Burcicki, “Generative design accelerates EV electrical system engineering” (Siemens, February 7, 2020), [https://blogs.sw.siemens.com/ee-systems/2020/02/07/generative-design-accelerates-ev-electrical-system-engineering/](https://blogs.sw.siemens.com/ee-systems/2020/02/07/generative-design-accelerates-ev-electrical-system-engineering/); and Chad Jackson, “Generative engineering: automation for electrical distribution systems” (Siemens, December 9, 2020), [https://blogs.sw.siemens.com/ee-systems/2020/12/09/generative-engineering-automation-for-electrical-distribution-systems/](https://blogs.sw.siemens.com/ee-systems/2020/12/09/generative-engineering-automation-for-electrical-distribution-systems/).

[49](#_ednref49) “Table 1.2. Occupational projections, 2023–33, and worker characteristics, 2023 (numbers in thousands),” _Employment Projections_ (U.S. Bureau of Labor Statistics, last modified August 29, 2024), [https://www.bls.gov/emp/tables/occupational-projections-and-characteristics.htm](https://www.bls.gov/emp/tables/occupational-projections-and-characteristics.htm).

![article image](
/opub/mlr/2025/images/machovec-cover-image.png)

About the Author

[Christine Machovec](/opub/mlr/author/machovec-christine.htm)  
[machovec.christine@bls.gov](mailto:machovec.christine@bls.gov)

Christine Machovec is an economist in the Office of Employment and Unemployment Statistics, U.S. Bureau of Labor Statistics.

[Michael J. Rieley](/opub/mlr/author/rieley-michael-j.htm)  
[rieley.michael@bls.gov](mailto:rieley.michael@bls.gov)

Michael J. Rieley is an economist in the Office of Employment and Unemployment Statistics, U.S. Bureau of Labor Statistics.

[Emily Rolen](/opub/mlr/author/rolen-emily.htm)  
[rolen.emily@bls.gov](mailto:rolen.emily@bls.gov)

Emily Rolen is an economist in the Office of Employment and Unemployment Statistics, U.S. Bureau of Labor Statistics.

Related Content

Related Articles

[Industry and occupational employment projections overview and highlights, 2023–33](https://doi.org/10.21916/mlr.2024.21), _Monthly Labor Review_, November 2024.

[Labor force and macroeconomic projections overview and highlights, 2023–33](https://doi.org/10.21916/mlr.2024.14), _Monthly Labor Review_, August 2024.

[Growth trends for selected occupations considered at risk from automation](https://doi.org/10.21916/mlr.2022.21), _Monthly Labor Review_, July 2022.

Related Subjects

*   [Projections](/opub/mlr/subject/p.htm#projections "Projections")
*   [Technological change](/opub/mlr/subject/t.htm#technological-change "Technological change")
*   [Jobs](/opub/mlr/subject/j.htm#jobs "Jobs")
*   [Statistical programs and methods](/opub/mlr/subject/s.htm#statistical-programs-and-methods "Statistical programs and methods")
*   [Employment](/opub/mlr/subject/e.htm#employment "Employment")
*   [Technology](/opub/mlr/subject/t.htm#technology "Technology")
*   [Occupations](/opub/mlr/subject/o.htm#occupations "Occupations")
*   [Industry and Occupational studies](/opub/mlr/subject/i.htm#industry-and-occupational-studies "Industry and Occupational studies")
*   [Computers](/opub/mlr/subject/c.htm#computers "Computers")

Article Citations

**Crossref**[0](#)

**U.S. Bureau of Labor Statistics** Office of Publications and Special Studies Suitland Federal Center Floor 7 4600 Silver Hill Road Washington, DC 20212-0002
