## Choose a quick start

You can find five separate quick starts for different tasks in Dataiku:

- [Data preparation](https://academy.dataiku.com/data-preparation-quick-start)
- [Machine learning](https://academy.dataiku.com/machine-learning-quick-start)
- [Generative AI](https://academy.dataiku.com/generative-ai-quick-start)
- [MLOps](https://academy.dataiku.com/mlops-quick-start)
- [AI collaboration](https://academy.dataiku.com/ai-collaboration-quick-start)

They are all targeted at first time users. They can be completed using the [free trial](https://www.dataiku.com/product/get-started/) of Dataiku. The estimated time commitment for these tutorials range from 30 minutes to 1 hour.

They can be done independently of each other depending on what interests you most. If you prefer, they can also be done sequentially adding more functionality to the same project.

## The data

The data for these projects come from a [Kaggle dataset](https://www.kaggle.com/datasets/shivamb/real-or-fake-fake-jobposting-prediction) of 18k job descriptions, out of which about 800 are fake.

## The objectives

The objectives for each quick start vary by task:

- Data preparation focuses on building data pipelines.
- Machine learning demonstrates how to train an AutoML model and use it for scoring new data.
- Generative AI introduces the power of large language models (LLMs) with Dataiku.
- MLOps deploys a model as a real-time API endpoint.
- AI collaboration showcases working with colleagues in real-time and using colleagues' work for your own objectives.

## The final product

You can find a completed version of the project (as well as many other exciting projects) in the [Dataiku Gallery](https://gallery.dataiku.com/projects/QS_JOB_POSTINGS/flow/).

## Other learning resources

Depending on your objectives, there are many ways to learn about Dataiku.

- [Dataiku Academy](https://academy.dataiku.com/) for guided learning paths and certifications
- [Dataiku Community](https://community.dataiku.com/) for discussions and user programs
- [Reference Documentation](https://doc.dataiku.com/dss/latest/) for comprehensive specifications of Dataiku
- [Knowledge Base](https://knowledge.dataiku.com/latest/) for articles and tutorials on Dataiku features
- [Developer Guide](https://developer.dataiku.com/latest/) for API reference and other resources for coders