# Manufacturing Sample Project - Data Preparation and Visualization

## Overview
This Sample Project is designed for  **manufacturing domain experts** , such as process and quality engineers, who want to move beyond theoretical learning and begin using Dataiku for real-world manufacturing tasks. It provides a  **practical, hands-on example**  of how Dataiku can be applied to messy, complex datasets often encountered in process and quality control. By reviewing this Sample Project, users will gain insights into  **data cleaning, data preparation, and simple dashboard creation**  tailored to monitor and investigate manufacturing processes. Typical manufacturing data challenges are addressed, such as:
 - converting time-series sensor data from [long to wide format](https://knowledge.dataiku.com/latest/ml-analytics/time-series/concept-data-types-formats.html#time-series-data-formats)
 - unifying different time stamp formats
 - removing outliers
 - combining a dataset of continuous sensor readings to a dataset of discrete production batches.
 
The project bridges the gap between introductory  **[Dataiku Academy](https://academy.dataiku.com/) trainings**  and [ **Solutions** ](https://knowledge.dataiku.com/latest/solutions/manufacturing-energy/index.html), helping manufacturing users build confidence in integrating Dataiku into their daily work. Using this Sample Project as a starting point, users can  **adapt**  the workflows and dashboards  **to their own datasets and processes** , empowering them to generate actionable insights and optimize their processes independently.
Whether you are just starting to explore Dataiku or looking to apply your knowledge to manufacturing-specific challenges, this project will serve as a solid foundation for building effective solutions tailored to your team's needs.

 _Note:_ This Wiki contains a walkthrough of the sample project, explaining each step in the flow in detail. You can also hover your mouse above each step in the flow to see a short description of the step.

## Prerequisites & Technical Requirements
 - Basic knowledge of Dataiku as obtained in the Academy [Core Designer](https://academy.dataiku.com/path/core-designer) learning path.
 - Dataiku Designer (Data, Full, or Advanced Analytics) license
 - Dataiku Version 13+

## Corresponding Quick Start 
 A  **shorter**  and  **more guided version**  of this project is available as a  **Quick Start** tutorial  called "Manufacturing Data Prep and Visualization" in the [Academy](https://academy.dataiku.com/manuf-data-prep-quick-start), or in the [Knowledge Base](https://knowledge.dataiku.com/latest/getting-started/quick-starts/manuf-data-prep/quick-start-index.html).
 
This Sample Project contains all the components found in the Quick Start,  **plus**  the following additional components:
 - minor additional data cleaning and preparation steps
 - demonstration of the **Group by** recipe
 - significantly more data visualization in the form of additional dashboards and charts
 - demonstration of the **Scenarios** functionality for automatically refreshing the project with new data