 _Note:_ Please right-click and open screenshot image in new tab, if it is too small to read in your current browser settings.

# Visualization
A simple [dashboard](https://knowledge.dataiku.com/latest/data-viz/dashboards/concept-dashboards.html) is generated containing several [charts](https://knowledge.dataiku.com/latest/data-viz/charts/concept-charts.html) and metrics, to visualize and analyze the data.

## Page 1, Metrics & Failures
The first page focuses on failure distribution and batch statistics. It includes visualizations showing how failures are distributed across batches and recipes, along with basic statistics. This helps users identify initial patterns or anomalies and gain a better understanding of overall process performance. For example, one can quickly recognize that all failures occur for a small number of recipes and on only one of the machines. This can provide a basis for more in-depth root cause analysis as a next step. 
![dashboard_metrics_and_failures.png](BFk7xaEL7avo)

## Page 2, Sensor Readings:
The second page displays the sensor readings, grouped by sensor type. Users can analyze this data to review the  process conditions. Outliers not corrected during data cleaning can be visually identified. A timestamp filter can be applied to focus on specific time frames, making it easier to explore the data in detail.
![dashboard_sensor_readings.png](JeeSKCN8rF1n)

## Page 3, Sensor Value Distribution:
The third page shows box-plots of the measurements from each sensor for each machine, split by failure status. The charts can be used to visually assess whether failed batches have a different distribution for certain sensors, compared to the successful batches. Also the machines can be compared in a similar manner. The charts could also be used to confirm whether the machines are operating in the correct ranges. 
For example, one can see that the average Concentration 2 value is significantly lower in the failed batches of machine 0. A similar observation can be made for all three temperature readings. 
![dashboard_sensor_value_distributions.png](UZrym4oxMMQB)

## Page 4, Correlations:
A correlation matrix can be used to visually investigate correlations between selected sensor readings, helping the viewer better understand the dynamics within the process. Most importantly, the numeric failure indicator is included in the analysis, in order to identify which process parameters or properties have a strong correlation to whether a batch was successfully cleaned or not.
![dashboard_correlations.png](anpnEVRiZo1G)

From this analysis, we can see that batch duration has quite a strong negative correlation to failure rate, indicating that shorter batches tend to fail more often than longer batches. We also see that as identified in the box plot analysis, concentration 2 and temperature 1 and 3 have a strong correlation to failure rate. We are able to sharpen the insight from the previous page though, by obtaining the actual correlation values. 
![dashboard_correlations_insight.png](yyeNGXlvVytR)

The correlation matrix is quickly built using the statistics tab within the final dataset at the end of the flow:
![correlation_matrix.gif](RRmcRMgCFlmj)