 _Note:_ Please right-click and open screenshot image in new tab, if it is too small to read in your current browser settings.

# Automation
[Automation scenarios](https://knowledge.dataiku.com/latest/automation/scenarios/concept-scenarios.html) are a set of actions that are scheduled to run when certain conditions are satisfied. They are most useful when automating various kinds of tasks when a project is in production. In this Sample Project, a scenario is included, which updates the dashboards automatically, when new data is input into the flow.

The [Update Dashboards with New Data](scenario:DASHBOARDUPDATE) scenario demonstrates how to automate a flow with minimal configuration. It includes a single step of type Build/Train, where the final dataset in the flow is selected for processing:  
![automation_overview.png](1ptA4eT6dRPK)

For more details on the Build/Train step, refer to the [Dataiku documentation](https://doc.dataiku.com/dss/latest/scenarios/steps.html#build-train).

To automate this process further, a trigger is added to run the scenario automatically whenever new data is loaded, as is often the case when building an analysis that outputs dashboards with metrics and sensor readings, as is the case in this Sample Project. This is achieved using a "Trigger on dataset change" type, though various other triggers are available.  
Make sure to enable the Auto-triggers option to activate this functionality!  
![automation_trigger.png](7rgdkX1lI38F)

You can test this scenario with the provided dataset, which will trigger the scenario and update the dashboard:  
[new_sensor_data.csv]{new_sensor_data.csv}(jSVMAY3rPRww)

This dataset contains readings from the same sensors as before, but for a different time period. The new sensor readings are automatically appended to the old ones. The batch dataset does not need to be updated because it already contains data on batches for all time periods.

To use this new dataset, just follow these steps:
- From the Flow, open the sensor_data dataset and go to Settings
- Drag & drop the new file
- Wait for the scenario to auto-trigger with the New sensor data trigger already set
- After the flow has run, the dashboards will be updated to reflect the new data. To reflect the extended timeframe of sensor readings, the timeframe filter in the dashboard needs to be reset to also include the new time period (one day more).
![automation_new_dataset.gif](9YnM1QkDK0pw)