import dataiku
from dataiku.llm.agent_tools import BaseAgentTool

from agentic_insights.backend.agentic_insights_toolkit.dku_utils.object import get_or_create_flow_zone
from agentic_insights.backend.agentic_insights_toolkit.adm.common import get_analysis_zone_default_metadata, generate_analysis_session_id

project = dataiku.api_client().get_default_project()
    

class MyAgentTool(BaseAgentTool):
    """An empty interface for a code-based agent tool"""

    def __init__(self):
        pass

    def get_descriptor(self, tool):
        """
        Returns the descriptor of the tool, as a dict containing:
           - description (str)
           - inputSchema (dict, a JSON Schema representation)
        """
        return {
            "description": "Initialize a new analysis session by setting up all required resources and configuration needed to start the analysis properly.",
             "inputSchema" : {
                "$id": "",
                "title": "",
                "type": "object",
                "properties": {
                    "analysis_session_id": {
                        "type": "string",
                        "description": (
                            "Optional analysis session identifier. "
                            "If not provided, a unique one will be generated automatically."
                        )
                    }
                },
                "required": []
            }
        }


    def invoke(self, input, trace):
        """
        Invokes the tool.

        The arguments of the tool invocation are in input["input"], a dict
        """
        tool_input = input.get("input", {}) or {}

        analysis_session_id = tool_input.get("analysis_session_id")
        if not analysis_session_id:
            analysis_session_id = generate_analysis_session_id()
        
        # Create dedicated flow zone (whose name = Analysis ID)
        default_zone_metadata = get_analysis_zone_default_metadata()
        tags, color = default_zone_metadata["tags"], default_zone_metadata["color"]
        zone = get_or_create_flow_zone(flow_zone_name = analysis_session_id, create_if_not_exist = True, tags = tags, color = color)
        
        output = (
        f"==> Unique Analysis Session ID (unique across all analysis): '{analysis_session_id}'\n"
        f"==> Analysis session environment initialized successfully."
        )
        return {
            "output": output,
            "sources": [],
        }
