import dataiku
from dataiku.llm.agent_tools import BaseAgentTool

from agentic_insights.backend.agentic_insights_toolkit.agent.report_utils import get_report_script_report_data_template, generate_full_report

class MyAgentTool(BaseAgentTool):
    """An empty interface for a code-based agent tool"""

    def __init__(self):
        pass

    def get_descriptor(self, tool):
        """
        Returns the descriptor of the tool, as a dict containing:
           - description (str)
           - inputSchema (dict, a JSON Schema representation)
        """
        return {
            "description": "Retrieve the template of a specific part of the full html report that will be completed later by the agent by real data",
            "inputSchema" : {
                "$id": "get_report_script_report_data_template",
                "title": "Report Script Report Data Template Retriever",
                "type": "object",
                "properties": {},
                "required": []
            }
        }


    def invoke(self, input, trace):
        """
        Invokes the tool.

        The arguments of the tool invocation are in input["input"], a dict
        """

        content = get_report_script_report_data_template()
        
        return {
            "output": content,
            "sources": []
        }
