import dataiku
from dataiku.llm.agent_tools import BaseAgentTool
from agentic_insights.backend.agentic_insights_toolkit.analytic import analytic_functions

class MyAgentTool(BaseAgentTool):
    """An empty interface for a code-based agent tool"""

    def __init__(self):
        pass

    def get_descriptor(self, tool):
        """
        Returns the descriptor of the tool, as a dict containing:
           - description (str)
           - inputSchema (dict, a JSON Schema representation)
        """
        return {
            "description": "Retrieve the input schema of the given analytic tools.",
            "inputSchema" : {
                "$id": "analytic_tool_arg_retriever",
                "title": "Analytic Tool Arg Retriever",
                "type": "object",
                "properties": {
                    "analytic_tool_ids": {
                        "type": "array",
                        "items": {"type": "string"},
                        "description": "List of analytic tool IDs to retrieve."
                    }
                },
                "required": ["analytic_tool_ids"]
            }
        }


    def invoke(self, input, trace):
        """
        Invokes the tool.

        The arguments of the tool invocation are in input["input"], a dict
        """
        analytic_tool_ids = input["input"]['analytic_tool_ids']
        
        sections = []
        for tool_id in analytic_tool_ids:
            func = getattr(analytic_functions, tool_id, None)
            if func is None:
                sections.append(f"### {tool_id}\n[Tool not found]")
            else:
                docstring = func.__doc__.strip() if func.__doc__ else "No docstring provided."
                sections.append(f"### {tool_id}\n{docstring}")

        output = "\n\n".join(sections)

        return {
            "output": output,
            "sources": [],
        }
