import dataiku
from dataiku.llm.agent_tools import BaseAgentTool

from agentic_insights.backend.agentic_insights_toolkit.utils.analysis_session import get_available_analytic_tools
from agentic_insights.backend.agentic_insights_toolkit.utils.common import convert_df_to_str

class MyAgentTool(BaseAgentTool):
    """An empty interface for a code-based agent tool"""

    def __init__(self):
        pass

    def get_descriptor(self, tool):
        """
        Returns the descriptor of the tool, as a dict containing:
           - description (str)
           - inputSchema (dict, a JSON Schema representation)
        """
        return {
            "description": "Retrieve available active analytic tools with their descriptions.",
            "inputSchema" : {
                "$id": "analytic_tools_explorer",
                "title": "Analytic Tools Explorer",
                "type": "object",
                "properties": {},
                "required": []
            }
        }


    def invoke(self, input, trace):
        """
        Invokes the tool.

        The arguments of the tool invocation are in input["input"], a dict
        """
        
        df_tools = get_available_analytic_tools()

        if df_tools.empty:
            output = "No Analytic Tools"
        
        else:
            df_tools_str = convert_df_to_str(df_tools)
            output = df_tools_str
        
        return {
            "output": output,
            "sources": [{
                "toolCallDescription": "Retrieved active analytic tools",
                "items": []
            }]
        }
