FULL_REPORT_TEMPLATE_WITH_PLACEHOLDERS = """
<!doctype html>
<html lang="en">

<!-- REPORT HEADER (Static) -->

{REPORT_HEADER}

<!-- REPORT BODY (Static) -->

{REPORT_BODY}

<script>

// ============================================================
// REPORT DATA (Dynamic)
// ============================================================

{report_data}

// ============================================================
// UTILITIES (Static)
// ============================================================

{REPORT_SCRIPT_UTILITIES}

// ============================================================
// RENDER KPIs BY ANALYSIS TYPE FUNCTIONS (Static)
// ============================================================

{REPORT_SCRIPT_RENDER_KPIS_BY_ANALYSIS_TYPE}

// ============================================================
// RENDER META + OVERALL (Static)
// ============================================================

{REPORT_SCRIPT_RENDER_META_AND_OVERALL}

// ============================================================
// RENDER ANALYSIS ZONES (Static)
// ============================================================

{REPORT_SCRIPT_RENDER_ANALYSIS_ZONES}

// ============================================================
// UTILITY FUNCTIONS FOR FORMATTING (Static)
// ============================================================

{REPORT_SCRIPT_UTILITY_FUNCTIONS_FOR_FORMATTING}

// ============================================================
// CHART HELPERS (Static)
// ============================================================

{REPORT_SCRIPT_CHART_HELPERS}

// ============================================================
// BUILD ANALYSIS ZONE CHARTS (Static)
// ============================================================

{REPORT_SCRIPT_BUILD_ANALYSIS_ZONE_CHARTS}

</script>

</body>
</html>
"""



REPORT_HEADER = """
<head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width,initial-scale=1" />
    <title>Agentic Insights — Complete Analysis Report</title>

    <!-- Chart.js (quick interactive visuals) -->
    <script src="https://cdn.jsdelivr.net/npm/chart.js@4.4.3"></script>

    <style>
    :root{
        --bg:#0b1020;
        --panel:#0f1730;
        --card:#111a33;
        --text:#e9edf7;
        --muted:#b9c2da;
        --border:rgba(255,255,255,.09);
        --shadow:0 14px 40px rgba(0,0,0,.35);
        --radius:18px;
        --mono: ui-monospace, SFMono-Regular, Menlo, Monaco, Consolas, "Liberation Mono", "Courier New", monospace;
        --sans: ui-sans-serif, system-ui, -apple-system, Segoe UI, Roboto, Helvetica, Arial, "Apple Color Emoji","Segoe UI Emoji";
    }
    *{ box-sizing:border-box; }
    body{
        margin:0;
        font-family:var(--sans);
        color:var(--text);
        background:
        radial-gradient(1200px 700px at 15% 10%, rgba(122,162,255,.18), transparent 60%),
        radial-gradient(1000px 600px at 90% 20%, rgba(99,214,163,.12), transparent 55%),
        var(--bg);
        line-height:1.35;
    }
    .wrap{ max-width:1180px; margin:0 auto; padding:28px 18px 60px; }
    header{
        border:1px solid var(--border);
        border-radius:var(--radius);
        background: linear-gradient(180deg, rgba(255,255,255,.06), rgba(255,255,255,.02));
        box-shadow:var(--shadow);
        padding:20px;
    }
    h1{ margin:0; font-size:22px; letter-spacing:.2px; }
    .sub{ margin-top:8px; color:var(--muted); font-size:13px; }
    .meta{
        margin-top:12px;
        display:flex; flex-wrap:wrap; gap:10px;
    }
    .pill{
        border:1px solid var(--border);
        background: rgba(255,255,255,.03);
        border-radius:999px;
        padding:7px 10px;
        font-size:12px;
        color:var(--muted);
        white-space:nowrap;
    }
    .pill b{ color:var(--text); font-weight:650; }

    nav{
        margin-top:14px;
        display:flex; flex-wrap:wrap; gap:10px;
    }
    nav a{
        border:1px solid var(--border);
        background: rgba(255,255,255,.03);
        border-radius:999px;
        padding:9px 12px;
        color:var(--text);
        font-size:13px;
        text-decoration:none;
    }
    nav a:hover{ border-color: rgba(122,162,255,.45); }

    section{
        margin-top:18px;
        border:1px solid var(--border);
        border-radius:var(--radius);
        background: rgba(255,255,255,.03);
        box-shadow:var(--shadow);
        overflow:hidden;
    }
    .section-hd{
        padding:14px 16px;
        border-bottom:1px solid var(--border);
        background: linear-gradient(180deg, rgba(255,255,255,.06), rgba(255,255,255,.02));
        display:flex; align-items:center; justify-content:space-between; gap:10px; flex-wrap:wrap;
    }
    .section-hd h2{ margin:0; font-size:15px; }
    .badge{
        font-size:12px;
        color:var(--muted);
        border:1px solid var(--border);
        border-radius:999px;
        padding:6px 10px;
        background: rgba(0,0,0,.18);
    }
    .content{ padding:16px; }

    .grid{
        display:grid;
        grid-template-columns: 1.05fr .95fr;
        gap:12px;
    }
    @media (max-width: 980px){
        .grid{ grid-template-columns: 1fr; }
    }

    .card{
        border:1px solid var(--border);
        background: linear-gradient(180deg, rgba(255,255,255,.04), rgba(0,0,0,.10));
        border-radius:16px;
        padding:14px;
    }
    .card h3{ margin:0 0 8px; font-size:13px; }
    .muted{ color:var(--muted); }

    .kpis{
        display:grid;
        grid-template-columns: repeat(4, 1fr);
        gap:10px;
        margin-top:0;
    }
    @media (max-width: 980px){ .kpis{ grid-template-columns: repeat(2, 1fr); } }
    .kpi{
        border:1px solid var(--border);
        background: rgba(0,0,0,.18);
        border-radius:16px;
        padding:12px;
    }
    .kpi .label{ font-size:12px; color:var(--muted); }
    .kpi .value{ margin-top:6px; font-size:16px; font-weight:700; letter-spacing:.2px; }

    .keyfindings{
        margin:0;
        padding-left:18px;
        color:var(--muted);
        font-size:13px;
    }
    .keyfindings li{ margin:6px 0; }

    .actions{
        margin-top:10px;
        border-top:1px dashed var(--border);
        padding-top:10px;
        color:var(--muted);
        font-size:13px;
    }
    .actions b{ color:var(--text); }

    .chart-box{
        border:1px solid var(--border);
        background: rgba(0,0,0,.18);
        border-radius:16px;
        padding:12px;
    }
    .chart-title{
        display:flex; align-items:center; justify-content:space-between; gap:10px;
        margin-bottom:10px;
    }
    .chart-title .t{ font-size:13px; font-weight:650; }
    .chart-title .s{ font-size:12px; color:var(--muted); font-family:var(--mono); }
    .chart-box canvas{ 
      width:100% !important; 
      height:auto !important; 
      max-height:400px;
      aspect-ratio: 16 / 9;
    }
    /* Exception for boxplots which have fixed dimensions */
    .single-boxplot-canvas {
      width: 100% !important;
      height: 300px !important;
    }

    table{
        width:100%;
        border-collapse:collapse;
        overflow:hidden;
        border-radius:16px;
        margin-top:12px;
        border:1px solid var(--border);
        background: rgba(0,0,0,.18);
    }
    th, td{
        padding:10px;
        border-bottom:1px solid var(--border);
        text-align:left;
        font-size:13px;
        vertical-align:top;
    }
    th{ color:var(--muted); background: rgba(255,255,255,.03); font-weight:650; }
    tr:last-child td{ border-bottom:none; }

    .tag{
        display:inline-block;
        padding:4px 8px;
        border:1px solid var(--border);
        border-radius:999px;
        font-size:12px;
        color:var(--muted);
        background: rgba(255,255,255,.03);
        margin-right:6px;
        margin-top:6px;
    }

    footer{
        margin-top:16px;
        color:var(--muted);
        font-size:12px;
        text-align:center;
        opacity:.9;
    }
    </style>
</head>
"""

REPORT_BODY = """
<body>
  <div class="wrap">

    <!-- HEADER -->
    <header>
      <h1>Agentic Insights — Complete Analysis Report</h1>
      <div class="sub">Only the essential findings, evidence visuals, and actionable interpretations per analysis axis.</div>

      <div class="meta">
        <div class="pill"><b>Dataset(s)</b>: <span id="meta-dataset">[DATASET_NAME]</span></div>
        <div class="pill"><b>Generated</b>: <span id="meta-generated"></span></div>
      </div>

      <nav>
        <!-- Navigation links - Add/remove sections as needed - Keep only the sections that are relevant to the analysis -->
        <a href="#" onclick="event.preventDefault(); document.getElementById('clusters')?.scrollIntoView({behavior: 'smooth', block: 'start'}); return false;">Clustering</a>
        <a href="#" onclick="event.preventDefault(); document.getElementById('outliers')?.scrollIntoView({behavior: 'smooth', block: 'start'}); return false;">Outlier Detection</a>        
        <a href="#" onclick="event.preventDefault(); document.getElementById('forecast')?.scrollIntoView({behavior: 'smooth', block: 'start'}); return false;">Time Series Forecasting</a>
        <a href="#" onclick="event.preventDefault(); document.getElementById('rootcause')?.scrollIntoView({behavior: 'smooth', block: 'start'}); return false;">Root Cause Analysis</a>
      </nav>
    </header>

    <!-- OVERALL -->
    <section id="overall">
      <div class="section-hd">
        <h2>Overall Findings</h2>
        <span class="badge">Executive snapshot</span>
      </div>
      <div class="content">
        <!-- Key Findings and Actions -->
        <div class="card" style="margin-bottom:18px;">
          <h3>Key Findings</h3>
          <ul class="keyfindings" id="overall-findings"></ul>

          <div class="actions" id="overall-actions">
            <b>Recommended Actions</b>
            <ul class="keyfindings" id="overall-actions-list"></ul>
          </div>

          <div class="actions" id="overall-technical-summary" style="margin-top:18px; border-top:1px dashed var(--border); padding-top:10px;">
            <b>Technical Summary</b>
            <ul class="keyfindings" id="overall-technical-summary-list"></ul>
          </div>
        </div>

        <!-- KPIs by Analysis Type - Separated sections -->
        
        <!-- Clustering KPIs -->
        <div id="kpis-clustering-section" style="display:none; margin-top:18px;">
            <h3 style="font-size:14px; margin-bottom:10px; color:var(--muted);">Clustering Analysis</h3>
            <div class="kpis" id="kpis-clustering"></div>
        </div>

        <!-- Outlier Detection KPIs -->
        <div id="kpis-outliers-section" style="display:none; margin-top:18px;">
          <h3 style="font-size:14px; margin-bottom:10px; color:var(--muted);">Outliers Analysis</h3>
          <div class="kpis" id="kpis-outliers"></div>
        </div>


        <!-- Time Series Forecasting KPIs -->
        <div id="kpis-forecasting-section" style="display:none; margin-top:18px;">
          <h3 style="font-size:14px; margin-bottom:10px; color:var(--muted);">Forecasting Analysis</h3>
          <div class="kpis" id="kpis-forecasting"></div>
        </div>

        <!-- Root Cause KPIs -->
        <div id="kpis-rootcause-section" style="display:none; margin-top:18px;">
          <h3 style="font-size:14px; margin-bottom:10px; color:var(--muted);">Root Cause Analysis</h3>
          <div class="kpis" id="kpis-rootcause"></div>
        </div>

      </div>
    </section>

    <!-- CLUSTERING -->
    <section id="clusters">
        <div class="section-hd">
            <h2>Clustering & Segmentation — Key Findings</h2>
            <span class="badge">Distribution • Feature Importance • Quality & Robustness</span>
        </div>
        <div class="content">
            <div class="grid">
            <div class="card">
                <h3>Key Findings</h3>
                <ul class="keyfindings" id="clusters-findings"></ul>

                <div style="margin-top:10px;">
                <span class="tag" id="clusters-k">k = [K] clusters</span>
                <span class="tag" id="clusters-sil">Silhouette: [SILHOUETTE]</span>
                <span class="tag" id="clusters-note">Separation: [SEPARATION]</span>
                </div>

                <div class="actions">
                <b>Interpretation & Actions</b>
                <div class="muted" id="clusters-interpretation"></div>
                </div>
            </div>

            <div class="chart-box">
                <div class="chart-title">
                <div class="t">Cluster Distribution</div>
                <div class="s">bar</div>
                </div>
                <canvas id="chart-cluster-distribution"></canvas>
            </div>
            </div>

            <div class="grid" style="margin-top:12px;">
            <div class="chart-box">
                <div class="chart-title">
                <div class="t">Feature Importance</div>
                <div class="s">bar</div>
                </div>
                <canvas id="chart-feature-importance"></canvas>
            </div>

            <div class="chart-box">
                <div class="chart-title">
                <div class="t">Clustering Quality & Robustness</div>
                <div class="s">dual y-axis</div>
                </div>
                <canvas id="chart-quality-robustness"></canvas>
            </div>
            </div>

            <!-- Data Context Section -->
            <div class="card" style="margin-top:18px; display:none;" id="clusters-data-context-section">
            <h3>Analysis Context</h3>
            <div class="muted" id="clusters-data-context-content" style="font-size: 12px;"></div>
            </div>
        </div>
    </section>

    <!-- OUTLIER DETECTION -->
    <section id="outliers">
        <div class="section-hd">
          <h2>Outlier Detection — Key Findings</h2>
          <span class="badge">Distribution • Patterns • Impact Analysis</span>
        </div>
        <div class="content">
          <div class="grid">
            <div class="card">
              <h3>Key Findings</h3>
              <ul class="keyfindings" id="outliers-findings"></ul>
  
              <div style="margin-top:10px;">
                <span class="tag" id="outliers-rate">Outliers: [RATE]%</span>
                <span class="tag" id="outliers-count">Count: [COUNT]</span>
                <span class="tag" id="outliers-impact">Impact: [IMPACT]</span>
              </div>
  
              <div class="actions">
                <b>Interpretation & Actions</b>
                <div class="muted" id="outliers-interpretation"></div>
              </div>
            </div>
  
            <div class="chart-box">
              <div class="chart-title">
                <div class="t">Outliers by Column</div>
                <div class="s">bar</div>
              </div>
              <canvas id="chart-outliers-by-column"></canvas>
            </div>
          </div>
  
          <div class="grid" style="margin-top:12px;">
            <div class="chart-box" style="grid-column: 1 / -1;">
              <div class="chart-title">
                <div class="t">Distribution Statistics (Numeric Columns)</div>
                <div class="s">boxplot</div>
              </div>
              <div id="boxplots-container" style="display: grid; grid-template-columns: repeat(auto-fit, minmax(280px, 1fr)); gap: 16px; margin-top: 12px;"></div>
            </div>
  
            <div class="card">
              <h3>Top Outliers by Column (Categorical)</h3>
              <table id="table-top-outliers">
                <thead>
                  <tr>
                    <th>Column</th>
                    <th>Top Outlier Values</th>
                  </tr>
                </thead>
                <tbody id="table-top-outliers-body"></tbody>
              </table>
            </div>
          </div>
  
          <!-- Data Context Section -->
          <div class="card" style="margin-top:18px; display:none;" id="outliers-data-context-section">
            <h3>Analysis Context</h3>
            <div class="muted" id="outliers-data-context-content" style="font-size: 12px;"></div>
          </div>
        </div>
    </section>

    <!-- TIME SERIES FORECASTING -->
    <section id="forecast">
      <div class="section-hd">
        <h2>Time Series Forecasting — Key Findings</h2>
        <span class="badge">Historical • Forecast • Confidence Intervals</span>
      </div>
      <div class="content">
        <div class="grid">
          <div class="card">
            <h3>Key Findings</h3>
            <ul class="keyfindings" id="forecast-findings"></ul>

            <div style="margin-top:10px;">
              <span class="tag" id="forecast-horizon">Horizon: [HORIZON]</span>
              <span class="tag" id="forecast-trend">Trend: [TREND]</span>
              <span class="tag" id="forecast-accuracy">Accuracy: [ACCURACY]</span>
            </div>

            <div class="actions">
              <b>Interpretation & Actions</b>
              <div class="muted" id="forecast-interpretation"></div>
            </div>
          </div>

          <div class="chart-box">
            <div class="chart-title">
              <div class="t">Historical & Forecast</div>
              <div class="s">line with intervals</div>
            </div>
            <canvas id="chart-forecast"></canvas>
          </div>
        </div>

        <!-- Data Context Section -->
        <div class="card" style="margin-top:18px; display:none;" id="forecast-data-context-section">
          <h3>Analysis Context</h3>
          <div class="muted" id="forecast-data-context-content" style="font-size: 12px;"></div>
        </div>
      </div>
    </section>

    <!-- ROOT CAUSE ANALYSIS -->
    <section id="rootcause">
      <div class="section-hd">
        <h2>Root Cause Analysis — Key Findings</h2>
        <span class="badge">Root Causes • Feature Importance • Correlations • Categorical Impacts</span>
      </div>
      <div class="content">
        <div class="grid">
          <div class="card">
            <h3>Key Findings</h3>
            <ul class="keyfindings" id="rootcause-findings"></ul>

            <div style="margin-top:10px;">
              <span class="tag" id="rootcause-target">Target: [TARGET]</span>
              <span class="tag" id="rootcause-top">Top driver: [TOP_DRIVER]</span>
              <span class="tag" id="rootcause-confidence">Confidence: [CONFIDENCE]</span>
            </div>

            <div class="actions">
              <b>Interpretation & Actions</b>
              <div class="muted" id="rootcause-interpretation"></div>
            </div>
          </div>

          <div class="chart-box">
            <div class="chart-title">
              <div class="t">Feature Importance <span id="root-causes-kpi" style="color: var(--muted); font-weight: normal; font-size: 0.9em;"></span></div>
              <div class="s">bar</div>
            </div>
            <canvas id="chart-root-causes"></canvas>
            <div id="legend-root-causes" style="margin-top: 10px; display: flex; gap: 20px; justify-content: center; flex-wrap: wrap;"></div>
          </div>
        </div>

        <div class="grid" style="margin-top:12px;">
          <div class="chart-box">
            <div class="chart-title">
              <div class="t">Top Correlations</div>
              <div class="s">bar</div>
            </div>
            <canvas id="chart-correlations"></canvas>
          </div>

          <div class="chart-box">
            <div class="chart-title">
              <div class="t">Categorical Impacts (F-ratio)</div>
              <div class="s">bar</div>
            </div>
            <canvas id="chart-categorical-impacts"></canvas>
          </div>
        </div>

        <div class="grid" style="margin-top:12px;">
          <div class="card">
            <h3>Technical Definitions</h3>
            <div class="muted" style="font-size: 12px; line-height: 1.6;">
              <div style="margin-bottom: 12px;">
                <b>F-ratio:</b> Measures the variance between categories relative to variance within categories. Higher values indicate stronger categorical impact on the target variable. Values > 1 suggest meaningful differences between categories.
              </div>
              <div style="margin-bottom: 12px;">
                <b>Correlation:</b> Measures the linear relationship strength between numeric features and the target. Range: -1 (perfect negative) to +1 (perfect positive). Values close to 0 indicate weak relationship.
              </div>
              <div style="margin-bottom: 12px;">
                <b>Significance:</b> Statistical significance (p-value < 0.05) indicates the relationship is unlikely due to chance. Non-significant correlations may still be informative but require caution.
              </div>
              <div style="margin-bottom: 12px;">
                <b>Importance Score:</b> Combined measure of feature impact, incorporating correlation strength, statistical significance, and categorical variance. Higher scores indicate stronger drivers of the target variable.
              </div>
              <div>
                <b>Confidence Level:</b> Assessment of reliability: High (strong evidence), Medium (moderate evidence), Low (weak evidence). Based on statistical strength and consistency of findings.
              </div>
            </div>
          </div>

          <!-- Data Context Section -->
          <div class="card" style="display:none;" id="rootcause-data-context-section">
            <h3>Analysis Context</h3>
            <div class="muted" id="rootcause-data-context-content" style="font-size: 12px;"></div>
          </div>
        </div>
      </div>
    </section>

    <footer>Report Generated By <span style="color: #D66F9E;">Dataiku Agentic Insights Solution</span></footer>
</div>
"""


REPORT_SCRIPT_UTILITIES = """
    function setText(id, text){ const el=document.getElementById(id); if(el) el.textContent = text; }
    function setHTML(id, html){ const el=document.getElementById(id); if(el) el.innerHTML = html; }
    function ulFromArray(arr){
      return (arr || []).map(x => `<li>${x}</li>`).join("");
    }
"""

REPORT_SCRIPT_RENDER_KPIS_BY_ANALYSIS_TYPE = """
    function renderClusteringKPIs() {
      const container = document.getElementById("kpis-clustering");
      const section = document.getElementById("kpis-clustering-section");
      const clusteringKPIs = [];
      
      if (report_data.clustering && report_data.clustering.k !== undefined && report_data.clustering.k > 0) {
        clusteringKPIs.push({
          label: "Number of Clusters",
          value: report_data.clustering.k.toString()
        });
        if (report_data.clustering.silhouette !== undefined && report_data.clustering.silhouette > 0) {
          clusteringKPIs.push({
            label: "Silhouette Score",
            value: report_data.clustering.silhouette.toFixed(3)
          });
        }
        if (report_data.clustering.davies_bouldin !== undefined && report_data.clustering.davies_bouldin > 0) {
          clusteringKPIs.push({
            label: "Davies-Bouldin",
            value: report_data.clustering.davies_bouldin.toFixed(3)
          });
        }
      }
      
      if (container && section && clusteringKPIs.length > 0) {
        container.innerHTML = clusteringKPIs.map(kpi => {
          return `<div class="kpi"><div class="label">${kpi.label}</div><div class="value">${kpi.value}</div></div>`;
        }).join("");
        section.style.display = "block";
      }
    }

    function renderOutliersKPIs() {
      const container = document.getElementById("kpis-outliers");
      const section = document.getElementById("kpis-outliers-section");
      const outliersKPIs = [];
      
      if (report_data.outliers) {
        if (report_data.outliers.outlier_summary) {
          const summary = report_data.outliers.outlier_summary;
          if (summary.outlier_rate !== undefined && summary.outlier_rate > 0) {
            outliersKPIs.push({
              label: "Outlier Rate",
              value: `${(summary.outlier_rate * 100).toFixed(1)}%`
            });
          }
          if (summary.outlier_count !== undefined && summary.outlier_count > 0) {
            outliersKPIs.push({
              label: "Outlier Count",
              value: summary.outlier_count.toString()
            });
          }
          if (summary.impact_label && summary.impact_label !== "[Low|Medium|High]") {
            outliersKPIs.push({
              label: "Impact",
              value: summary.impact_label
            });
          }
        }
        if (report_data.outliers.outliers_by_column && Object.keys(report_data.outliers.outliers_by_column).length > 0) {
          const topCol = Object.entries(report_data.outliers.outliers_by_column)
            .sort((a, b) => b[1].outlier_count - a[1].outlier_count)[0];
          if (topCol) {
            outliersKPIs.push({
              label: "Top Affected Column",
              value: topCol[0]
            });
          }
        }
      }
      
      if (container && section && outliersKPIs.length > 0) {
        container.innerHTML = outliersKPIs.map(kpi => {
          return `<div class="kpi"><div class="label">${kpi.label}</div><div class="value">${kpi.value}</div></div>`;
        }).join("");
        section.style.display = "block";
      }
    }

    function renderForecastingKPIs() {
      const container = document.getElementById("kpis-forecasting");
      const section = document.getElementById("kpis-forecasting-section");
      const forecastingKPIs = [];
      
      if (report_data.forecasting) {
        if (report_data.forecasting.forecast_horizon !== undefined && report_data.forecasting.forecast_horizon > 0) {
          const freq = report_data.forecasting.aggregation_freq || "periods";
          const freqLabel = freq === "D" ? "days" : freq === "W" ? "weeks" : freq === "M" ? "months" : freq === "Q" ? "quarters" : freq === "Y" ? "years" : "periods";
          forecastingKPIs.push({
            label: "Forecast Horizon",
            value: `${report_data.forecasting.forecast_horizon} ${freqLabel}`
          });
        }
        if (report_data.forecasting.forecast_accuracy) {
          if (report_data.forecasting.forecast_accuracy.mae !== undefined) {
            forecastingKPIs.push({
              label: "MAE",
              value: report_data.forecasting.forecast_accuracy.mae.toFixed(2)
            });
          }
          if (report_data.forecasting.forecast_accuracy.rmse !== undefined) {
            forecastingKPIs.push({
              label: "RMSE",
              value: report_data.forecasting.forecast_accuracy.rmse.toFixed(2)
            });
          }
          if (report_data.forecasting.forecast_accuracy.mape !== undefined) {
            forecastingKPIs.push({
              label: "MAPE",
              value: `${report_data.forecasting.forecast_accuracy.mape.toFixed(1)}%`
            });
          }
        }
      }
      
      if (container && section && forecastingKPIs.length > 0) {
        container.innerHTML = forecastingKPIs.map(kpi => {
          return `<div class="kpi"><div class="label">${kpi.label}</div><div class="value">${kpi.value}</div></div>`;
        }).join("");
        section.style.display = "block";
      }
    }

    function renderRootCauseKPIs() {
      const container = document.getElementById("kpis-rootcause");
      const section = document.getElementById("kpis-rootcause-section");
      const rootcauseKPIs = [];
      
      if (report_data.rootcause) {
        if (report_data.rootcause.target_column && report_data.rootcause.target_column !== "[TARGET_COLUMN]") {
          rootcauseKPIs.push({
            label: "Target Variable",
            value: report_data.rootcause.target_column
          });
        }
        if (report_data.rootcause.root_causes && report_data.rootcause.root_causes.length > 0) {
          const topCause = report_data.rootcause.root_causes[0];
          rootcauseKPIs.push({
            label: "Top Driver",
            value: topCause.feature
          });
          rootcauseKPIs.push({
            label: "Root Causes Identified",
            value: report_data.rootcause.root_causes.length.toString()
          });
        }
        if (report_data.rootcause.correlations && report_data.rootcause.correlations.top_correlated && report_data.rootcause.correlations.top_correlated.length > 0) {
          const topCorr = report_data.rootcause.correlations.top_correlated[0];
          rootcauseKPIs.push({
            label: "Strongest Correlation",
            value: `${(topCorr.pearson_corr * 100).toFixed(1)}%`
          });
        }
      }
      
      if (container && section && rootcauseKPIs.length > 0) {
        container.innerHTML = rootcauseKPIs.map(kpi => {
          return `<div class="kpi"><div class="label">${kpi.label}</div><div class="value">${kpi.value}</div></div>`;
        }).join("");
        section.style.display = "block";
      }
    }
"""

REPORT_SCRIPT_RENDER_META_AND_OVERALL = """
    setText("meta-dataset", report_data.meta.dataset_name);
    setText("meta-generated", new Date().toLocaleString("en-GB"));

    // Hide sections and navigation links if data is completely missing
    function hideSectionIfEmpty(sectionId, navLinkSelector, hasData) {
      const section = document.getElementById(sectionId);
      const navLink = document.querySelector(navLinkSelector);
      
      if (!hasData) {
        if (section) section.style.display = 'none';
        if (navLink) navLink.style.display = 'none';
      }
    }

    // Check if clustering has any meaningful data (just check if section exists and has basic info)
    const hasClusteringData = report_data.clustering && 
      report_data.clustering.k !== undefined && 
      report_data.clustering.k > 0;

    // Check if outliers has any meaningful data (just check if section exists and has summary)
    const hasOutliersData = report_data.outliers && 
      report_data.outliers.outlier_summary &&
      report_data.outliers.outlier_summary.outlier_count !== undefined &&
      report_data.outliers.outlier_summary.outlier_count > 0;

    // Check if forecasting has any meaningful data (just check if section exists and has horizon)
    const hasForecastingData = report_data.forecasting && 
      report_data.forecasting.forecast_horizon !== undefined &&
      report_data.forecasting.forecast_horizon > 0;

    // Check if rootcause has any meaningful data (just check if section exists and has target)
    const hasRootCauseData = report_data.rootcause && 
      report_data.rootcause.target_column &&
      report_data.rootcause.target_column !== "";

    // Hide sections and nav links if no data
    hideSectionIfEmpty('clusters', 'nav a[onclick*="clusters"]', hasClusteringData);
    hideSectionIfEmpty('outliers', 'nav a[onclick*="outliers"]', hasOutliersData);
    hideSectionIfEmpty('forecast', 'nav a[onclick*="forecast"]', hasForecastingData);
    hideSectionIfEmpty('rootcause', 'nav a[onclick*="rootcause"]', hasRootCauseData);

    // Render KPIs for all available analyses
    renderClusteringKPIs();
    renderOutliersKPIs();
    renderForecastingKPIs();
    renderRootCauseKPIs();
    
    // Build Key Findings from interpretation & actions of each analysis section
    const keyFindingsItems = [];
    if (report_data.clustering && report_data.clustering.interpretation) {
      keyFindingsItems.push(report_data.clustering.interpretation);
    }
    if (report_data.outliers && report_data.outliers.interpretation) {
      keyFindingsItems.push(report_data.outliers.interpretation);
    }
    if (report_data.forecasting && report_data.forecasting.interpretation) {
      keyFindingsItems.push(report_data.forecasting.interpretation);
    }
    if (report_data.rootcause && report_data.rootcause.interpretation) {
      keyFindingsItems.push(report_data.rootcause.interpretation);
    }
    setHTML("overall-findings", ulFromArray(keyFindingsItems));
    
    // Set recommended actions
    setHTML("overall-actions-list", ulFromArray(report_data.overall.actions));
    
    // Move original findings to Technical Summary
    setHTML("overall-technical-summary-list", ulFromArray(report_data.overall.findings));
"""

REPORT_SCRIPT_RENDER_ANALYSIS_ZONES = """
    // ============================================================
    // RENDER CLUSTERING
    // ============================================================
    if (report_data.clustering) {
      setHTML("clusters-findings", ulFromArray(report_data.clustering.findings || []));
      if (report_data.clustering.k !== undefined) {
        setText("clusters-k", `k = ${report_data.clustering.k} clusters`);
      }
      if (report_data.clustering.silhouette !== undefined) {
        setText("clusters-sil", `Silhouette: ${report_data.clustering.silhouette.toFixed(3)}`);
        setText("clusters-note", report_data.clustering.silhouette >= 0.5 ? "Separation: good" : "Separation: moderate");
      }
      setText("clusters-interpretation", report_data.clustering.interpretation || "");

      // Render data context
      if (report_data.clustering.data_context) {
        const ctx = report_data.clustering.data_context;
        const contextItems = [];
        if (ctx.n_samples > 0) {
          contextItems.push(`<b>Number of samples:</b> ${ctx.n_samples}`);
        }
        if (ctx.n_features > 0) {
          contextItems.push(`<b>Number of features:</b> ${ctx.n_features}`);
        }
        if (ctx.feature_names && ctx.feature_names.length > 0) {
          contextItems.push(`<b>Features used:</b> ${ctx.feature_names.join(', ')}`);
        }
        if (ctx.preprocessing && ctx.preprocessing !== "[PREPROCESSING_INFO]") {
          contextItems.push(`<b>Preprocessing:</b> ${ctx.preprocessing}`);
        }
        if (contextItems.length > 0) {
          const contextSection = document.getElementById("clusters-data-context-section");
          const contextContent = document.getElementById("clusters-data-context-content");
          if (contextSection && contextContent) {
            contextContent.innerHTML = contextItems.map(item => `<div style="margin: 8px 0; font-size: 12px;">${item}</div>`).join("");
            contextSection.style.display = "block";
          }
        }
      }
    }

    // ============================================================
    // RENDER OUTLIER DETECTION
    // ============================================================
    if (report_data.outliers) {
      setHTML("outliers-findings", ulFromArray(report_data.outliers.findings || []));
      setText("outliers-interpretation", report_data.outliers.interpretation || "");
      
      // Set tags
      if (report_data.outliers.outlier_summary) {
        const summary = report_data.outliers.outlier_summary;
        if (summary.outlier_rate !== undefined) {
          setText("outliers-rate", `Outliers: ${(summary.outlier_rate * 100).toFixed(1)}%`);
        }
        if (summary.outlier_count !== undefined) {
          setText("outliers-count", `Count: ${summary.outlier_count}`);
        }
        if (summary.impact_label && summary.impact_label !== "[Low|Medium|High]") {
          setText("outliers-impact", `Impact: ${summary.impact_label}`);
        }
      }

      // Render data context
      if (report_data.outliers.data_context) {
        const ctx = report_data.outliers.data_context;
        const contextItems = [];
        if (ctx.n_samples > 0) {
          contextItems.push(`<b>Number of samples:</b> ${ctx.n_samples.toLocaleString()}`);
        }
        if (ctx.feature_columns && ctx.feature_columns.length > 0) {
          contextItems.push(`<b>Features analyzed:</b> ${ctx.feature_columns.join(', ')}`);
        }
        if (ctx.numeric_features && ctx.numeric_features.length > 0) {
          contextItems.push(`<b>Numeric features:</b> ${ctx.numeric_features.join(', ')}`);
        }
        if (ctx.categorical_features && ctx.categorical_features.length > 0) {
          contextItems.push(`<b>Categorical features:</b> ${ctx.categorical_features.join(', ')}`);
        }
        if (ctx.detection_method && ctx.detection_method !== "[DETECTION_METHOD]") {
          contextItems.push(`<b>Detection method:</b> ${ctx.detection_method}${ctx.contamination ? ` (contamination=${ctx.contamination})` : ''}`);
        }
        if (contextItems.length > 0) {
          const contextSection = document.getElementById("outliers-data-context-section");
          const contextContent = document.getElementById("outliers-data-context-content");
          if (contextSection && contextContent) {
            contextContent.innerHTML = contextItems.map(item => `<div style="margin: 8px 0; font-size: 12px;">${item}</div>`).join("");
            contextSection.style.display = "block";
          }
        }
      }
    }

    // ============================================================
    // RENDER TIME SERIES FORECASTING
    // ============================================================
    if (report_data.forecasting) {
      setHTML("forecast-findings", ulFromArray(report_data.forecasting.findings || []));
      setText("forecast-interpretation", report_data.forecasting.interpretation || "");
      
      // Set tags
      if (report_data.forecasting.forecast_horizon !== undefined && report_data.forecasting.forecast_horizon > 0) {
        const freq = report_data.forecasting.aggregation_freq || "periods";
        const freqLabel = freq === "D" ? "days" : freq === "W" ? "weeks" : freq === "M" ? "months" : freq === "Q" ? "quarters" : freq === "Y" ? "years" : "periods";
        setText("forecast-horizon", `Horizon: ${report_data.forecasting.forecast_horizon} ${freqLabel}`);
      }
      if (report_data.forecasting.time_series_summary && report_data.forecasting.time_series_summary.trend_direction) {
        const trend = report_data.forecasting.time_series_summary.trend_direction;
        const trendLabel = trend === "increasing" ? "Increasing" : trend === "decreasing" ? "Decreasing" : "Stable";
        setText("forecast-trend", `Trend: ${trendLabel}`);
      }
      if (report_data.forecasting.forecast_accuracy) {
        const mae = report_data.forecasting.forecast_accuracy.mae;
        const accuracyLabel = mae !== undefined ? (mae < 100 ? "Good" : mae < 500 ? "Moderate" : "Fair") : "N/A";
        setText("forecast-accuracy", `Accuracy: ${accuracyLabel}`);
      }

      // Render data context
      if (report_data.forecasting.data_context) {
        const ctx = report_data.forecasting.data_context;
        const contextItems = [];
        if (ctx.n_samples > 0) {
          contextItems.push(`<b>Number of samples:</b> ${ctx.n_samples}`);
        }
        if (ctx.aggregation_freq && ctx.aggregation_freq !== "[AGGREGATION_FREQ]") {
          contextItems.push(`<b>Aggregation frequency:</b> ${ctx.aggregation_freq}`);
        }
        if (ctx.aggregation_method && ctx.aggregation_method !== "[AGGREGATION_METHOD]") {
          contextItems.push(`<b>Aggregation method:</b> ${ctx.aggregation_method}`);
        }
        if (ctx.value_column && ctx.value_column !== "[VALUE_COLUMN]") {
          contextItems.push(`<b>Value column:</b> ${ctx.value_column}`);
        }
        if (ctx.date_column && ctx.date_column !== "[DATE_COLUMN]") {
          contextItems.push(`<b>Date column:</b> ${ctx.date_column}`);
        }
        if (report_data.forecasting.split_column) {
          contextItems.push(`<b>Split column:</b> ${report_data.forecasting.split_column}`);
        }
        if (contextItems.length > 0) {
          const contextSection = document.getElementById("forecast-data-context-section");
          const contextContent = document.getElementById("forecast-data-context-content");
          if (contextSection && contextContent) {
            contextContent.innerHTML = contextItems.map(item => `<div style="margin: 8px 0; font-size: 12px;">${item}</div>`).join("");
            contextSection.style.display = "block";
          }
        }
      }
    }

    // ============================================================
    // RENDER ROOT CAUSE ANALYSIS
    // ============================================================
    if (report_data.rootcause) {
      setHTML("rootcause-findings", ulFromArray(report_data.rootcause.findings || []));
      setText("rootcause-interpretation", report_data.rootcause.interpretation || "");
      
      // Set tags
      if (report_data.rootcause.target_column && report_data.rootcause.target_column !== "[TARGET_COLUMN]") {
        setText("rootcause-target", `Target: ${report_data.rootcause.target_column}`);
      }
      if (report_data.rootcause.root_causes && report_data.rootcause.root_causes.length > 0) {
        const topCause = report_data.rootcause.root_causes[0];
        setText("rootcause-top", `Top driver: ${topCause.feature}`);
        setText("rootcause-confidence", `Confidence: ${topCause.confidence || "N/A"}`);
      }

      // Render data context
      if (report_data.rootcause.data_context) {
        const ctx = report_data.rootcause.data_context;
        const contextItems = [];
        if (ctx.target_column && ctx.target_column !== "[TARGET_COLUMN]") {
          contextItems.push(`<b>Target variable:</b> ${ctx.target_column}`);
        }
        if (ctx.n_samples > 0) {
          contextItems.push(`<b>Number of samples:</b> ${ctx.n_samples.toLocaleString()}`);
        }
        if (ctx.feature_columns && ctx.feature_columns.length > 0) {
          contextItems.push(`<b>Features analyzed:</b> ${ctx.feature_columns.join(', ')}`);
        }
        if (ctx.numeric_features && ctx.numeric_features.length > 0) {
          contextItems.push(`<b>Numeric features:</b> ${ctx.numeric_features.join(', ')}`);
        }
        if (ctx.categorical_features && ctx.categorical_features.length > 0) {
          contextItems.push(`<b>Categorical features:</b> ${ctx.categorical_features.join(', ')}`);
        }
        if (contextItems.length > 0) {
          const contextSection = document.getElementById("rootcause-data-context-section");
          const contextContent = document.getElementById("rootcause-data-context-content");
          if (contextSection && contextContent) {
            contextContent.innerHTML = contextItems.map(item => `<div style="margin: 8px 0; font-size: 12px;">${item}</div>`).join("");
            contextSection.style.display = "block";
          }
        }
      }
    }
"""


REPORT_SCRIPT_UTILITY_FUNCTIONS_FOR_FORMATTING = """
    function formatDate(dateStr) {
        if (!dateStr) return dateStr;
        try {
        const date = new Date(dateStr);
        if (isNaN(date.getTime())) {
            const match = dateStr.match(/^(\d{4}-\d{2}-\d{2})/);
            if (match) return match[1];
            return dateStr;
        }
        const year = date.getFullYear();
        const month = String(date.getMonth() + 1).padStart(2, '0');
        const day = String(date.getDate()).padStart(2, '0');
        return `${year}-${month}-${day}`;
        } catch (e) {
        const match = dateStr.match(/^(\d{4}-\d{2}-\d{2})/);
        if (match) return match[1];
        return dateStr;
        }
    }

    function formatNumberCompact(value) {
        if (value === null || value === undefined || isNaN(value)) return "N/A";
        const num = parseFloat(value);
        if (isNaN(num)) return "N/A";
        return num.toLocaleString('en-US', {
        minimumFractionDigits: 0,
        maximumFractionDigits: 2
        });
    }
"""

REPORT_SCRIPT_CHART_HELPERS = """
    function mkBar(ctx, labels, values, label, horizontal=false, showPercentage=false, colors=null, customPercentages=null, hideLegend=false){
      const total = showPercentage ? values.reduce((a, b) => a + b, 0) : 1;
      
      // Default colors or use provided
      const barColors = colors || labels.map(() => 'rgba(122,162,255,0.8)');
      const borderColors = colors || labels.map(() => 'rgba(122,162,255,1)');
      
      // Auto-detect if values are between 0 and 1 (like importance scores) and format as percentage
      const maxAbsValue = Math.max(...values.map(v => Math.abs(v)));
      const shouldFormatAsPercent = maxAbsValue > 0 && maxAbsValue <= 1 && !showPercentage;
      
      return new Chart(ctx, {
        type:'bar',
        data:{ 
          labels: labels,
          datasets:[{ 
            label, 
            data: values, 
            borderWidth:1,
            backgroundColor: barColors,
            borderColor: borderColors
          }] 
        },
        options:{
          maintainAspectRatio: true,
          responsive: true,
          layout: {
            padding: {
              top: 15,
              right: horizontal ? 80 : 30,
              bottom: 15,
              left: horizontal ? 30 : 20
            }
          },
          indexAxis: horizontal ? 'y' : 'x',
          plugins:{ 
            legend:{ display: !hideLegend, labels:{ color:'#e9edf7' } },
            tooltip: {
              callbacks: {
                label: function(context) {
                  const value = horizontal ? context.parsed.x : context.parsed.y;
                  if (value === null || value === undefined || isNaN(value)) {
                    return `${context.dataset.label}: N/A`;
                  }
                  const idx = context.dataIndex;
                  if (customPercentages && customPercentages[idx] !== undefined) {
                    return `${context.dataset.label}: ${value} (${customPercentages[idx].toFixed(1)}%)`;
                  }
                  if (showPercentage && total > 0) {
                    const pct = (value / total * 100).toFixed(1);
                    return `${context.dataset.label}: ${value} (${pct}%)`;
                  }
                  if (shouldFormatAsPercent) {
                    return `${context.dataset.label}: ${(value * 100).toFixed(1)}%`;
                  }
                  return `${context.dataset.label}: ${value.toFixed(0)}`;
                }
              }
            }
          },
          scales:{
            x:{ 
              ticks:{ 
                color:'#b9c2da',
                maxRotation: horizontal ? 0 : 45,
                minRotation: horizontal ? 0 : 45,
                padding: horizontal ? 10 : 5
              }, 
              grid:{ color:'rgba(255,255,255,.06)'} 
            },
            y:{ 
              ticks:{ 
                color:'#b9c2da',
                maxRotation: horizontal ? 0 : 0,
                minRotation: horizontal ? 0 : 0,
                autoSkip: false,
                maxTicksLimit: horizontal ? 20 : undefined,
                padding: horizontal ? 5 : 10
              }, 
              grid:{ color:'rgba(255,255,255,.06)'} 
            }
          }
        },
        plugins: [{
          id: 'datalabels',
          afterDatasetsDraw: (chart) => {
            const ctx = chart.ctx;
            chart.data.datasets.forEach((dataset, i) => {
              const meta = chart.getDatasetMeta(i);
              meta.data.forEach((bar, index) => {
                const value = dataset.data[index];
                if (value === null || value === undefined || isNaN(value)) {
                  return; // Skip invalid values
                }
                let label;
                if (customPercentages && customPercentages[index] !== undefined) {
                  label = `${value.toFixed(0)} (${customPercentages[index].toFixed(1)}%)`;
                } else if (showPercentage && total > 0) {
                  label = `${value.toFixed(0)} (${(value / total * 100).toFixed(1)}%)`;
                } else if (shouldFormatAsPercent) {
                  label = `${(value * 100).toFixed(1)}%`;
                } else {
                  label = `${value.toFixed(0)}`;
                }
                
                ctx.save();
                ctx.fillStyle = '#e9edf7';
                ctx.font = '11px ' + getComputedStyle(document.body).fontFamily;
                ctx.textAlign = 'center';
                ctx.textBaseline = 'middle';
                
                if (horizontal) {
                  // For horizontal bars, position label close to the bar end
                  // Use the actual pixel position of the bar end
                  const xScale = chart.scales.x;
                  const barEndX = xScale.getPixelForValue(value);
                  const x = value >= 0 ? barEndX + 10 : barEndX - 10;
                  const y = bar.y;
                  ctx.textAlign = value >= 0 ? 'left' : 'right';
                  ctx.fillText(label, x, y);
                } else {
                  const x = bar.x;
                  const y = bar.y - 15;
                  ctx.fillText(label, x, y);
                }
                ctx.restore();
              });
            });
          }
        }]
      });
    }

    function mkDualYAxis(ctx, labels, leftData, leftLabel, rightData, rightLabel){
      return new Chart(ctx, {
        type:'line',
        data:{
          labels,
          datasets:[
            {
              label: leftLabel,
              data: leftData,
              yAxisID: 'y',
              tension: 0.35,
              pointRadius: 2,
              borderWidth: 2,
              borderColor: 'rgba(99,214,163,1)',
              backgroundColor: 'rgba(99,214,163,0.1)'
            },
            {
              label: rightLabel,
              data: rightData,
              yAxisID: 'y1',
              tension: 0.35,
              pointRadius: 2,
              borderWidth: 2,
              borderColor: 'rgba(255,159,64,1)',
              backgroundColor: 'rgba(255,159,64,0.1)'
            }
          ]
        },
        options:{
          maintainAspectRatio: true,
          responsive: true,
          layout: {
            padding: {
              top: 15,
              right: 20,
              bottom: 15,
              left: 20
            }
          },
          plugins:{ legend:{ labels:{ color:'#e9edf7' } } },
          scales:{
            x:{ ticks:{ color:'#b9c2da' }, grid:{ color:'rgba(255,255,255,.06)'} },
            y:{
              type: 'linear',
              display: true,
              position: 'left',
              title: {
                display: true,
                text: leftLabel,
                color: '#b9c2da',
                font: { size: 12 }
              },
              ticks:{ 
                color:'#b9c2da',
                maxTicksLimit: 6,
                callback: function(value) {
                  // Format large numbers more compactly (for Distortion)
                  if (Math.abs(value) >= 1000000000) {
                    return (value / 1000000000).toFixed(1) + 'B';
                  } else if (Math.abs(value) >= 1000000) {
                    return (value / 1000000).toFixed(1) + 'M';
                  } else if (Math.abs(value) >= 1000) {
                    return (value / 1000).toFixed(1) + 'K';
                  } else if (Math.abs(value) >= 1) {
                    return value.toFixed(0);
                  } else {
                    return value.toFixed(2);
                  }
                }
              },
              grid:{ color:'rgba(255,255,255,.06)'}
            },
            y1:{
              type: 'linear',
              display: true,
              position: 'right',
              title: {
                display: true,
                text: rightLabel,
                color: '#b9c2da',
                font: { size: 12 }
              },
              ticks:{ 
                color:'#b9c2da',
                maxTicksLimit: 6,
                callback: function(value) {
                  // Format silhouette scores (0-1 range) with 2 decimals
                  return value.toFixed(2);
                }
              },
              grid:{ drawOnChartArea: false }
            }
          }
        }
      });
    }

    function mkSingleBoxplot(ctx, label, stats){
      // stats is {min, q1, median, q3, max, mean, lower_whisker, upper_whisker}
      // Calculate min and max values for this specific column to set proper Y scale
      let yMin = Math.min(stats.min, stats.lower_whisker);
      let yMax = Math.max(stats.max, stats.upper_whisker);
      
      // Add padding (10% on each side) but ensure we don't go below 0 if all values are positive
      const range = yMax - yMin;
      const padding = range * 0.10;
      yMin = yMin - padding;
      yMax = yMax + padding;
      
      // If all values are positive and padding would make min negative, start from 0
      if (stats.min >= 0 && yMin < 0) {
        yMin = 0;
      }
      
      // Ensure we have a valid range
      if (yMin >= yMax) {
        yMin = stats.min;
        yMax = stats.max;
      }
      
      // We'll use a bar chart as base and draw boxplot with a custom plugin
      const chart = new Chart(ctx, {
        type:'bar',
        data:{
          labels: [label],
          datasets:[{
            label: 'Boxplot',
            data: [stats.median],
            backgroundColor: 'transparent',
            borderColor: 'transparent'
          }]
        },
        options:{
          maintainAspectRatio: false,
          responsive: true,
          layout: {
            padding: {
              top: 15,
              right: 20,
              bottom: 15,
              left: 20
            }
          },
          plugins:{ 
            legend:{ display: false },
            tooltip: {
              callbacks: {
                title: function(context) {
                  return label;
                },
                label: function(context) {
                  return [
                    `Min: ${stats.min.toLocaleString('en-US', {maximumFractionDigits: 2})}`,
                    `Q1: ${stats.q1.toLocaleString('en-US', {maximumFractionDigits: 2})}`,
                    `Median: ${stats.median.toLocaleString('en-US', {maximumFractionDigits: 2})}`,
                    `Q3: ${stats.q3.toLocaleString('en-US', {maximumFractionDigits: 2})}`,
                    `Max: ${stats.max.toLocaleString('en-US', {maximumFractionDigits: 2})}`,
                    `Mean: ${stats.mean.toLocaleString('en-US', {maximumFractionDigits: 2})}`
                  ];
                }
              }
            }
          },
          scales:{
            x:{ 
              ticks:{ color:'#b9c2da', display: false }, 
              grid:{ color:'rgba(255,255,255,.06)', display: false} 
            },
            y:{ 
              ticks:{ 
                color:'#b9c2da',
                maxTicksLimit: 6,
                callback: function(value) {
                  // Format large numbers more compactly
                  if (Math.abs(value) >= 1000000) {
                    return (value / 1000000).toFixed(1) + 'M';
                  } else if (Math.abs(value) >= 1000) {
                    return (value / 1000).toFixed(1) + 'K';
                  } else if (Math.abs(value) >= 1) {
                    return value.toFixed(0);
                  } else {
                    return value.toFixed(2);
                  }
                }
              }, 
              grid:{ color:'rgba(255,255,255,.06)'},
              min: yMin,
              max: yMax
            }
          }
        },
        plugins: [{
          id: 'boxplot',
          afterDatasetsDraw: (chart) => {
            const ctx = chart.ctx;
            const meta = chart.getDatasetMeta(0);
            const yScale = chart.scales.y;
            
            const boxWidth = 60;
            const whiskerWidth = 30;
            
            const x = meta.data[0].x;
            
            // Convert values to pixel coordinates
            const yMinPixel = yScale.getPixelForValue(stats.min);
            const yMaxPixel = yScale.getPixelForValue(stats.max);
            const yQ1 = yScale.getPixelForValue(stats.q1);
            const yMedian = yScale.getPixelForValue(stats.median);
            const yQ3 = yScale.getPixelForValue(stats.q3);
            const yLowerWhisker = yScale.getPixelForValue(stats.lower_whisker);
            const yUpperWhisker = yScale.getPixelForValue(stats.upper_whisker);
            
            ctx.save();
            
            // Draw whiskers (lower)
            ctx.strokeStyle = 'rgba(122,162,255,1)';
            ctx.lineWidth = 2;
            ctx.beginPath();
            ctx.moveTo(x - whiskerWidth/2, yLowerWhisker);
            ctx.lineTo(x + whiskerWidth/2, yLowerWhisker);
            ctx.moveTo(x, yLowerWhisker);
            ctx.lineTo(x, yQ1);
            ctx.stroke();
            
            // Draw box
            // Q1 is lower value than Q3, so yQ1 (pixel) is greater than yQ3 (pixel)
            // We draw from Q3 (top) to Q1 (bottom)
            const boxTop = Math.min(yQ1, yQ3);
            const boxBottom = Math.max(yQ1, yQ3);
            const boxHeight = boxBottom - boxTop;
            ctx.fillStyle = 'rgba(122,162,255,0.2)';
            ctx.fillRect(x - boxWidth/2, boxTop, boxWidth, boxHeight);
            ctx.strokeRect(x - boxWidth/2, boxTop, boxWidth, boxHeight);
            
            // Draw median line
            ctx.strokeStyle = 'rgba(255,159,64,1)';
            ctx.lineWidth = 2;
            ctx.beginPath();
            ctx.moveTo(x - boxWidth/2, yMedian);
            ctx.lineTo(x + boxWidth/2, yMedian);
            ctx.stroke();
            
            // Draw whiskers (upper)
            ctx.strokeStyle = 'rgba(122,162,255,1)';
            ctx.lineWidth = 2;
            ctx.beginPath();
            ctx.moveTo(x, yQ3);
            ctx.lineTo(x, yUpperWhisker);
            ctx.moveTo(x - whiskerWidth/2, yUpperWhisker);
            ctx.lineTo(x + whiskerWidth/2, yUpperWhisker);
            ctx.stroke();
            
            // Draw outliers (points beyond whiskers)
            if (stats.min < stats.lower_whisker) {
              ctx.fillStyle = 'rgba(255,107,107,0.8)';
              ctx.beginPath();
              ctx.arc(x, yMinPixel, 3, 0, 2 * Math.PI);
              ctx.fill();
            }
            if (stats.max > stats.upper_whisker) {
              ctx.fillStyle = 'rgba(255,107,107,0.8)';
              ctx.beginPath();
              ctx.arc(x, yMaxPixel, 3, 0, 2 * Math.PI);
              ctx.fill();
            }
            
            ctx.restore();
          }
        }]
      });
      
      return chart;
    }

    function mkForecastChart(ctx, historicalDates, historicalValues, forecastDates, forecastValues, forecastLower, forecastUpper, valueLabel){
      const formattedHistoricalDates = historicalDates.map(d => formatDate(d));
      const formattedForecastDates = forecastDates.map(d => formatDate(d));
      
      // Get the last historical value to connect with forecast
      const lastHistoricalValue = historicalValues.length > 0 ? historicalValues[historicalValues.length - 1] : null;
      const lastHistoricalDate = formattedHistoricalDates.length > 0 ? formattedHistoricalDates[formattedHistoricalDates.length - 1] : null;
      
      // Combine dates: historical + forecast (avoid duplicate if last historical date equals first forecast date)
      const allDates = [...formattedHistoricalDates];
      if (lastHistoricalDate !== formattedForecastDates[0]) {
        allDates.push(...formattedForecastDates);
      } else {
        allDates.push(...formattedForecastDates.slice(1));
      }
      
      // Create forecast data array: null for historical period, then forecast values (without transition point)
      const forecastDataArray = [...new Array(historicalDates.length).fill(null)];
      // Add forecast values (skip first if it's the same date as last historical)
      if (lastHistoricalDate === formattedForecastDates[0]) {
        forecastDataArray.push(...forecastValues.slice(1));
      } else {
        forecastDataArray.push(...forecastValues);
      }
      
      // Create transition line data (blue line connecting last historical to first forecast)
      const transitionDataArray = [...new Array(historicalDates.length - 1).fill(null)];
      if (lastHistoricalValue !== null) {
        // Add transition point: last historical value at the last historical date
        transitionDataArray.push(lastHistoricalValue);
        // Add first forecast value for the connection
        const firstForecastValue = lastHistoricalDate === formattedForecastDates[0] 
          ? forecastValues[0] 
          : (forecastValues.length > 0 ? forecastValues[0] : null);
        if (firstForecastValue !== null) {
          transitionDataArray.push(firstForecastValue);
        }
      }
      // Fill rest with null
      transitionDataArray.push(...new Array(allDates.length - transitionDataArray.length).fill(null));
      
      // Adjust confidence intervals similarly
      const allLower = [...new Array(historicalDates.length).fill(null)];
      if (lastHistoricalDate === formattedForecastDates[0]) {
        allLower.push(...forecastLower.slice(1));
      } else {
        allLower.push(...forecastLower);
      }
      
      const allUpper = [...new Array(historicalDates.length).fill(null)];
      if (lastHistoricalDate === formattedForecastDates[0]) {
        allUpper.push(...forecastUpper.slice(1));
      } else {
        allUpper.push(...forecastUpper);
      }
      
      return new Chart(ctx, {
        type:'line',
        data:{
          labels: allDates,
          datasets:[
            {
              label: 'Historical',
              data: historicalValues,
              borderColor: 'rgba(122,162,255,1)',
              backgroundColor: 'rgba(122,162,255,0.1)',
              tension: 0.3,
              pointRadius: 2,
              borderWidth: 2,
              fill: false
            },
            {
              label: 'Transition',
              data: transitionDataArray,
              borderColor: 'rgba(122,162,255,1)',
              backgroundColor: 'rgba(122,162,255,0.1)',
              tension: 0.3,
              pointRadius: 0,
              borderWidth: 2,
              borderDash: [5, 5],
              fill: false,
              showInLegend: false
            },
            {
              label: 'Forecast',
              data: forecastDataArray,
              borderColor: 'rgba(99,214,163,1)',
              backgroundColor: 'rgba(99,214,163,0.1)',
              tension: 0.3,
              pointRadius: 2,
              borderWidth: 2,
              borderDash: [5, 5],
              fill: false
            },
            {
              label: 'Lower Bound',
              data: allLower,
              borderColor: 'rgba(144,238,144,0.5)',
              backgroundColor: 'rgba(144,238,144,0.2)',
              pointRadius: 0,
              borderWidth: 1,
              fill: false,
              hidden: false,
              showInLegend: false
            },
            {
              label: 'Confidence Interval',
              data: allUpper,
              borderColor: 'rgba(144,238,144,0.5)',
              backgroundColor: 'rgba(144,238,144,0.2)',
              pointRadius: 0,
              borderWidth: 1,
              fill: '-1'
            }
          ]
        },
        options:{
          maintainAspectRatio: true,
          responsive: true,
          layout: {
            padding: {
              top: 15,
              right: 20,
              bottom: 15,
              left: 20
            }
          },
          plugins:{ 
            legend:{ 
              labels:{ 
                color:'#e9edf7',
                filter: function(item, chart) {
                  // Hide "Transition" and "Lower Bound" from legend
                  return item.text !== 'Transition' && item.text !== 'Lower Bound';
                }
              } 
            },
            tooltip: {
              callbacks: {
                label: function(context) {
                  // Hide tooltip for Transition, Lower Bound, and Confidence Interval datasets
                  if (context.datasetIndex === 1 || context.datasetIndex === 3 || context.datasetIndex === 4) {
                    return null;
                  }
                  if (context.parsed.y === null) {
                    return null;
                  }
                  const formattedValue = formatNumberCompact(context.parsed.y);
                  return `${context.dataset.label}: ${formattedValue}`;
                }
              }
            }
          },
          scales:{
            x:{ 
              ticks:{ 
                color:'#b9c2da',
                maxRotation: 45,
                minRotation: 45
              }, 
              grid:{ color:'rgba(255,255,255,.06)'}
            },
            y:{ 
              ticks:{ 
                color:'#b9c2da',
                callback: function(value) {
                  return formatNumberCompact(value);
                }
              }, 
              grid:{ color:'rgba(255,255,255,.06)'},
              title: {
                display: true,
                text: valueLabel || 'Value',
                color: '#b9c2da'
              }
            }
          }
        }
      });
    }
"""


REPORT_SCRIPT_BUILD_ANALYSIS_ZONE_CHARTS = """
    // ============================================================
    // BUILD CLUSTERING CHARTS
    // ============================================================
    if (report_data.clustering && report_data.clustering.cluster_statistics && report_data.clustering.cluster_statistics.labels && report_data.clustering.cluster_statistics.labels.length > 0) {
      const ctxClusterDistribution = document.getElementById("chart-cluster-distribution");
      if (ctxClusterDistribution) {
        mkBar(
          ctxClusterDistribution.getContext('2d'),
          report_data.clustering.cluster_statistics.labels,
          report_data.clustering.cluster_statistics.values,
          "Cluster Size",
          false,  // vertical bar chart
          true,   // show percentage
          null,   // colors
          null,   // customPercentages
          true    // hideLegend
        );
      }
    }

    if (report_data.clustering && report_data.clustering.feature_importance && report_data.clustering.feature_importance.labels && report_data.clustering.feature_importance.labels.length > 0) {
      const ctxFeatureImportance = document.getElementById("chart-feature-importance");
      if (ctxFeatureImportance) {
        mkBar(
          ctxFeatureImportance.getContext('2d'),
          report_data.clustering.feature_importance.labels,
          report_data.clustering.feature_importance.values,
          "Importance",
          true,   // horizontal bar chart
          false,  // don't show percentage (values are already between 0-1, will be auto-formatted as %)
          null,   // colors
          null,   // customPercentages
          true    // hideLegend
        );
      }
    }

    // Quality & Robustness: Dual y-axis chart (Silhouette and Elbow)
    if (report_data.clustering && report_data.clustering.elbow && report_data.clustering.elbow.k && report_data.clustering.elbow.k.length > 0 &&
        report_data.clustering.silhouette_by_k && report_data.clustering.silhouette_by_k.k && report_data.clustering.silhouette_by_k.k.length > 0) {
      const elbowK = report_data.clustering.elbow.k;
      const silK = report_data.clustering.silhouette_by_k.k;
      const commonK = elbowK.filter(k => silK.includes(k));
      
      if (commonK.length > 0) {
        const alignedK = commonK.map(String);
        const alignedDistortion = commonK.map(k => {
          const idx = elbowK.indexOf(k);
          return report_data.clustering.elbow.distortion[idx];
        });
        const alignedSilhouette = commonK.map(k => {
          const idx = silK.indexOf(k);
          return report_data.clustering.silhouette_by_k.score[idx];
        });
        
        const ctxQualityRobustness = document.getElementById("chart-quality-robustness");
        if (ctxQualityRobustness) {
          mkDualYAxis(
            ctxQualityRobustness.getContext('2d'),
            alignedK,
            alignedDistortion,
            "Distortion (Elbow)",
            alignedSilhouette,
            "Silhouette Score"
          );
        }
      }
    }

    // ============================================================
    // BUILD OUTLIER DETECTION CHARTS
    // ============================================================
    // Outliers by Column Chart
    if (report_data.outliers && report_data.outliers.outliers_by_column && Object.keys(report_data.outliers.outliers_by_column).length > 0) {
      const outliersByCol = report_data.outliers.outliers_by_column;
      const labels = Object.keys(outliersByCol).sort((a, b) => 
        outliersByCol[b].outlier_count - outliersByCol[a].outlier_count
      );
      const values = labels.map(l => outliersByCol[l].outlier_count);
      const percentages = labels.map(l => outliersByCol[l].outlier_percentage || 0);
      
      const ctxOutliersByColumn = document.getElementById("chart-outliers-by-column");
      if (ctxOutliersByColumn) {
        mkBar(
          ctxOutliersByColumn.getContext('2d'),
          labels,
          values,
          "Outlier Count",
          true,  // horizontal
          false,  // showPercentage (not using auto-calculated percentages)
          null,   // colors
          percentages,  // customPercentages
          true    // hideLegend
        );
      }
    }

    // Boxplot: Distribution Statistics for Numeric Columns - One chart per column with its own axis
    if (report_data.outliers && report_data.outliers.outliers_by_column && report_data.outliers.data_context) {
      const outliersByCol = report_data.outliers.outliers_by_column;
      const numericCols = report_data.outliers.data_context.numeric_features || [];
      
      // Filter only numeric columns that have boxplot_stats
      const numericColumnsWithStats = numericCols.filter(col => 
        outliersByCol[col] && outliersByCol[col].boxplot_stats
      );
      
      const boxplotsContainer = document.getElementById("boxplots-container");
      if (boxplotsContainer && numericColumnsWithStats.length > 0) {
        // Clear container
        boxplotsContainer.innerHTML = '';
        
        // Create a boxplot for each column
        numericColumnsWithStats.forEach((col, index) => {
          const stats = outliersByCol[col].boxplot_stats;
          
          // Create container for this boxplot
          const boxplotDiv = document.createElement('div');
          boxplotDiv.className = 'single-boxplot-container';
          
          // Create title
          const titleDiv = document.createElement('div');
          titleDiv.className = 'single-boxplot-title';
          titleDiv.textContent = col;
          boxplotDiv.appendChild(titleDiv);
          
          // Create canvas with fixed dimensions for better aspect ratio
          const canvas = document.createElement('canvas');
          canvas.className = 'single-boxplot-canvas';
          canvas.id = `boxplot-${col.replace(/\s+/g, '-').toLowerCase()}-${index}`;
          // Set explicit dimensions to control aspect ratio
          canvas.style.width = '100%';
          canvas.style.height = '300px';
          boxplotDiv.appendChild(canvas);
          
          // Add to container
          boxplotsContainer.appendChild(boxplotDiv);
          
          // Wait for canvas to be in DOM before setting dimensions
          setTimeout(() => {
            canvas.width = canvas.offsetWidth;
            canvas.height = 300;
            // Create the boxplot chart with its own axis
            mkSingleBoxplot(
              canvas.getContext('2d'),
              col,
              stats
            );
          }, 0);
        });
      }
    }

    // Table: Top Outliers by Column (Categorical only)
    if (report_data.outliers && report_data.outliers.outliers_by_column && report_data.outliers.data_context) {
      const outliersByCol = report_data.outliers.outliers_by_column;
      const categoricalCols = report_data.outliers.data_context.categorical_features || [];
      
      // Filter only categorical columns (those without boxplot_stats)
      const categoricalColumns = Object.keys(outliersByCol).filter(col => 
        !outliersByCol[col].boxplot_stats && categoricalCols.includes(col)
      );
      
      const tableBody = document.getElementById("table-top-outliers-body");
      if (tableBody && categoricalColumns.length > 0) {
        // Sort columns by outlier count (descending)
        const sortedColumns = categoricalColumns.sort((a, b) => 
          outliersByCol[b].outlier_count - outliersByCol[a].outlier_count
        );
        
        tableBody.innerHTML = sortedColumns.map(col => {
          const colData = outliersByCol[col];
          const topValues = colData.top_outlier_values || [];
          // Format values: show top 5
          const formattedValues = topValues.slice(0, 5).map(v => String(v)).join(', ');
          
          return `
            <tr>
              <td><b>${col}</b></td>
              <td style="font-family:var(--mono);">${formattedValues || 'N/A'}</td>
            </tr>
          `;
        }).join("");
      } else if (tableBody) {
        tableBody.innerHTML = '<tr><td colspan="2" style="text-align:center; color:var(--muted);">No categorical columns with outliers</td></tr>';
      }
    }

    // ============================================================
    // BUILD FORECASTING CHARTS
    // ============================================================
    if (report_data.forecasting && 
        report_data.forecasting.time_series_data && 
        report_data.forecasting.time_series_data.dates && 
        report_data.forecasting.time_series_data.dates.length > 0 &&
        report_data.forecasting.forecast_data &&
        report_data.forecasting.forecast_data.dates &&
        report_data.forecasting.forecast_data.dates.length > 0) {
      
      const tsData = report_data.forecasting.time_series_data;
      const fcData = report_data.forecasting.forecast_data;
      const valueLabel = report_data.forecasting.value_column || "Value";
      
      const hasValidHistorical = tsData.dates && tsData.dates.length > 0 && 
                                 tsData.values && tsData.values.length > 0 &&
                                 tsData.dates[0] !== "[DATE_1]";
      const hasValidForecast = fcData.dates && fcData.dates.length > 0 &&
                               fcData.values && fcData.values.length > 0 &&
                               fcData.dates[0] !== "[FORECAST_DATE_1]";
      
      if (hasValidHistorical && hasValidForecast) {
        const ctxForecast = document.getElementById("chart-forecast");
        if (ctxForecast) {
          mkForecastChart(
            ctxForecast.getContext('2d'),
            tsData.dates,
            tsData.values,
            fcData.dates,
            fcData.values,
            fcData.lower || [],
            fcData.upper || [],
            valueLabel
          );
        }
      }
    }

    // ============================================================
    // BUILD ROOT CAUSE ANALYSIS CHARTS
    // ============================================================
    // Feature Importance Chart (Root Causes Ranking)
    if (report_data.rootcause && report_data.rootcause.root_causes && report_data.rootcause.root_causes.length > 0) {
      const rootCauses = report_data.rootcause.root_causes;
      
      // Update KPI in chart title
      const kpiElement = document.getElementById('root-causes-kpi');
      if (kpiElement && rootCauses.length > 0) {
        const topCause = rootCauses[0];
        kpiElement.textContent = `(${rootCauses.length} identified, top: ${topCause.feature})`;
      }
      
      const labels = rootCauses.map(rc => rc.feature);
      const scores = rootCauses.map(rc => rc.importance_score);
      const colors = rootCauses.map(rc => {
        // Colors from low to high confidence: orange -> medium blue -> dark blue
        if (rc.confidence === 'high') return '#1D4ED8';  // dark blue
        if (rc.confidence === 'medium') return '#60A5FA';  // medium blue
        return '#FF8063';  // orange for low (good contrast with white text)
      });
      const borderColors = rootCauses.map(rc => {
        if (rc.confidence === 'high') return '#1D4ED8';  // dark blue
        if (rc.confidence === 'medium') return '#60A5FA';  // medium blue
        return '#FF8063';  // orange for low
      });
      
      const ctxRootCauses = document.getElementById("chart-root-causes");
      if (ctxRootCauses) {
        // Create custom chart with legend showing confidence levels
        const chart = new Chart(ctxRootCauses.getContext('2d'), {
          type:'bar',
          data:{ 
            labels: labels,
            datasets:[{ 
              label: "Importance Score", 
              data: scores,
              backgroundColor: colors,
              borderColor: borderColors,
              borderWidth: 1
            }] 
          },
          options:{
            maintainAspectRatio: true,
            responsive: true,
            layout: {
              padding: {
                top: 15,
                right: 80,
                bottom: 15,
                left: 30
              }
            },
            indexAxis: 'y',
            plugins:{ 
              legend:{ 
                display: false  // We'll create a custom HTML legend instead
              },
              tooltip: {
                callbacks: {
                  label: function(context) {
                    const value = context.parsed.x;
                    if (value === null || value === undefined || isNaN(value)) {
                      return `${context.dataset.label}: N/A`;
                    }
                    // Format as percentage (values are between 0-1)
                    return `${context.dataset.label}: ${(value * 100).toFixed(1)}%`;
                  }
                }
              }
            },
            scales:{
              x:{ 
                ticks:{ 
                  color:'#b9c2da',
                  maxRotation: 0,
                  minRotation: 0,
                  autoSkip: false,
                  maxTicksLimit: 20,
                  padding: 5,
                  callback: function(value) {
                    // Format as percentage
                    return (value * 100).toFixed(1) + '%';
                  }
                }, 
                grid:{ color:'rgba(255,255,255,.06)'} 
              },
              y:{ 
                ticks:{ 
                  color:'#b9c2da',
                  maxRotation: 0,
                  minRotation: 0,
                  autoSkip: false,
                  padding: 10
                }, 
                grid:{ color:'rgba(255,255,255,.06)'} 
              }
            }
          },
          plugins: [{
            id: 'datalabels',
            afterDatasetsDraw: (chart) => {
              const ctx = chart.ctx;
              chart.data.datasets.forEach((dataset, i) => {
                const meta = chart.getDatasetMeta(i);
                meta.data.forEach((bar, index) => {
                  const value = dataset.data[index];
                  if (value === null || value === undefined || isNaN(value)) {
                    return;
                  }
                  const label = `${(value * 100).toFixed(1)}%`;
                  
                  ctx.save();
                  ctx.fillStyle = '#ffffff';  // white text for visibility
                  ctx.font = '11px ' + getComputedStyle(document.body).fontFamily;
                  ctx.textAlign = 'left';
                  ctx.textBaseline = 'middle';
                  
                  const xScale = chart.scales.x;
                  const barEndX = xScale.getPixelForValue(value);
                  // Position text inside the bar (at 80% of bar length) for better visibility on blue colors
                  const x = barEndX * 0.8;
                  const y = bar.y;
                  ctx.fillText(label, x, y);
                  ctx.restore();
                });
              });
            }
          }]
        });
        
        // Create custom HTML legend with white text
        const legendContainer = document.getElementById('legend-root-causes');
        if (legendContainer) {
          const legendItems = [
            { text: 'High Confidence', color: '#1D4ED8' },
            { text: 'Medium Confidence', color: '#60A5FA' },
            { text: 'Low Confidence', color: '#FF8063' }
          ];
          
          legendItems.forEach(item => {
            const legendItem = document.createElement('div');
            legendItem.style.display = 'flex';
            legendItem.style.alignItems = 'center';
            legendItem.style.gap = '8px';
            legendItem.style.color = '#ffffff';
            legendItem.style.fontSize = '12px';
            
            const colorBox = document.createElement('div');
            colorBox.style.width = '16px';
            colorBox.style.height = '16px';
            colorBox.style.backgroundColor = item.color;
            colorBox.style.border = `1px solid ${item.color}`;
            colorBox.style.borderRadius = '3px';
            
            const textSpan = document.createElement('span');
            textSpan.textContent = item.text;
            textSpan.style.color = '#ffffff';
            
            legendItem.appendChild(colorBox);
            legendItem.appendChild(textSpan);
            legendContainer.appendChild(legendItem);
          });
        }
      }
    }

    // Top Correlations Chart
    if (report_data.rootcause && report_data.rootcause.correlations && report_data.rootcause.correlations.top_correlated && report_data.rootcause.correlations.top_correlated.length > 0) {
      const topCorr = report_data.rootcause.correlations.top_correlated;
      const labels = topCorr.map(c => c.feature);
      const values = topCorr.map(c => c.pearson_corr);
      const colors = values.map(v => v >= 0 ? 'rgba(99,214,163,0.8)' : 'rgba(255,107,107,0.8)');
      const borderColors = values.map(v => v >= 0 ? 'rgba(99,214,163,1)' : 'rgba(255,107,107,1)');
      
      const ctxCorrelations = document.getElementById("chart-correlations");
      if (ctxCorrelations) {
        const ctx = ctxCorrelations.getContext('2d');
        new Chart(ctx, {
          type:'bar',
          data:{ 
            labels: labels,
            datasets:[{ 
              label: "Correlation", 
              data: values,
              backgroundColor: colors,
              borderColor: borderColors,
              borderWidth:1
            }] 
          },
          options:{
            maintainAspectRatio: true,
            responsive: true,
            layout: {
              padding: {
                top: 15,
                right: 20,
                bottom: 15,
                left: 20
              }
            },
            plugins:{ 
              legend:{ display: false },
            tooltip: {
              callbacks: {
                label: function(context) {
                  const value = context.parsed.y;
                  const isSignificant = topCorr[context.dataIndex].significant;
                  return `Correlation: ${(value * 100).toFixed(1)}% ${isSignificant ? '(significant)' : '(not significant)'}`;
                }
              }
            }
            },
            scales:{
              x:{ ticks:{ color:'#b9c2da' }, grid:{ color:'rgba(255,255,255,.06)'} },
              y:{ 
                ticks:{ color:'#b9c2da' }, 
                grid:{ color:'rgba(255,255,255,.06)'},
                min: -1,
                max: 1
              }
            }
          },
          plugins: [{
            id: 'datalabels',
            afterDatasetsDraw: (chart) => {
              const ctx = chart.ctx;
              chart.data.datasets.forEach((dataset, i) => {
                const meta = chart.getDatasetMeta(i);
                meta.data.forEach((bar, index) => {
                  const value = dataset.data[index];
                  if (value === null || value === undefined || isNaN(value)) {
                    return; // Skip invalid values
                  }
                  const label = `${(value * 100).toFixed(1)}%`;
                  
                  ctx.save();
                  ctx.fillStyle = '#e9edf7';
                  ctx.font = '11px ' + getComputedStyle(document.body).fontFamily;
                  ctx.textAlign = 'center';
                  ctx.textBaseline = 'middle';
                  
                  const x = bar.x;
                  const y = bar.y - 15;
                  ctx.fillText(label, x, y);
                  ctx.restore();
                });
              });
            }
          }]
        });
      }
    }

    // Categorical Impacts Chart
    if (report_data.rootcause && report_data.rootcause.categorical_impacts && Object.keys(report_data.rootcause.categorical_impacts).length > 0) {
      const catImpacts = report_data.rootcause.categorical_impacts;
      const labels = Object.keys(catImpacts);
      const values = labels.map(l => catImpacts[l].f_ratio);
      
      const ctxCategorical = document.getElementById("chart-categorical-impacts");
      if (ctxCategorical) {
        mkBar(
          ctxCategorical.getContext('2d'),
          labels,
          values,
          "F-ratio",
          true,  // horizontal
          false, // showPercentage
          null,  // colors
          null,  // customPercentages
          true   // hideLegend
        );
      }
    }
"""


def get_report_script_report_data_template():
    template = """
    // ============================================================
    // DATA CONTRACT - Replace this object with actual analysis data
    // ============================================================
    // The AI agent should populate this report_data object with:
    // - Real dataset names and metadata
    // - Actual findings, KPIs, and interpretations for all analyses
    // - Real chart data (labels, values, series) for all analyses
    // ============================================================
    // IMPORTANT: 
    // - overall.findings will be displayed in "Technical Summary" section
    // - Key Findings section will be automatically populated from each analysis section's interpretation field
    // - Each analysis section (clustering, outliers, forecasting, rootcause) must include an interpretation field
    // ============================================================
    const report_data = {
      meta: {
        dataset_name: "[DATASET_NAME]"  // Replace with actual dataset name
      },

      overall: {
        kpis: [
          // KPIs will be automatically extracted from available analyses
          // Structure: { label: "KPI Label", value: "KPI Value" }
        ],
        findings: [
          // Replace with actual technical findings (array of strings)
          // These will be displayed in the "Technical Summary" section
          "[FINDING_1]",
          "[FINDING_2]",
          "[FINDING_3]"
        ],
        actions: [
          // Replace with recommended actions (array of strings)
          // These will be displayed in the "Recommended Actions" section
          "[ACTION_1]",
          "[ACTION_2]"
        ]
      },

      clustering: {
        k: 0,                            // Integer: number of clusters
        silhouette: 0.0,                 // Float: silhouette score
        davies_bouldin: 0.0,             // Float: davies-bouldin score (optional)
        data_context: {
          n_samples: 0,                   // Integer: number of samples/rows analyzed
          n_features: 0,                  // Integer: number of features used
          feature_names: [],             // Array of feature names used in clustering
          preprocessing: "[PREPROCESSING_INFO]"  // String: info about data preprocessing
        },
        findings: [
          // Array of finding strings
          "[FINDING_1]",
          "[FINDING_2]"
        ],
        interpretation: "[INTERPRETATION_TEXT]",  // String: This will be displayed in the "Key Findings" section of Overall Findings
        cluster_statistics: {
          labels: ["[CLUSTER_1]", "[CLUSTER_2]"],  // Array of cluster labels/IDs
          values: [0, 0]                            // Array of cluster sizes (counts)
        },
        feature_importance: {
          labels: ["[FEATURE_1]", "[FEATURE_2]"],  // Array of feature names
          values: [0.0, 0.0]                        // Array of importance scores
        },
        elbow: {
          k: [2, 3, 4],                  // Array of k values tested
          distortion: [1.0, 0.8, 0.6]    // Array of distortion values
        },
        silhouette_by_k: {
          k: [2, 3, 4],                  // Array of k values tested
          score: [0.3, 0.4, 0.35]        // Array of silhouette scores
        }
      },

      outliers: {
        outlier_summary: {
          outlier_rate: 0.0,                               // Float: outlier rate as decimal (0.038 for 3.8%)
          outlier_count: 0,                                // Integer: total number of outliers
          columns_with_outliers: 0,                        // Integer: number of columns with outliers
          impact_label: "[Low|Medium|High]"                // String: impact level
        },
        outliers_by_column: {
          // Dictionary: { "[COLUMN_NAME]": { outlier_count, outlier_percentage, method_used, top_outlier_values, boxplot_stats (for numeric) } }
        },
        outlier_patterns: {
          multi_column_outliers_count: 0,                  // Integer: number of rows that are outliers in multiple columns
          most_common_outlier_columns: ["[COLUMN_1]", "[COLUMN_2]", "[COLUMN_3]"]  // Array: top 3 columns with most outliers
        },
        data_context: {
          n_samples: 0,                                    // Integer: number of samples/rows analyzed
          feature_columns: ["[FEATURE_1]", "[FEATURE_2]"], // Array: all features analyzed
          numeric_features: ["[NUMERIC_FEATURE_1]"],       // Array: numeric feature names
          categorical_features: ["[CATEGORICAL_FEATURE_1]"], // Array: categorical feature names
          detection_method: "[DETECTION_METHOD]",         // String: detection method used (e.g., "Isolation Forest")
          contamination: 0.05                              // Float: contamination parameter (for Isolation Forest)
        },
        findings: [
          // Array of finding strings
          "[FINDING_1]",
          "[FINDING_2]"
        ],
        interpretation: "[INTERPRETATION_TEXT]"  // String: interpretation and recommendations
      },

      forecasting: {
        value_column: "[VALUE_COLUMN]",           // String: name of the value column
        date_column: "[DATE_COLUMN]",              // String: name of the date column
        split_column: null,                        // Optional String: name of split column (null if not used)
        aggregation_freq: "[AGGREGATION_FREQ]",    // String: aggregation frequency (e.g., "D", "W", "M")
        aggregation_method: "[AGGREGATION_METHOD]", // String: aggregation method (e.g., "mean", "sum")
        forecast_horizon: 0,                       // Integer: number of periods to forecast
        data_context: {
          n_samples: 0,                           // Integer: number of samples/rows analyzed
          aggregation_freq: "[AGGREGATION_FREQ]",  // String: aggregation frequency
          aggregation_method: "[AGGREGATION_METHOD]", // String: aggregation method
          value_column: "[VALUE_COLUMN]",          // String: value column name
          date_column: "[DATE_COLUMN]"             // String: date column name
        },
        findings: [
          // Array of finding strings
          "[FINDING_1]",
          "[FINDING_2]"
        ],
        interpretation: "[INTERPRETATION_TEXT]",  // String: This will be displayed in the "Key Findings" section of Overall Findings
        time_series_data: {
          dates: ["[DATE_1]", "[DATE_2]"],         // Array of date strings
          values: [0, 0],                          // Array of numeric values
          is_forecast: [false, false]              // Array of booleans (all false for historical)
        },
        forecast_data: {
          dates: ["[FORECAST_DATE_1]", "[FORECAST_DATE_2]"], // Array of forecast date strings
          values: [0, 0],                          // Array of forecast values
          lower: [0, 0],                           // Array of lower confidence interval bounds
          upper: [0, 0]                            // Array of upper confidence interval bounds
        },
        forecast_accuracy: {
          mae: 0.0,                                // Float: Mean Absolute Error
          rmse: 0.0,                               // Float: Root Mean Squared Error
          mape: 0.0                                // Float: Mean Absolute Percentage Error (optional)
        },
        time_series_summary: {
          start_date: "[START_DATE]",              // String: start date of time series
          end_date: "[END_DATE]",                  // String: end date of time series
          n_observations: 0,                       // Integer: number of observations
          trend_direction: "[TREND_DIRECTION]"     // String: "increasing", "decreasing", or "stable"
        },
        trend_analysis: {
          trend_type: "[TREND_TYPE]"               // String: trend analysis result
        },
        seasonality_analysis: {
          has_seasonality: false,                  // Boolean: whether seasonality detected
          period: 0                                // Integer: seasonal period (if applicable)
        }
      },

      rootcause: {
        target_column: "[TARGET_COLUMN]",                  // String: name of the target variable
        data_context: {
          target_column: "[TARGET_COLUMN]",                 // String: target variable name
          n_samples: 0,                                     // Integer: number of samples/rows analyzed
          feature_columns: ["[FEATURE_1]", "[FEATURE_2]"], // Array: all features analyzed
          numeric_features: ["[NUMERIC_FEATURE_1]"],       // Array: numeric feature names
          categorical_features: ["[CATEGORICAL_FEATURE_1]"] // Array: categorical feature names
        },
        findings: [
          // Array of finding strings
          "[FINDING_1]",
          "[FINDING_2]"
        ],
        interpretation: "[INTERPRETATION_TEXT]",  // String: This will be displayed in the "Key Findings" section of Overall Findings
        root_causes: [
          // Array of root cause objects
          // {
          //   feature: "[FEATURE_NAME]",                    // String: feature name
          //   importance_score: 0.0,                       // Float: importance score (0-1)
          //   confidence: "[high|medium|low]",            // String: confidence level
          //   evidence: [                                  // Array of evidence objects
          //     { type: "correlation", strength: 0.0, direction: "positive|negative", significant: true|false },
          //     { type: "categorical_impact", f_ratio: 0.0, most_impactful: "[CATEGORY]" }
          //   ]
          // }
        ],
        feature_importance: {
          // Dictionary: { "[FEATURE_NAME]": importance_score (float) }
        },
        correlations: {
          top_correlated: [
            // Array of correlation objects
            // {
            //   feature: "[FEATURE_NAME]",                 // String: feature name
            //   pearson_corr: 0.0,                        // Float: Pearson correlation (-1 to 1)
            //   significant: true|false                   // Boolean: statistical significance
            // }
          ]
        },
        categorical_impacts: {
          // Dictionary: { "[FEATURE_NAME]": { f_ratio, n_categories, most_impactful_category, top_categories } }
          // "[CATEGORICAL_FEATURE_1]": {
          //   f_ratio: 0.0,                               // Float: F-ratio value
          //   n_categories: 0,                            // Integer: total number of categories
          //   most_impactful_category: "[CATEGORY]",      // String: most impactful category
          //   top_categories: [                           // Array: top 5 categories
          //     { category: "[CATEGORY]", mean: 0.0, difference_from_overall: 0.0, pct_difference: 0.0 }
          //   ]
          // }
        }
      }
    };    
"""
    return template


def generate_full_report(analysis_session_id: str, report_data: str):
    report = FULL_REPORT_TEMPLATE_WITH_PLACEHOLDERS.format(
        REPORT_HEADER = REPORT_HEADER,
        REPORT_BODY = REPORT_BODY,
        report_data = report_data,
        REPORT_SCRIPT_UTILITIES = REPORT_SCRIPT_UTILITIES,
        REPORT_SCRIPT_RENDER_KPIS_BY_ANALYSIS_TYPE = REPORT_SCRIPT_RENDER_KPIS_BY_ANALYSIS_TYPE,
        REPORT_SCRIPT_RENDER_META_AND_OVERALL = REPORT_SCRIPT_RENDER_META_AND_OVERALL,
        REPORT_SCRIPT_RENDER_ANALYSIS_ZONES = REPORT_SCRIPT_RENDER_ANALYSIS_ZONES,
        REPORT_SCRIPT_UTILITY_FUNCTIONS_FOR_FORMATTING = REPORT_SCRIPT_UTILITY_FUNCTIONS_FOR_FORMATTING,
        REPORT_SCRIPT_CHART_HELPERS = REPORT_SCRIPT_CHART_HELPERS,
        REPORT_SCRIPT_BUILD_ANALYSIS_ZONE_CHARTS = REPORT_SCRIPT_BUILD_ANALYSIS_ZONE_CHARTS,
    )

    return report